@extends('layouts.admin')
@section('page-title')
    {{__('Warehouse Report')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{ __('Warehouse Report') }}</li>
@endsection
@push('script-page')
    <script src="{{ asset('assets/js/plugins/apexcharts.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A2'}
            };
            html2pdf().set(opt).from(element).save();
        }
    </script>

    <script>
        (function () {
            var chartBarOptions = {
                series: [
                    {
                        name: '{{ __("Product") }}',
                        data:  {!! json_encode($warehouseProductData) !!},
                        // data:  [150,90,160,80],
                    },
                ],

                chart: {
                    height: 300,
                    type: 'area',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories: {!! json_encode($warehousename) !!},
                    title: {
                        text: '{{ __("Warehouse") }}'
                    }
                },
                colors: ['#6fd944'],


                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },

                {{--yaxis: {--}}
                {{--    title: {--}}
                {{--        text: '{{ __("Product") }}'--}}
                {{--    },--}}

                {{--}--}}

            };
            var arChart = new ApexCharts(document.querySelector("#warehouse_report"), chartBarOptions);
            arChart.render();
        })();

    </script>

@endpush
@section('action-btn')
    <div class="float-end">
        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="{{__('Download')}}" data-original-title="{{__('Download')}}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>
    </div>
@endsection

@section('content')

    <div id="printableArea">
        <div class="row mt-0 mb-4 gy-4">
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="top-svg" width="54" height="50" viewBox="0 0 54 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="21.2817" y="30.1494" width="26.6023" height="3.54698" fill="white"/>
                        <rect x="19.5083" y="5.3205" width="3.54698" height="28.3758" fill="white"/>
                        <rect class="color" opacity="0.5" x="23.0557" width="30.1493" height="30.1493" fill="#FF3A6E"/>
                        <rect x="4.57373" y="47.6042" width="15.4014" height="2.05351" fill="white"/>
                        <rect x="3.54688" y="33.2296" width="2.05351" height="16.4281" fill="white"/>
                        <rect class="color" opacity="0.4" x="5.60059" y="30.1494" width="17.4549" height="17.4549" fill="#FF3A6E"/>
                        <rect x="0.840332" y="24.9222" width="12.6011" height="1.68015" fill="white"/>
                        <rect y="13.1612" width="1.68015" height="13.4412" fill="white"/>
                        <rect class="color" opacity="0.2" x="1.68018" y="10.641" width="14.2813" height="14.2813" fill="#FF3A6E"/>
                    </svg>
                    <svg class="bg-svg" width="407" height="106" viewBox="0 0 407 106" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_32_1151)">
                        <path d="M541.931 135.492V137.921C532.132 129.331 521.28 121.191 508.71 114.554C486.225 102.632 462.49 97.8731 436.14 100.002C400.187 102.907 367.162 114.754 335.19 126.225C326.836 129.231 318.209 132.311 309.855 135.116C300.33 138.322 290.766 141.503 281.241 144.709C244.273 157.106 206.056 169.905 168.697 182.778C162.1 185.058 155.425 187.537 148.944 189.917C134.579 195.226 119.706 200.711 104.208 204.719C93.1995 207.574 83.245 208.976 74.1494 208.976C69.9724 208.976 65.9906 208.676 62.165 208.1C46.6673 205.72 34.1754 198.958 23.9477 192.672C11.2997 184.832 -0.255269 176.141 -11.3418 167.475V165.196C0.252213 174.313 12.3147 183.48 25.5873 191.695C35.5808 197.856 47.7603 204.468 62.7115 206.772C74.4617 208.576 87.7343 207.499 103.31 203.466C118.652 199.484 133.447 194.024 147.773 188.739C154.253 186.335 160.968 183.855 167.604 181.576C204.963 168.653 243.18 155.854 280.148 143.457C289.712 140.251 299.237 137.07 308.762 133.864C317.116 131.059 325.314 128.103 334.019 124.998C366.186 113.452 399.445 101.53 435.828 98.5995C462.841 96.4205 487.162 101.279 510.193 113.477C522.139 119.788 532.523 127.427 541.931 135.492Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 122.342V124.746C531.859 116.782 520.07 108.742 506.797 102.43C484.195 91.6857 460.655 87.3779 434.852 89.2062C398.586 91.811 365.249 103.257 332.965 114.327C325.197 116.982 317.155 119.737 309.348 122.267L294.006 127.251C253.056 140.525 210.74 154.25 169.4 168.05C163.818 169.929 158.079 172.033 151.989 174.262C129.699 182.452 104.911 191.543 79.3803 191.543C74.3446 191.543 69.3088 191.193 64.234 190.416C47.6823 187.862 33.9022 180.874 23.7916 175.038C11.2997 167.85 -0.255269 159.86 -11.3418 151.846V149.542C0.252213 157.982 12.3537 166.422 25.5092 173.986C35.4246 179.672 48.8534 186.534 64.8976 188.989C94.7219 193.572 124.507 182.652 150.779 173.009C156.869 170.78 162.646 168.652 168.268 166.773C209.608 152.948 251.963 139.223 292.874 125.948L308.255 120.964C316.023 118.435 324.065 115.68 331.794 113.025C364.273 101.879 397.845 90.3583 434.579 87.7285C461.046 85.825 485.171 90.2581 508.32 101.253C520.929 107.264 532.21 114.803 541.931 122.342Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 109.142V111.572C525.652 100.051 513.707 94.3401 505.509 90.8587C483.102 81.3663 460.109 77.4843 435.164 78.987C399.211 81.1409 365.991 91.8355 333.863 102.179C326.836 104.434 319.575 106.763 312.51 108.942C265.587 123.343 219.641 137.494 173.343 152.196C168.151 153.849 162.998 155.577 157.533 157.43C143.752 162.114 129.504 166.948 114.631 170.054C103.935 172.308 93.9021 173.41 84.299 173.41C78.7167 173.41 73.2906 173.034 67.9425 172.283C36.4005 167.774 11.0264 151.745 -11.3418 136.392V134.013C11.2607 149.616 36.83 166.222 68.5281 170.73C99.8358 175.188 128.528 165.445 156.283 156.053C161.749 154.2 166.941 152.446 172.132 150.793C218.508 136.091 264.455 121.941 311.378 107.514C318.443 105.335 325.665 103.006 332.692 100.752C365.015 90.3578 398.469 79.5881 434.93 77.3841C460.499 75.8563 484.078 79.8386 506.992 89.5563C520.187 95.1666 532.015 102.28 541.931 109.142Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 95.9702V98.3245C528.892 90.1846 516.517 84.0484 503.791 79.3648C481.462 71.1748 458.821 67.8688 434.54 69.2713C399.172 71.3 366.03 81.143 334.019 90.6605C327.227 92.6892 320.2 94.768 313.369 96.7215C263.167 111.023 219.172 123.746 178.847 135.643C174.319 136.97 169.712 138.398 165.223 139.775C141.254 147.139 116.583 154.703 89.7252 154.703C83.3231 154.703 76.8039 154.277 70.1676 153.325C38.3914 148.742 12.0414 134.365 -11.3418 120.29V117.96C12.2366 132.237 38.8599 147.114 70.7532 151.697C104.481 156.556 134.735 147.264 163.974 138.298C168.463 136.92 173.069 135.492 177.637 134.165C217.962 122.268 261.957 109.545 312.197 95.2438C319.029 93.2903 326.056 91.2115 332.809 89.2078C365.054 79.6152 398.391 69.7221 434.266 67.6433C459.133 66.2157 482.321 69.5969 505.158 77.9622C517.493 82.4705 529.439 88.3312 541.931 95.9702Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 82.8191V85.1484C528.736 78.0354 515.932 72.5253 503.089 68.4679C481.189 61.5552 459.328 58.7 436.14 59.802C401.358 61.43 368.294 70.2962 336.283 78.8619C329.92 80.565 323.284 82.3432 316.843 83.9963C273.668 95.1166 229.634 106.713 182.204 119.436C177.363 120.738 172.406 122.166 167.604 123.544C152.653 127.851 137.194 132.31 120.916 134.138C112.562 135.09 104.442 135.541 96.5957 135.541C88.8664 135.541 81.4493 135.09 74.3055 134.188C41.9048 130.03 13.7981 117.157 -11.3418 104.158V101.854C13.9933 115.053 42.3342 128.302 75.0082 132.46C89.0225 134.238 104.325 134.238 120.486 132.41C136.374 130.607 151.677 126.224 166.472 121.941C171.274 120.563 176.231 119.111 181.111 117.808C228.541 105.085 272.575 93.4886 315.789 82.3683C322.23 80.7153 328.827 78.937 335.19 77.2339C367.396 68.6181 400.734 59.7018 435.984 58.0238C459.68 56.8967 482.087 59.802 504.455 66.89C516.869 70.8472 529.244 76.0818 541.931 82.8191Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 69.5206V71.8499C522.763 62.9335 505.509 57.2481 487.63 53.917C466.082 49.8847 442.347 49.2836 417.012 52.0887C395.268 54.4931 374.149 59.2518 353.694 63.8602C350.844 64.5114 347.994 65.1376 345.184 65.7637C321.059 71.1486 295.021 77.0844 263.206 84.498C237.715 90.4339 210.623 96.8205 177.949 104.585C176.661 104.885 175.373 105.211 174.084 105.511C152.614 110.621 132.315 115.48 108.346 115.93C106.941 115.956 105.535 115.981 104.169 115.981C81.6055 115.981 58.8078 112.449 34.6829 105.211C18.5606 100.352 2.98481 94.1907 -11.3418 88.0044V85.7503C25.8996 101.905 63.8826 114.954 108.268 114.077C131.729 113.626 151.755 108.843 172.991 103.783C174.279 103.483 175.568 103.157 176.856 102.857C209.53 95.0924 236.622 88.7057 262.113 82.7698C293.928 75.3563 319.966 69.4204 344.13 64.0356C346.979 63.4094 349.79 62.7582 352.64 62.1321C373.212 57.4986 394.488 52.7148 416.465 50.2604C442.23 47.4051 466.472 48.0313 488.489 52.1388C509.1 56.0209 527.018 62.6831 541.931 69.5206Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 56.5716V58.8007C525.418 52.7396 508.749 48.2314 492.158 45.3511C468.307 41.1935 443.752 40.2668 419.12 42.546C397.142 44.5747 375.398 48.7573 354.357 52.8148C350.532 53.5411 346.589 54.3175 342.724 55.0438C320.356 59.2766 296.817 63.86 266.329 69.9461C240.603 75.0805 215.386 80.1898 187.435 85.8752L185.639 86.2509C161.28 91.21 138.248 95.8936 111.859 96.0188C111.391 96.0188 110.961 96.0188 110.493 96.0188C66.1468 95.9937 25.8605 85.1239 -11.3418 71.9498V69.7207C3.64844 75.0554 20.9419 80.6907 38.938 85.0487C64.4682 91.235 88.3198 94.1654 111.82 94.0652C137.741 93.94 160.499 89.3065 184.624 84.3975L186.42 84.0218C214.371 78.3364 239.588 73.2271 265.314 68.0927C295.802 62.0066 319.38 57.3981 341.749 53.1904C345.613 52.4641 349.556 51.7127 353.382 50.9614C374.54 46.9039 396.4 42.6963 418.612 40.6425C443.674 38.3132 468.697 39.29 493.017 43.4977C509.335 46.3279 525.73 50.7109 541.931 56.5716Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 43.3971V45.6011C524.481 40.617 506.836 36.9854 489.348 34.7813C465.184 31.7257 440.473 31.2499 415.841 33.3788C377.311 36.7099 338.508 43.3219 300.994 49.7086C290.415 51.5119 279.484 53.3653 268.827 55.1185C248.567 58.4246 227.994 61.8308 208.125 65.1368C202.503 66.0635 196.882 67.0153 191.222 67.942C165.379 72.2248 143.674 75.5058 119.237 75.6811C118.417 75.6811 117.598 75.6811 116.778 75.6811C92.8091 75.6811 68.489 73.3519 42.5684 68.6182C25.6653 65.5125 8.17674 61.405 -11.3418 55.945V53.741C8.60615 59.3763 26.368 63.559 43.5053 66.7147C69.9724 71.5736 94.761 73.8528 119.159 73.7025C143.167 73.5522 164.676 70.2963 190.285 66.0385C195.906 65.1118 201.566 64.1601 207.188 63.2334C227.097 59.9273 247.669 56.5211 267.929 53.215C278.587 51.4618 289.517 49.6084 300.057 47.8051C337.689 41.3934 376.57 34.7563 415.333 31.4252C440.317 29.2712 465.418 29.7471 489.972 32.8528C507.305 35.0067 524.715 38.5382 541.931 43.3971Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 30.1484V32.3525C500.161 23.7367 457.962 20.7813 416.192 23.5614C377.585 26.1411 338.469 31.2004 300.642 36.0843C290.688 37.3867 280.382 38.7141 270.311 39.9664C258.717 41.4191 246.849 43.0721 235.412 44.65C198.404 49.7844 160.109 55.1191 121.853 55.1191H121.697C80.5905 55.1191 37.923 50.2853 -11.3418 39.9664V37.7624C38.0401 48.1564 80.6686 53.0403 121.697 53.0403H121.853C159.758 53.0403 197.819 47.7557 234.67 42.6213C246.147 41.0183 258.014 39.3904 269.647 37.9127C279.719 36.6604 290.024 35.3329 299.979 34.0306C337.884 29.1216 377.077 24.0623 415.841 21.4575C457.728 18.7025 500.044 21.6078 541.931 30.1484Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 16.7996V19.0287C498.326 13.2932 454.605 11.4649 411.82 13.6439C373.447 15.5974 334.488 18.9786 296.778 22.2596C288.151 23.011 279.25 23.7874 270.506 24.5138C259.497 25.4404 248.294 26.4924 237.48 27.4942C201.254 30.8754 163.818 34.3818 126.654 34.3818H126.303C83.3621 34.3818 38.1572 30.9756 -11.3418 24.0379V21.8088C38.1962 28.7966 83.4012 32.2279 126.303 32.2279H126.654C163.544 32.2028 200.864 28.7214 236.934 25.3653C247.786 24.3635 258.99 23.3116 270.037 22.3598C278.782 21.6084 287.682 20.8571 296.309 20.1057C334.058 16.8247 373.056 13.4435 411.547 11.4899C454.449 9.31094 498.209 11.0892 541.931 16.7996Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 3.37436V5.65353C455.23 0.418959 367.631 4.27601 282.725 8.03289C278.158 8.23325 273.629 8.43362 269.062 8.63399C258.678 9.08481 248.138 9.58573 237.91 10.0866C202.777 11.7647 166.434 13.5179 130.558 13.543H129.192C84.3776 13.543 38.2358 11.7647 -11.3413 8.13307V5.8539C38.7433 9.53563 85.3145 11.3139 130.558 11.2638C166.277 11.2388 202.543 9.48554 237.637 7.80747C247.865 7.30656 258.444 6.80564 268.828 6.35482C273.395 6.15445 277.923 5.95408 282.491 5.75372C367.396 1.99685 455.074 -1.86021 541.931 3.37436Z" fill="#060606" fill-opacity="0.02"/>
                        </g>
                        <defs>
                        <clipPath id="clip0_32_1151">
                        <rect width="406.962" height="104.191" fill="white" transform="translate(0 0.819519)"/>
                        </clipPath>
                        </defs>
                    </svg>                                                
                    <p class="text-muted f-w-600">{{__('Report')}}:</p>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3">
                        <h4 class="mb-0">{{__('Warehouse Report')}}</h4>
                        <div class="warehouse-icon">
                            <div class="icon-inner">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.271 2.87233H4.20978V18.4831C4.20978 19.1701 4.76884 19.7292 5.45583 19.7292H17.1887V20.668C17.1887 21.023 16.8992 21.3125 16.5442 21.3125H3.271C2.91599 21.3125 2.62646 21.023 2.62646 20.668V3.51686C2.62651 3.1619 2.91603 2.87233 3.271 2.87233ZM5.45587 0.6875C5.10086 0.6875 4.81134 0.977023 4.81134 1.33203V18.4831C4.81134 18.8381 5.10086 19.1277 5.45587 19.1277H18.7291C19.0841 19.1277 19.3736 18.8381 19.3736 18.4831V4.28746H17.0198C16.3328 4.28746 15.7737 3.7284 15.7737 3.04137V0.6875H5.45587ZM7.2585 4.76205H12.8015C12.9676 4.76205 13.1022 4.62739 13.1022 4.46127C13.1022 4.29516 12.9676 4.16049 12.8015 4.16049H7.2585C7.09238 4.16049 6.95772 4.29516 6.95772 4.46127C6.95772 4.62735 7.09238 4.76205 7.2585 4.76205ZM7.2585 6.21225H10.4167C10.5828 6.21225 10.7175 6.07759 10.7175 5.91147C10.7175 5.74535 10.5828 5.61069 10.4167 5.61069H7.2585C7.09238 5.61069 6.95772 5.74535 6.95772 5.91147C6.95772 6.07754 7.09238 6.21225 7.2585 6.21225ZM16.3752 3.04141C16.3752 3.39642 16.6647 3.68595 17.0197 3.68595H19.3177C19.2865 3.6175 19.2421 3.55446 19.1848 3.49714L16.564 0.876305C16.5067 0.818984 16.4437 0.774641 16.3752 0.743402V3.04141H16.3752ZM7.47334 13.1185C7.355 13.1185 7.2585 13.215 7.2585 13.3333V16.0321C7.2585 16.1504 7.355 16.247 7.47334 16.247H8.55194C8.67028 16.247 8.76679 16.1504 8.76679 16.0321V13.3333C8.76679 13.215 8.67028 13.1185 8.55194 13.1185H7.47334ZM10.1932 11.7575C10.0749 11.7575 9.97838 11.854 9.97838 11.9723V16.0321C9.97838 16.1504 10.0749 16.247 10.1932 16.247H11.2718C11.3902 16.247 11.4867 16.1504 11.4867 16.0321C11.4867 14.6789 11.4867 13.3256 11.4867 11.9723C11.4867 11.854 11.3902 11.7575 11.2718 11.7575C10.9123 11.7575 10.5528 11.7575 10.1932 11.7575ZM12.9131 10.3964C12.7948 10.3964 12.6983 10.4929 12.6983 10.6112V16.0321C12.6983 16.1504 12.7948 16.2469 12.9131 16.2469H13.9917C14.1101 16.2469 14.2066 16.1504 14.2066 16.0321C14.2066 14.2251 14.2066 12.4182 14.2066 10.6112C14.2066 10.4929 14.1101 10.3964 13.9917 10.3964C13.6322 10.3964 13.2727 10.3964 12.9131 10.3964ZM15.6331 9.03534C15.5147 9.03534 15.4182 9.13185 15.4182 9.25018V16.0321C15.4182 16.1504 15.5147 16.2469 15.6331 16.2469H16.7117C16.83 16.2469 16.9265 16.1504 16.9265 16.0321V9.25018C16.9265 9.13185 16.83 9.03534 16.7117 9.03534H15.6331ZM13.9129 6.74876L14.3784 6.62797C13.761 7.5527 12.8977 8.37968 11.8507 9.04509C10.6097 9.83383 9.11384 10.3941 7.46578 10.6209C7.30164 10.6429 7.18644 10.7939 7.20848 10.9581C7.23052 11.1223 7.38152 11.2375 7.5457 11.2154C9.28482 10.9761 10.8632 10.3849 12.1727 9.55264C13.2473 8.86969 14.143 8.02334 14.8007 7.07438L14.8238 7.42448C14.8341 7.58996 14.9767 7.71568 15.1422 7.70529C15.3077 7.69489 15.4334 7.55236 15.423 7.38689L15.3397 6.12764C15.3248 5.90292 15.0908 5.8236 14.8778 5.8789L13.7625 6.16834C13.6023 6.20984 13.506 6.37347 13.5475 6.53374C13.589 6.69402 13.7526 6.79031 13.9129 6.74876Z" fill="white"/>
                                </svg>                                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="top-svg" width="54" height="50" viewBox="0 0 54 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="21.2817" y="30.1494" width="26.6023" height="3.54698" fill="white"/>
                        <rect x="19.5083" y="5.3205" width="3.54698" height="28.3758" fill="white"/>
                        <rect class="color" opacity="0.5" x="23.0557" width="30.1493" height="30.1493" fill="#FF3A6E"/>
                        <rect x="4.57373" y="47.6042" width="15.4014" height="2.05351" fill="white"/>
                        <rect x="3.54688" y="33.2296" width="2.05351" height="16.4281" fill="white"/>
                        <rect class="color" opacity="0.4" x="5.60059" y="30.1494" width="17.4549" height="17.4549" fill="#FF3A6E"/>
                        <rect x="0.840332" y="24.9222" width="12.6011" height="1.68015" fill="white"/>
                        <rect y="13.1612" width="1.68015" height="13.4412" fill="white"/>
                        <rect class="color" opacity="0.2" x="1.68018" y="10.641" width="14.2813" height="14.2813" fill="#FF3A6E"/>
                    </svg>
                    <svg class="bg-svg" width="407" height="106" viewBox="0 0 407 106" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_32_1151)">
                        <path d="M541.931 135.492V137.921C532.132 129.331 521.28 121.191 508.71 114.554C486.225 102.632 462.49 97.8731 436.14 100.002C400.187 102.907 367.162 114.754 335.19 126.225C326.836 129.231 318.209 132.311 309.855 135.116C300.33 138.322 290.766 141.503 281.241 144.709C244.273 157.106 206.056 169.905 168.697 182.778C162.1 185.058 155.425 187.537 148.944 189.917C134.579 195.226 119.706 200.711 104.208 204.719C93.1995 207.574 83.245 208.976 74.1494 208.976C69.9724 208.976 65.9906 208.676 62.165 208.1C46.6673 205.72 34.1754 198.958 23.9477 192.672C11.2997 184.832 -0.255269 176.141 -11.3418 167.475V165.196C0.252213 174.313 12.3147 183.48 25.5873 191.695C35.5808 197.856 47.7603 204.468 62.7115 206.772C74.4617 208.576 87.7343 207.499 103.31 203.466C118.652 199.484 133.447 194.024 147.773 188.739C154.253 186.335 160.968 183.855 167.604 181.576C204.963 168.653 243.18 155.854 280.148 143.457C289.712 140.251 299.237 137.07 308.762 133.864C317.116 131.059 325.314 128.103 334.019 124.998C366.186 113.452 399.445 101.53 435.828 98.5995C462.841 96.4205 487.162 101.279 510.193 113.477C522.139 119.788 532.523 127.427 541.931 135.492Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 122.342V124.746C531.859 116.782 520.07 108.742 506.797 102.43C484.195 91.6857 460.655 87.3779 434.852 89.2062C398.586 91.811 365.249 103.257 332.965 114.327C325.197 116.982 317.155 119.737 309.348 122.267L294.006 127.251C253.056 140.525 210.74 154.25 169.4 168.05C163.818 169.929 158.079 172.033 151.989 174.262C129.699 182.452 104.911 191.543 79.3803 191.543C74.3446 191.543 69.3088 191.193 64.234 190.416C47.6823 187.862 33.9022 180.874 23.7916 175.038C11.2997 167.85 -0.255269 159.86 -11.3418 151.846V149.542C0.252213 157.982 12.3537 166.422 25.5092 173.986C35.4246 179.672 48.8534 186.534 64.8976 188.989C94.7219 193.572 124.507 182.652 150.779 173.009C156.869 170.78 162.646 168.652 168.268 166.773C209.608 152.948 251.963 139.223 292.874 125.948L308.255 120.964C316.023 118.435 324.065 115.68 331.794 113.025C364.273 101.879 397.845 90.3583 434.579 87.7285C461.046 85.825 485.171 90.2581 508.32 101.253C520.929 107.264 532.21 114.803 541.931 122.342Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 109.142V111.572C525.652 100.051 513.707 94.3401 505.509 90.8587C483.102 81.3663 460.109 77.4843 435.164 78.987C399.211 81.1409 365.991 91.8355 333.863 102.179C326.836 104.434 319.575 106.763 312.51 108.942C265.587 123.343 219.641 137.494 173.343 152.196C168.151 153.849 162.998 155.577 157.533 157.43C143.752 162.114 129.504 166.948 114.631 170.054C103.935 172.308 93.9021 173.41 84.299 173.41C78.7167 173.41 73.2906 173.034 67.9425 172.283C36.4005 167.774 11.0264 151.745 -11.3418 136.392V134.013C11.2607 149.616 36.83 166.222 68.5281 170.73C99.8358 175.188 128.528 165.445 156.283 156.053C161.749 154.2 166.941 152.446 172.132 150.793C218.508 136.091 264.455 121.941 311.378 107.514C318.443 105.335 325.665 103.006 332.692 100.752C365.015 90.3578 398.469 79.5881 434.93 77.3841C460.499 75.8563 484.078 79.8386 506.992 89.5563C520.187 95.1666 532.015 102.28 541.931 109.142Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 95.9702V98.3245C528.892 90.1846 516.517 84.0484 503.791 79.3648C481.462 71.1748 458.821 67.8688 434.54 69.2713C399.172 71.3 366.03 81.143 334.019 90.6605C327.227 92.6892 320.2 94.768 313.369 96.7215C263.167 111.023 219.172 123.746 178.847 135.643C174.319 136.97 169.712 138.398 165.223 139.775C141.254 147.139 116.583 154.703 89.7252 154.703C83.3231 154.703 76.8039 154.277 70.1676 153.325C38.3914 148.742 12.0414 134.365 -11.3418 120.29V117.96C12.2366 132.237 38.8599 147.114 70.7532 151.697C104.481 156.556 134.735 147.264 163.974 138.298C168.463 136.92 173.069 135.492 177.637 134.165C217.962 122.268 261.957 109.545 312.197 95.2438C319.029 93.2903 326.056 91.2115 332.809 89.2078C365.054 79.6152 398.391 69.7221 434.266 67.6433C459.133 66.2157 482.321 69.5969 505.158 77.9622C517.493 82.4705 529.439 88.3312 541.931 95.9702Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 82.8191V85.1484C528.736 78.0354 515.932 72.5253 503.089 68.4679C481.189 61.5552 459.328 58.7 436.14 59.802C401.358 61.43 368.294 70.2962 336.283 78.8619C329.92 80.565 323.284 82.3432 316.843 83.9963C273.668 95.1166 229.634 106.713 182.204 119.436C177.363 120.738 172.406 122.166 167.604 123.544C152.653 127.851 137.194 132.31 120.916 134.138C112.562 135.09 104.442 135.541 96.5957 135.541C88.8664 135.541 81.4493 135.09 74.3055 134.188C41.9048 130.03 13.7981 117.157 -11.3418 104.158V101.854C13.9933 115.053 42.3342 128.302 75.0082 132.46C89.0225 134.238 104.325 134.238 120.486 132.41C136.374 130.607 151.677 126.224 166.472 121.941C171.274 120.563 176.231 119.111 181.111 117.808C228.541 105.085 272.575 93.4886 315.789 82.3683C322.23 80.7153 328.827 78.937 335.19 77.2339C367.396 68.6181 400.734 59.7018 435.984 58.0238C459.68 56.8967 482.087 59.802 504.455 66.89C516.869 70.8472 529.244 76.0818 541.931 82.8191Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 69.5206V71.8499C522.763 62.9335 505.509 57.2481 487.63 53.917C466.082 49.8847 442.347 49.2836 417.012 52.0887C395.268 54.4931 374.149 59.2518 353.694 63.8602C350.844 64.5114 347.994 65.1376 345.184 65.7637C321.059 71.1486 295.021 77.0844 263.206 84.498C237.715 90.4339 210.623 96.8205 177.949 104.585C176.661 104.885 175.373 105.211 174.084 105.511C152.614 110.621 132.315 115.48 108.346 115.93C106.941 115.956 105.535 115.981 104.169 115.981C81.6055 115.981 58.8078 112.449 34.6829 105.211C18.5606 100.352 2.98481 94.1907 -11.3418 88.0044V85.7503C25.8996 101.905 63.8826 114.954 108.268 114.077C131.729 113.626 151.755 108.843 172.991 103.783C174.279 103.483 175.568 103.157 176.856 102.857C209.53 95.0924 236.622 88.7057 262.113 82.7698C293.928 75.3563 319.966 69.4204 344.13 64.0356C346.979 63.4094 349.79 62.7582 352.64 62.1321C373.212 57.4986 394.488 52.7148 416.465 50.2604C442.23 47.4051 466.472 48.0313 488.489 52.1388C509.1 56.0209 527.018 62.6831 541.931 69.5206Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 56.5716V58.8007C525.418 52.7396 508.749 48.2314 492.158 45.3511C468.307 41.1935 443.752 40.2668 419.12 42.546C397.142 44.5747 375.398 48.7573 354.357 52.8148C350.532 53.5411 346.589 54.3175 342.724 55.0438C320.356 59.2766 296.817 63.86 266.329 69.9461C240.603 75.0805 215.386 80.1898 187.435 85.8752L185.639 86.2509C161.28 91.21 138.248 95.8936 111.859 96.0188C111.391 96.0188 110.961 96.0188 110.493 96.0188C66.1468 95.9937 25.8605 85.1239 -11.3418 71.9498V69.7207C3.64844 75.0554 20.9419 80.6907 38.938 85.0487C64.4682 91.235 88.3198 94.1654 111.82 94.0652C137.741 93.94 160.499 89.3065 184.624 84.3975L186.42 84.0218C214.371 78.3364 239.588 73.2271 265.314 68.0927C295.802 62.0066 319.38 57.3981 341.749 53.1904C345.613 52.4641 349.556 51.7127 353.382 50.9614C374.54 46.9039 396.4 42.6963 418.612 40.6425C443.674 38.3132 468.697 39.29 493.017 43.4977C509.335 46.3279 525.73 50.7109 541.931 56.5716Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 43.3971V45.6011C524.481 40.617 506.836 36.9854 489.348 34.7813C465.184 31.7257 440.473 31.2499 415.841 33.3788C377.311 36.7099 338.508 43.3219 300.994 49.7086C290.415 51.5119 279.484 53.3653 268.827 55.1185C248.567 58.4246 227.994 61.8308 208.125 65.1368C202.503 66.0635 196.882 67.0153 191.222 67.942C165.379 72.2248 143.674 75.5058 119.237 75.6811C118.417 75.6811 117.598 75.6811 116.778 75.6811C92.8091 75.6811 68.489 73.3519 42.5684 68.6182C25.6653 65.5125 8.17674 61.405 -11.3418 55.945V53.741C8.60615 59.3763 26.368 63.559 43.5053 66.7147C69.9724 71.5736 94.761 73.8528 119.159 73.7025C143.167 73.5522 164.676 70.2963 190.285 66.0385C195.906 65.1118 201.566 64.1601 207.188 63.2334C227.097 59.9273 247.669 56.5211 267.929 53.215C278.587 51.4618 289.517 49.6084 300.057 47.8051C337.689 41.3934 376.57 34.7563 415.333 31.4252C440.317 29.2712 465.418 29.7471 489.972 32.8528C507.305 35.0067 524.715 38.5382 541.931 43.3971Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 30.1484V32.3525C500.161 23.7367 457.962 20.7813 416.192 23.5614C377.585 26.1411 338.469 31.2004 300.642 36.0843C290.688 37.3867 280.382 38.7141 270.311 39.9664C258.717 41.4191 246.849 43.0721 235.412 44.65C198.404 49.7844 160.109 55.1191 121.853 55.1191H121.697C80.5905 55.1191 37.923 50.2853 -11.3418 39.9664V37.7624C38.0401 48.1564 80.6686 53.0403 121.697 53.0403H121.853C159.758 53.0403 197.819 47.7557 234.67 42.6213C246.147 41.0183 258.014 39.3904 269.647 37.9127C279.719 36.6604 290.024 35.3329 299.979 34.0306C337.884 29.1216 377.077 24.0623 415.841 21.4575C457.728 18.7025 500.044 21.6078 541.931 30.1484Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 16.7996V19.0287C498.326 13.2932 454.605 11.4649 411.82 13.6439C373.447 15.5974 334.488 18.9786 296.778 22.2596C288.151 23.011 279.25 23.7874 270.506 24.5138C259.497 25.4404 248.294 26.4924 237.48 27.4942C201.254 30.8754 163.818 34.3818 126.654 34.3818H126.303C83.3621 34.3818 38.1572 30.9756 -11.3418 24.0379V21.8088C38.1962 28.7966 83.4012 32.2279 126.303 32.2279H126.654C163.544 32.2028 200.864 28.7214 236.934 25.3653C247.786 24.3635 258.99 23.3116 270.037 22.3598C278.782 21.6084 287.682 20.8571 296.309 20.1057C334.058 16.8247 373.056 13.4435 411.547 11.4899C454.449 9.31094 498.209 11.0892 541.931 16.7996Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 3.37436V5.65353C455.23 0.418959 367.631 4.27601 282.725 8.03289C278.158 8.23325 273.629 8.43362 269.062 8.63399C258.678 9.08481 248.138 9.58573 237.91 10.0866C202.777 11.7647 166.434 13.5179 130.558 13.543H129.192C84.3776 13.543 38.2358 11.7647 -11.3413 8.13307V5.8539C38.7433 9.53563 85.3145 11.3139 130.558 11.2638C166.277 11.2388 202.543 9.48554 237.637 7.80747C247.865 7.30656 258.444 6.80564 268.828 6.35482C273.395 6.15445 277.923 5.95408 282.491 5.75372C367.396 1.99685 455.074 -1.86021 541.931 3.37436Z" fill="#060606" fill-opacity="0.02"/>
                        </g>
                        <defs>
                        <clipPath id="clip0_32_1151">
                        <rect width="406.962" height="104.191" fill="white" transform="translate(0 0.819519)"/>
                        </clipPath>
                        </defs>
                    </svg>                                                
                    <p class="text-muted f-w-600">{{__('Total Warehouse')}}:</p>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3">
                        <h4 class="mb-0">{{$totalWarehouse}}</h4>
                        <div class="warehouse-icon">
                            <div class="icon-inner">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.271 2.87233H4.20978V18.4831C4.20978 19.1701 4.76884 19.7292 5.45583 19.7292H17.1887V20.668C17.1887 21.023 16.8992 21.3125 16.5442 21.3125H3.271C2.91599 21.3125 2.62646 21.023 2.62646 20.668V3.51686C2.62651 3.1619 2.91603 2.87233 3.271 2.87233ZM5.45587 0.6875C5.10086 0.6875 4.81134 0.977023 4.81134 1.33203V18.4831C4.81134 18.8381 5.10086 19.1277 5.45587 19.1277H18.7291C19.0841 19.1277 19.3736 18.8381 19.3736 18.4831V4.28746H17.0198C16.3328 4.28746 15.7737 3.7284 15.7737 3.04137V0.6875H5.45587ZM7.2585 4.76205H12.8015C12.9676 4.76205 13.1022 4.62739 13.1022 4.46127C13.1022 4.29516 12.9676 4.16049 12.8015 4.16049H7.2585C7.09238 4.16049 6.95772 4.29516 6.95772 4.46127C6.95772 4.62735 7.09238 4.76205 7.2585 4.76205ZM7.2585 6.21225H10.4167C10.5828 6.21225 10.7175 6.07759 10.7175 5.91147C10.7175 5.74535 10.5828 5.61069 10.4167 5.61069H7.2585C7.09238 5.61069 6.95772 5.74535 6.95772 5.91147C6.95772 6.07754 7.09238 6.21225 7.2585 6.21225ZM16.3752 3.04141C16.3752 3.39642 16.6647 3.68595 17.0197 3.68595H19.3177C19.2865 3.6175 19.2421 3.55446 19.1848 3.49714L16.564 0.876305C16.5067 0.818984 16.4437 0.774641 16.3752 0.743402V3.04141H16.3752ZM7.47334 13.1185C7.355 13.1185 7.2585 13.215 7.2585 13.3333V16.0321C7.2585 16.1504 7.355 16.247 7.47334 16.247H8.55194C8.67028 16.247 8.76679 16.1504 8.76679 16.0321V13.3333C8.76679 13.215 8.67028 13.1185 8.55194 13.1185H7.47334ZM10.1932 11.7575C10.0749 11.7575 9.97838 11.854 9.97838 11.9723V16.0321C9.97838 16.1504 10.0749 16.247 10.1932 16.247H11.2718C11.3902 16.247 11.4867 16.1504 11.4867 16.0321C11.4867 14.6789 11.4867 13.3256 11.4867 11.9723C11.4867 11.854 11.3902 11.7575 11.2718 11.7575C10.9123 11.7575 10.5528 11.7575 10.1932 11.7575ZM12.9131 10.3964C12.7948 10.3964 12.6983 10.4929 12.6983 10.6112V16.0321C12.6983 16.1504 12.7948 16.2469 12.9131 16.2469H13.9917C14.1101 16.2469 14.2066 16.1504 14.2066 16.0321C14.2066 14.2251 14.2066 12.4182 14.2066 10.6112C14.2066 10.4929 14.1101 10.3964 13.9917 10.3964C13.6322 10.3964 13.2727 10.3964 12.9131 10.3964ZM15.6331 9.03534C15.5147 9.03534 15.4182 9.13185 15.4182 9.25018V16.0321C15.4182 16.1504 15.5147 16.2469 15.6331 16.2469H16.7117C16.83 16.2469 16.9265 16.1504 16.9265 16.0321V9.25018C16.9265 9.13185 16.83 9.03534 16.7117 9.03534H15.6331ZM13.9129 6.74876L14.3784 6.62797C13.761 7.5527 12.8977 8.37968 11.8507 9.04509C10.6097 9.83383 9.11384 10.3941 7.46578 10.6209C7.30164 10.6429 7.18644 10.7939 7.20848 10.9581C7.23052 11.1223 7.38152 11.2375 7.5457 11.2154C9.28482 10.9761 10.8632 10.3849 12.1727 9.55264C13.2473 8.86969 14.143 8.02334 14.8007 7.07438L14.8238 7.42448C14.8341 7.58996 14.9767 7.71568 15.1422 7.70529C15.3077 7.69489 15.4334 7.55236 15.423 7.38689L15.3397 6.12764C15.3248 5.90292 15.0908 5.8236 14.8778 5.8789L13.7625 6.16834C13.6023 6.20984 13.506 6.37347 13.5475 6.53374C13.589 6.69402 13.7526 6.79031 13.9129 6.74876Z" fill="white"/>
                                </svg>                                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6 col-12 warehouse-card">
                <div class="warehouse-card-inner">
                    <svg class="top-svg" width="54" height="50" viewBox="0 0 54 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="21.2817" y="30.1494" width="26.6023" height="3.54698" fill="white"/>
                        <rect x="19.5083" y="5.3205" width="3.54698" height="28.3758" fill="white"/>
                        <rect class="color" opacity="0.5" x="23.0557" width="30.1493" height="30.1493" fill="#FF3A6E"/>
                        <rect x="4.57373" y="47.6042" width="15.4014" height="2.05351" fill="white"/>
                        <rect x="3.54688" y="33.2296" width="2.05351" height="16.4281" fill="white"/>
                        <rect class="color" opacity="0.4" x="5.60059" y="30.1494" width="17.4549" height="17.4549" fill="#FF3A6E"/>
                        <rect x="0.840332" y="24.9222" width="12.6011" height="1.68015" fill="white"/>
                        <rect y="13.1612" width="1.68015" height="13.4412" fill="white"/>
                        <rect class="color" opacity="0.2" x="1.68018" y="10.641" width="14.2813" height="14.2813" fill="#FF3A6E"/>
                    </svg>
                    <svg class="bg-svg" width="407" height="106" viewBox="0 0 407 106" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_32_1151)">
                        <path d="M541.931 135.492V137.921C532.132 129.331 521.28 121.191 508.71 114.554C486.225 102.632 462.49 97.8731 436.14 100.002C400.187 102.907 367.162 114.754 335.19 126.225C326.836 129.231 318.209 132.311 309.855 135.116C300.33 138.322 290.766 141.503 281.241 144.709C244.273 157.106 206.056 169.905 168.697 182.778C162.1 185.058 155.425 187.537 148.944 189.917C134.579 195.226 119.706 200.711 104.208 204.719C93.1995 207.574 83.245 208.976 74.1494 208.976C69.9724 208.976 65.9906 208.676 62.165 208.1C46.6673 205.72 34.1754 198.958 23.9477 192.672C11.2997 184.832 -0.255269 176.141 -11.3418 167.475V165.196C0.252213 174.313 12.3147 183.48 25.5873 191.695C35.5808 197.856 47.7603 204.468 62.7115 206.772C74.4617 208.576 87.7343 207.499 103.31 203.466C118.652 199.484 133.447 194.024 147.773 188.739C154.253 186.335 160.968 183.855 167.604 181.576C204.963 168.653 243.18 155.854 280.148 143.457C289.712 140.251 299.237 137.07 308.762 133.864C317.116 131.059 325.314 128.103 334.019 124.998C366.186 113.452 399.445 101.53 435.828 98.5995C462.841 96.4205 487.162 101.279 510.193 113.477C522.139 119.788 532.523 127.427 541.931 135.492Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 122.342V124.746C531.859 116.782 520.07 108.742 506.797 102.43C484.195 91.6857 460.655 87.3779 434.852 89.2062C398.586 91.811 365.249 103.257 332.965 114.327C325.197 116.982 317.155 119.737 309.348 122.267L294.006 127.251C253.056 140.525 210.74 154.25 169.4 168.05C163.818 169.929 158.079 172.033 151.989 174.262C129.699 182.452 104.911 191.543 79.3803 191.543C74.3446 191.543 69.3088 191.193 64.234 190.416C47.6823 187.862 33.9022 180.874 23.7916 175.038C11.2997 167.85 -0.255269 159.86 -11.3418 151.846V149.542C0.252213 157.982 12.3537 166.422 25.5092 173.986C35.4246 179.672 48.8534 186.534 64.8976 188.989C94.7219 193.572 124.507 182.652 150.779 173.009C156.869 170.78 162.646 168.652 168.268 166.773C209.608 152.948 251.963 139.223 292.874 125.948L308.255 120.964C316.023 118.435 324.065 115.68 331.794 113.025C364.273 101.879 397.845 90.3583 434.579 87.7285C461.046 85.825 485.171 90.2581 508.32 101.253C520.929 107.264 532.21 114.803 541.931 122.342Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 109.142V111.572C525.652 100.051 513.707 94.3401 505.509 90.8587C483.102 81.3663 460.109 77.4843 435.164 78.987C399.211 81.1409 365.991 91.8355 333.863 102.179C326.836 104.434 319.575 106.763 312.51 108.942C265.587 123.343 219.641 137.494 173.343 152.196C168.151 153.849 162.998 155.577 157.533 157.43C143.752 162.114 129.504 166.948 114.631 170.054C103.935 172.308 93.9021 173.41 84.299 173.41C78.7167 173.41 73.2906 173.034 67.9425 172.283C36.4005 167.774 11.0264 151.745 -11.3418 136.392V134.013C11.2607 149.616 36.83 166.222 68.5281 170.73C99.8358 175.188 128.528 165.445 156.283 156.053C161.749 154.2 166.941 152.446 172.132 150.793C218.508 136.091 264.455 121.941 311.378 107.514C318.443 105.335 325.665 103.006 332.692 100.752C365.015 90.3578 398.469 79.5881 434.93 77.3841C460.499 75.8563 484.078 79.8386 506.992 89.5563C520.187 95.1666 532.015 102.28 541.931 109.142Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 95.9702V98.3245C528.892 90.1846 516.517 84.0484 503.791 79.3648C481.462 71.1748 458.821 67.8688 434.54 69.2713C399.172 71.3 366.03 81.143 334.019 90.6605C327.227 92.6892 320.2 94.768 313.369 96.7215C263.167 111.023 219.172 123.746 178.847 135.643C174.319 136.97 169.712 138.398 165.223 139.775C141.254 147.139 116.583 154.703 89.7252 154.703C83.3231 154.703 76.8039 154.277 70.1676 153.325C38.3914 148.742 12.0414 134.365 -11.3418 120.29V117.96C12.2366 132.237 38.8599 147.114 70.7532 151.697C104.481 156.556 134.735 147.264 163.974 138.298C168.463 136.92 173.069 135.492 177.637 134.165C217.962 122.268 261.957 109.545 312.197 95.2438C319.029 93.2903 326.056 91.2115 332.809 89.2078C365.054 79.6152 398.391 69.7221 434.266 67.6433C459.133 66.2157 482.321 69.5969 505.158 77.9622C517.493 82.4705 529.439 88.3312 541.931 95.9702Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 82.8191V85.1484C528.736 78.0354 515.932 72.5253 503.089 68.4679C481.189 61.5552 459.328 58.7 436.14 59.802C401.358 61.43 368.294 70.2962 336.283 78.8619C329.92 80.565 323.284 82.3432 316.843 83.9963C273.668 95.1166 229.634 106.713 182.204 119.436C177.363 120.738 172.406 122.166 167.604 123.544C152.653 127.851 137.194 132.31 120.916 134.138C112.562 135.09 104.442 135.541 96.5957 135.541C88.8664 135.541 81.4493 135.09 74.3055 134.188C41.9048 130.03 13.7981 117.157 -11.3418 104.158V101.854C13.9933 115.053 42.3342 128.302 75.0082 132.46C89.0225 134.238 104.325 134.238 120.486 132.41C136.374 130.607 151.677 126.224 166.472 121.941C171.274 120.563 176.231 119.111 181.111 117.808C228.541 105.085 272.575 93.4886 315.789 82.3683C322.23 80.7153 328.827 78.937 335.19 77.2339C367.396 68.6181 400.734 59.7018 435.984 58.0238C459.68 56.8967 482.087 59.802 504.455 66.89C516.869 70.8472 529.244 76.0818 541.931 82.8191Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 69.5206V71.8499C522.763 62.9335 505.509 57.2481 487.63 53.917C466.082 49.8847 442.347 49.2836 417.012 52.0887C395.268 54.4931 374.149 59.2518 353.694 63.8602C350.844 64.5114 347.994 65.1376 345.184 65.7637C321.059 71.1486 295.021 77.0844 263.206 84.498C237.715 90.4339 210.623 96.8205 177.949 104.585C176.661 104.885 175.373 105.211 174.084 105.511C152.614 110.621 132.315 115.48 108.346 115.93C106.941 115.956 105.535 115.981 104.169 115.981C81.6055 115.981 58.8078 112.449 34.6829 105.211C18.5606 100.352 2.98481 94.1907 -11.3418 88.0044V85.7503C25.8996 101.905 63.8826 114.954 108.268 114.077C131.729 113.626 151.755 108.843 172.991 103.783C174.279 103.483 175.568 103.157 176.856 102.857C209.53 95.0924 236.622 88.7057 262.113 82.7698C293.928 75.3563 319.966 69.4204 344.13 64.0356C346.979 63.4094 349.79 62.7582 352.64 62.1321C373.212 57.4986 394.488 52.7148 416.465 50.2604C442.23 47.4051 466.472 48.0313 488.489 52.1388C509.1 56.0209 527.018 62.6831 541.931 69.5206Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 56.5716V58.8007C525.418 52.7396 508.749 48.2314 492.158 45.3511C468.307 41.1935 443.752 40.2668 419.12 42.546C397.142 44.5747 375.398 48.7573 354.357 52.8148C350.532 53.5411 346.589 54.3175 342.724 55.0438C320.356 59.2766 296.817 63.86 266.329 69.9461C240.603 75.0805 215.386 80.1898 187.435 85.8752L185.639 86.2509C161.28 91.21 138.248 95.8936 111.859 96.0188C111.391 96.0188 110.961 96.0188 110.493 96.0188C66.1468 95.9937 25.8605 85.1239 -11.3418 71.9498V69.7207C3.64844 75.0554 20.9419 80.6907 38.938 85.0487C64.4682 91.235 88.3198 94.1654 111.82 94.0652C137.741 93.94 160.499 89.3065 184.624 84.3975L186.42 84.0218C214.371 78.3364 239.588 73.2271 265.314 68.0927C295.802 62.0066 319.38 57.3981 341.749 53.1904C345.613 52.4641 349.556 51.7127 353.382 50.9614C374.54 46.9039 396.4 42.6963 418.612 40.6425C443.674 38.3132 468.697 39.29 493.017 43.4977C509.335 46.3279 525.73 50.7109 541.931 56.5716Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 43.3971V45.6011C524.481 40.617 506.836 36.9854 489.348 34.7813C465.184 31.7257 440.473 31.2499 415.841 33.3788C377.311 36.7099 338.508 43.3219 300.994 49.7086C290.415 51.5119 279.484 53.3653 268.827 55.1185C248.567 58.4246 227.994 61.8308 208.125 65.1368C202.503 66.0635 196.882 67.0153 191.222 67.942C165.379 72.2248 143.674 75.5058 119.237 75.6811C118.417 75.6811 117.598 75.6811 116.778 75.6811C92.8091 75.6811 68.489 73.3519 42.5684 68.6182C25.6653 65.5125 8.17674 61.405 -11.3418 55.945V53.741C8.60615 59.3763 26.368 63.559 43.5053 66.7147C69.9724 71.5736 94.761 73.8528 119.159 73.7025C143.167 73.5522 164.676 70.2963 190.285 66.0385C195.906 65.1118 201.566 64.1601 207.188 63.2334C227.097 59.9273 247.669 56.5211 267.929 53.215C278.587 51.4618 289.517 49.6084 300.057 47.8051C337.689 41.3934 376.57 34.7563 415.333 31.4252C440.317 29.2712 465.418 29.7471 489.972 32.8528C507.305 35.0067 524.715 38.5382 541.931 43.3971Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 30.1484V32.3525C500.161 23.7367 457.962 20.7813 416.192 23.5614C377.585 26.1411 338.469 31.2004 300.642 36.0843C290.688 37.3867 280.382 38.7141 270.311 39.9664C258.717 41.4191 246.849 43.0721 235.412 44.65C198.404 49.7844 160.109 55.1191 121.853 55.1191H121.697C80.5905 55.1191 37.923 50.2853 -11.3418 39.9664V37.7624C38.0401 48.1564 80.6686 53.0403 121.697 53.0403H121.853C159.758 53.0403 197.819 47.7557 234.67 42.6213C246.147 41.0183 258.014 39.3904 269.647 37.9127C279.719 36.6604 290.024 35.3329 299.979 34.0306C337.884 29.1216 377.077 24.0623 415.841 21.4575C457.728 18.7025 500.044 21.6078 541.931 30.1484Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 16.7996V19.0287C498.326 13.2932 454.605 11.4649 411.82 13.6439C373.447 15.5974 334.488 18.9786 296.778 22.2596C288.151 23.011 279.25 23.7874 270.506 24.5138C259.497 25.4404 248.294 26.4924 237.48 27.4942C201.254 30.8754 163.818 34.3818 126.654 34.3818H126.303C83.3621 34.3818 38.1572 30.9756 -11.3418 24.0379V21.8088C38.1962 28.7966 83.4012 32.2279 126.303 32.2279H126.654C163.544 32.2028 200.864 28.7214 236.934 25.3653C247.786 24.3635 258.99 23.3116 270.037 22.3598C278.782 21.6084 287.682 20.8571 296.309 20.1057C334.058 16.8247 373.056 13.4435 411.547 11.4899C454.449 9.31094 498.209 11.0892 541.931 16.7996Z" fill="#060606" fill-opacity="0.02"/>
                        <path d="M541.931 3.37436V5.65353C455.23 0.418959 367.631 4.27601 282.725 8.03289C278.158 8.23325 273.629 8.43362 269.062 8.63399C258.678 9.08481 248.138 9.58573 237.91 10.0866C202.777 11.7647 166.434 13.5179 130.558 13.543H129.192C84.3776 13.543 38.2358 11.7647 -11.3413 8.13307V5.8539C38.7433 9.53563 85.3145 11.3139 130.558 11.2638C166.277 11.2388 202.543 9.48554 237.637 7.80747C247.865 7.30656 258.444 6.80564 268.828 6.35482C273.395 6.15445 277.923 5.95408 282.491 5.75372C367.396 1.99685 455.074 -1.86021 541.931 3.37436Z" fill="#060606" fill-opacity="0.02"/>
                        </g>
                        <defs>
                        <clipPath id="clip0_32_1151">
                        <rect width="406.962" height="104.191" fill="white" transform="translate(0 0.819519)"/>
                        </clipPath>
                        </defs>
                    </svg>                                                
                    <p class="text-muted f-w-600">{{__('Total Product')}}:</p>
                    <div class="info-wrp d-flex align-items-center justify-content-between gap-3">
                        <h4 class="mb-0">{{$totalProduct}}</h4>
                        <div class="warehouse-icon">
                            <div class="icon-inner">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.271 2.87233H4.20978V18.4831C4.20978 19.1701 4.76884 19.7292 5.45583 19.7292H17.1887V20.668C17.1887 21.023 16.8992 21.3125 16.5442 21.3125H3.271C2.91599 21.3125 2.62646 21.023 2.62646 20.668V3.51686C2.62651 3.1619 2.91603 2.87233 3.271 2.87233ZM5.45587 0.6875C5.10086 0.6875 4.81134 0.977023 4.81134 1.33203V18.4831C4.81134 18.8381 5.10086 19.1277 5.45587 19.1277H18.7291C19.0841 19.1277 19.3736 18.8381 19.3736 18.4831V4.28746H17.0198C16.3328 4.28746 15.7737 3.7284 15.7737 3.04137V0.6875H5.45587ZM7.2585 4.76205H12.8015C12.9676 4.76205 13.1022 4.62739 13.1022 4.46127C13.1022 4.29516 12.9676 4.16049 12.8015 4.16049H7.2585C7.09238 4.16049 6.95772 4.29516 6.95772 4.46127C6.95772 4.62735 7.09238 4.76205 7.2585 4.76205ZM7.2585 6.21225H10.4167C10.5828 6.21225 10.7175 6.07759 10.7175 5.91147C10.7175 5.74535 10.5828 5.61069 10.4167 5.61069H7.2585C7.09238 5.61069 6.95772 5.74535 6.95772 5.91147C6.95772 6.07754 7.09238 6.21225 7.2585 6.21225ZM16.3752 3.04141C16.3752 3.39642 16.6647 3.68595 17.0197 3.68595H19.3177C19.2865 3.6175 19.2421 3.55446 19.1848 3.49714L16.564 0.876305C16.5067 0.818984 16.4437 0.774641 16.3752 0.743402V3.04141H16.3752ZM7.47334 13.1185C7.355 13.1185 7.2585 13.215 7.2585 13.3333V16.0321C7.2585 16.1504 7.355 16.247 7.47334 16.247H8.55194C8.67028 16.247 8.76679 16.1504 8.76679 16.0321V13.3333C8.76679 13.215 8.67028 13.1185 8.55194 13.1185H7.47334ZM10.1932 11.7575C10.0749 11.7575 9.97838 11.854 9.97838 11.9723V16.0321C9.97838 16.1504 10.0749 16.247 10.1932 16.247H11.2718C11.3902 16.247 11.4867 16.1504 11.4867 16.0321C11.4867 14.6789 11.4867 13.3256 11.4867 11.9723C11.4867 11.854 11.3902 11.7575 11.2718 11.7575C10.9123 11.7575 10.5528 11.7575 10.1932 11.7575ZM12.9131 10.3964C12.7948 10.3964 12.6983 10.4929 12.6983 10.6112V16.0321C12.6983 16.1504 12.7948 16.2469 12.9131 16.2469H13.9917C14.1101 16.2469 14.2066 16.1504 14.2066 16.0321C14.2066 14.2251 14.2066 12.4182 14.2066 10.6112C14.2066 10.4929 14.1101 10.3964 13.9917 10.3964C13.6322 10.3964 13.2727 10.3964 12.9131 10.3964ZM15.6331 9.03534C15.5147 9.03534 15.4182 9.13185 15.4182 9.25018V16.0321C15.4182 16.1504 15.5147 16.2469 15.6331 16.2469H16.7117C16.83 16.2469 16.9265 16.1504 16.9265 16.0321V9.25018C16.9265 9.13185 16.83 9.03534 16.7117 9.03534H15.6331ZM13.9129 6.74876L14.3784 6.62797C13.761 7.5527 12.8977 8.37968 11.8507 9.04509C10.6097 9.83383 9.11384 10.3941 7.46578 10.6209C7.30164 10.6429 7.18644 10.7939 7.20848 10.9581C7.23052 11.1223 7.38152 11.2375 7.5457 11.2154C9.28482 10.9761 10.8632 10.3849 12.1727 9.55264C13.2473 8.86969 14.143 8.02334 14.8007 7.07438L14.8238 7.42448C14.8341 7.58996 14.9767 7.71568 15.1422 7.70529C15.3077 7.69489 15.4334 7.55236 15.423 7.38689L15.3397 6.12764C15.3248 5.90292 15.0908 5.8236 14.8778 5.8789L13.7625 6.16834C13.6023 6.20984 13.506 6.37347 13.5475 6.53374C13.589 6.69402 13.7526 6.79031 13.9129 6.74876Z" fill="white"/>
                                </svg>                                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row ">
                            <div class="col-6">
                                <h6>{{ __('Warehouse Report') }}</h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="warehouse_report"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection



