<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Invoice Summary')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Invoice Summary')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('theme-script'); ?>
    <script src="<?php echo e(asset('assets/js/plugins/apexcharts.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css-page'); ?>
<style>
    .apexcharts-yaxis
    {
        transform: translate(30px, 0px) !important;
    }
    /* 20.01  */
    #printableArea .dataTable-top .dataTable-search{
        max-width: 190px;
        width: 100%;
        margin-left: auto;
    }
    @media screen and (max-width:480px){
        #printableArea .dataTable-top .dataTable-search{
            max-width: 100%;
            margin: 10px 0 0 ;
        }
    }
    /* 20.01  */

</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-page'); ?>
    <script>
        (function () {
            var chartBarOptions = {
                series: [
                    {
                        name: '<?php echo e(__("Invoice")); ?>',
                        data:  <?php echo json_encode($invoiceTotal); ?>,

                    },
                ],

                chart: {
                    height: 300,
                    type: 'bar',
                    // type: 'line',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories: <?php echo json_encode($monthList); ?>,
                    title: {
                        text: '<?php echo e(__("Months")); ?>'
                    }
                },
                colors: ['#6fd944', '#6fd944'],


                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                // markers: {
                //     size: 4,
                //     colors: ['#ffa21d', '#FF3A6E'],
                //     opacity: 0.9,
                //     strokeWidth: 2,
                //     hover: {
                //         size: 7,
                //     }
                // },
                yaxis: {
                    title: {
                        text: '<?php echo e(__("Invoice")); ?>',
                        offsetX: 50,
                        offsetY: -25,
                    },

                }

            };
            var arChart = new ApexCharts(document.querySelector("#chart-sales"), chartBarOptions);
            arChart.render();
        })();

    </script>
    <script type="text/javascript" src="<?php echo e(asset('js/html2pdf.bundle.min.js')); ?>"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A2'}
            };
            html2pdf().set(opt).from(element).save();
        }

        $(document).ready(function () {
            var filename = $('#filename').val();
            $('#report-dataTable').DataTable({
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excel',
                        title: filename
                    },
                    {
                        extend: 'pdf',
                        title: filename
                    }, {
                        extend: 'csv',
                        title: filename
                    }
                ]
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('action-btn'); ?>
    <div class="float-end">




        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="<?php echo e(__('Download')); ?>" data-original-title="<?php echo e(__('Download')); ?>">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>

    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                    <?php echo e(Form::open(array('route' => array('report.invoice.summary'),'method' => 'GET','id'=>'report_invoice_summary'))); ?>

                        <div class="row align-items-center justify-content-end">
                            <div class="col-xl-10">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            <?php echo e(Form::label('start_month', __('Start Month'),['class'=>'form-label'])); ?>


                                            <?php echo e(Form::month('start_month',isset($_GET['start_month'])?$_GET['start_month']:date('Y-m', strtotime("-5 month")),array('class'=>'month-btn form-control'))); ?>


                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            <?php echo e(Form::label('end_month', __('End Month'),['class'=>'form-label'])); ?>


                                            <?php echo e(Form::month('end_month',isset($_GET['end_month'])?$_GET['end_month']:date('Y-m'),array('class'=>'month-btn form-control'))); ?>


                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                        <?php echo e(Form::label('customer', __('Customer'),['class'=>'form-label'])); ?>


                                        <?php echo e(Form::select('customer',$customer,isset($_GET['customer'])?$_GET['customer']:'', array('class' => 'form-control select'))); ?>


                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                        <?php echo e(Form::label('status', __('Status'),['class'=>'form-label'])); ?>


                                        <?php echo e(Form::select('status', [''=>'Select Status']+$status,isset($_GET['status'])?$_GET['status']:'', array('class' => 'form-control select'))); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <div class="row">
                                    <div class="col-auto mt-4">
                                        <a href="#" class="btn btn-sm btn-primary me-1" onclick="document.getElementById('report_invoice_summary').submit(); return false;" data-bs-toggle="tooltip" title="<?php echo e(__('Apply')); ?>" data-original-title="<?php echo e(__('apply')); ?>">
                                            <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                        </a>
                                        <a href="<?php echo e(route('report.invoice.summary')); ?>" class="btn btn-sm btn-danger " data-bs-toggle="tooltip"  title="<?php echo e(__('Reset')); ?>" data-original-title="<?php echo e(__('Reset')); ?>">
                                            <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off "></i></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>

                </div>
            </div>
        </div>
    </div>

    <div id="printableArea">
        <div class="row mt-3">
            <div class="col mb-4">
                <input type="hidden" value="<?php echo e($filter['status'].' '.__('Invoice').' '.'Report of'.' '.$filter['startDateRange'].' to '.$filter['endDateRange'].' '.__('of').' '.$filter['customer']); ?>" id="filename">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3.09766 0.761719V20.668C3.09766 21.089 3.43835 21.4297 3.85938 21.4297H17.5703C17.9913 21.4297 18.332 21.089 18.332 20.668V0.761719C18.332 0.340691 17.9913 0 17.5703 0H3.85938C3.43835 0 3.09766 0.340691 3.09766 0.761719ZM15.2852 17.5703H12.2383C11.8173 17.5703 11.4766 17.2296 11.4766 16.8086C11.4766 16.3876 11.8173 16.0469 12.2383 16.0469H15.2852C15.7062 16.0469 16.0469 16.3876 16.0469 16.8086C16.0469 17.2296 15.7062 17.5703 15.2852 17.5703ZM6.14453 3.85938H10.7148C11.1359 3.85938 11.4766 4.20007 11.4766 4.62109C11.4766 5.04212 11.1359 5.38281 10.7148 5.38281H6.14453C5.7235 5.38281 5.38281 5.04212 5.38281 4.62109C5.38281 4.20007 5.7235 3.85938 6.14453 3.85938ZM6.14453 6.90625H15.2852C15.7062 6.90625 16.0469 7.24694 16.0469 7.66797C16.0469 8.089 15.7062 8.42969 15.2852 8.42969H6.14453C5.7235 8.42969 5.38281 8.089 5.38281 7.66797C5.38281 7.24694 5.7235 6.90625 6.14453 6.90625ZM6.14453 9.95312H15.2852C15.7062 9.95312 16.0469 10.2938 16.0469 10.7148C16.0469 11.1359 15.7062 11.4766 15.2852 11.4766H6.14453C5.7235 11.4766 5.38281 11.1359 5.38281 10.7148C5.38281 10.2938 5.7235 9.95312 6.14453 9.95312ZM6.14453 13H15.2852C15.7062 13 16.0469 13.3407 16.0469 13.7617C16.0469 14.1827 15.7062 14.5234 15.2852 14.5234H6.14453C5.7235 14.5234 5.38281 14.1827 5.38281 13.7617C5.38281 13.3407 5.7235 13 6.14453 13Z"
                                    fill="white" />
                                <path
                                    d="M8.42969 26H22.1406C22.5617 26 22.9023 25.6593 22.9023 25.2383V5.38281C22.9023 4.96179 22.5617 4.62109 22.1406 4.62109H19.8555V20.668C19.8555 21.9281 18.8304 22.9531 17.5703 22.9531H7.66797V25.2383C7.66797 25.6593 8.00866 26 8.42969 26Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Report')); ?> :</h5>
                            <p class="text-muted mb-0"><?php echo e(__('Invoice Summary')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <?php if($filter['customer']!= __('All')): ?>
            <div class="col mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.01333 12.7314C4.62163 12.7314 4.23872 12.8475 3.91304 13.0651C3.58735 13.2828 3.33351 13.5921 3.18361 13.954C3.03371 14.3158 2.99449 14.714 3.07091 15.0982C3.14733 15.4824 3.33595 15.8353 3.61292 16.1123C3.8899 16.3892 4.24278 16.5778 4.62696 16.6543C5.01113 16.7307 5.40934 16.6915 5.77122 16.5416C6.1331 16.3917 6.44241 16.1378 6.66003 15.8121C6.87764 15.4865 6.99379 15.1035 6.99379 14.7118C6.99379 14.1866 6.78514 13.6829 6.41373 13.3114C6.04232 12.94 5.53858 12.7314 5.01333 12.7314ZM5.16008 3.57044L5.85629 5.72814C5.86609 5.7593 5.88565 5.78648 5.91207 5.80568C5.93849 5.82488 5.97039 5.83508 6.00305 5.83478L8.27043 5.83021C8.30355 5.829 8.33616 5.83862 8.36332 5.85761C8.39048 5.87661 8.4107 5.90394 8.42092 5.93546C8.43114 5.96699 8.43081 6.00099 8.41996 6.0323C8.40912 6.06362 8.38835 6.09054 8.36083 6.109L6.52407 7.43794C6.49747 7.45692 6.47768 7.48396 6.46763 7.51505C6.45757 7.54613 6.45777 7.57963 6.46821 7.6106L7.17254 9.76525C7.18376 9.79629 7.18459 9.83013 7.17491 9.86168C7.16524 9.89323 7.14557 9.92079 7.11889 9.94021C7.0922 9.95962 7.05993 9.96984 7.02693 9.96934C6.99393 9.96883 6.96198 9.95762 6.9359 9.9374L5.10422 8.60134C5.07799 8.58192 5.04622 8.57144 5.01358 8.57144C4.98094 8.57144 4.94917 8.58192 4.92294 8.60134L3.09126 9.9374C3.0652 9.95785 3.03318 9.96926 3.00005 9.96988C2.96693 9.9705 2.9345 9.96031 2.90769 9.94085C2.88088 9.92139 2.86114 9.89371 2.85147 9.86203C2.84181 9.83034 2.84273 9.79636 2.85411 9.76525L3.55895 7.6106C3.56939 7.57963 3.56959 7.54613 3.55953 7.51505C3.54947 7.48396 3.52969 7.45692 3.50309 7.43794L1.66633 6.109C1.6388 6.09054 1.61804 6.06362 1.6072 6.0323C1.59635 6.00099 1.59602 5.96699 1.60624 5.93546C1.61646 5.90394 1.63668 5.87661 1.66384 5.85761C1.69099 5.83862 1.72361 5.829 1.75672 5.83021L4.0236 5.83478C4.05626 5.83508 4.08816 5.82488 4.11458 5.80568C4.14101 5.78648 4.16056 5.7593 4.17036 5.72814L4.86708 3.57044C4.87616 3.53859 4.89537 3.51057 4.92181 3.49062C4.94824 3.47067 4.98046 3.45987 5.01358 3.45987C5.0467 3.45987 5.07892 3.47067 5.10535 3.49062C5.13179 3.51057 5.151 3.53859 5.16008 3.57044ZM21.1333 3.57044L21.83 5.72814C21.8398 5.7593 21.8594 5.78648 21.8858 5.80568C21.9122 5.82488 21.9441 5.83508 21.9768 5.83478L24.2437 5.83021C24.2768 5.829 24.3094 5.83862 24.3366 5.85761C24.3637 5.87661 24.3839 5.90394 24.3942 5.93546C24.4044 5.96699 24.404 6.00099 24.3932 6.0323C24.3824 6.06362 24.3616 6.09054 24.3341 6.109L22.4963 7.43794C22.4697 7.45692 22.4499 7.48396 22.4399 7.51505C22.4298 7.54613 22.43 7.57963 22.4404 7.6106L23.1463 9.76525C23.1577 9.79636 23.1586 9.83034 23.1489 9.86203C23.1393 9.89371 23.1195 9.92139 23.0927 9.94085C23.0659 9.96031 23.0335 9.9705 23.0003 9.96988C22.9672 9.96926 22.9352 9.95785 22.9091 9.9374L21.0775 8.60134C21.0512 8.58192 21.0195 8.57144 20.9868 8.57144C20.9542 8.57144 20.9224 8.58192 20.8962 8.60134L19.0645 9.9374C19.0384 9.95762 19.0065 9.96883 18.9735 9.96934C18.9405 9.96984 18.9082 9.95962 18.8815 9.94021C18.8548 9.92079 18.8352 9.89323 18.8255 9.86168C18.8158 9.83013 18.8166 9.79629 18.8279 9.76525L19.5322 7.6106C19.5426 7.57963 19.5428 7.54613 19.5328 7.51505C19.5227 7.48396 19.5029 7.45692 19.4763 7.43794L17.6396 6.109C17.612 6.09054 17.5913 6.06362 17.5804 6.0323C17.5696 6.00099 17.5693 5.96699 17.5795 5.93546C17.5897 5.90394 17.6099 5.87661 17.6371 5.85761C17.6642 5.83862 17.6968 5.829 17.73 5.83021L19.9974 5.83478C20.03 5.83508 20.0619 5.82488 20.0883 5.80568C20.1148 5.78648 20.1343 5.7593 20.1441 5.72814L20.8403 3.57044C20.8494 3.53859 20.8686 3.51057 20.8951 3.49062C20.9215 3.47067 20.9537 3.45987 20.9868 3.45987C21.0199 3.45987 21.0522 3.47067 21.0786 3.49062C21.105 3.51057 21.1242 3.53859 21.1333 3.57044ZM13.1465 1.53919L13.8432 3.69689C13.853 3.72805 13.8725 3.75523 13.8989 3.77443C13.9254 3.79363 13.9573 3.80383 13.9899 3.80353L16.2568 3.79896C16.29 3.79763 16.3227 3.80716 16.3499 3.82611C16.3772 3.84507 16.3975 3.8724 16.4078 3.90395C16.418 3.93551 16.4177 3.96956 16.4069 4.00093C16.3961 4.0323 16.3753 4.05927 16.3477 4.07775L14.5109 5.40669C14.4843 5.42561 14.4644 5.45261 14.4542 5.4837C14.4441 5.5148 14.4442 5.54833 14.4546 5.57935L15.1594 7.734C15.1708 7.76511 15.1717 7.79909 15.1621 7.83078C15.1524 7.86246 15.1326 7.89014 15.1058 7.9096C15.079 7.92906 15.0466 7.93925 15.0135 7.93863C14.9803 7.93801 14.9483 7.9266 14.9223 7.90615L13.0911 6.57009C13.0648 6.55055 13.0329 6.54 13.0002 6.54C12.9675 6.54 12.9356 6.55055 12.9093 6.57009L11.0781 7.90615C11.0521 7.9266 11.0201 7.93801 10.9869 7.93863C10.9538 7.93925 10.9214 7.92906 10.8946 7.9096C10.8678 7.89014 10.848 7.86246 10.8383 7.83078C10.8287 7.79909 10.8296 7.76511 10.841 7.734L11.5458 5.57935C11.5562 5.54833 11.5563 5.5148 11.5462 5.4837C11.536 5.45261 11.5161 5.42561 11.4895 5.40669L9.6527 4.07775C9.62513 4.05927 9.60434 4.0323 9.5935 4.00093C9.58266 3.96956 9.58236 3.93551 9.59265 3.90395C9.60294 3.8724 9.62325 3.84507 9.6505 3.82611C9.67774 3.80716 9.71043 3.79763 9.7436 3.79896L12.0105 3.80353C12.0431 3.80383 12.075 3.79363 12.1015 3.77443C12.1279 3.75523 12.1474 3.72805 12.1572 3.69689L12.854 1.53919C12.8632 1.50755 12.8824 1.47975 12.9088 1.45997C12.9352 1.4402 12.9672 1.4295 13.0002 1.4295C13.0332 1.4295 13.0652 1.4402 13.0916 1.45997C13.118 1.47975 13.1372 1.50755 13.1465 1.53919ZM13.0002 17.1676C10.2819 17.2083 8.02364 19.2466 7.63973 21.872C7.59888 22.1243 7.63162 22.383 7.73402 22.6172C7.83642 22.8513 8.00415 23.051 8.21711 23.1923C9.67047 24.1851 11.8134 24.5695 13.0002 24.5695C14.187 24.5695 16.3299 24.1851 17.7833 23.1923C17.9963 23.051 18.164 22.8513 18.2664 22.6172C18.3688 22.383 18.4015 22.1243 18.3607 21.872C17.9768 19.2461 15.719 17.2083 13.0002 17.1676ZM13.0002 11.2415C12.4993 11.2414 12.0096 11.3898 11.593 11.668C11.1765 11.9463 10.8518 12.3418 10.6601 12.8046C10.4684 13.2673 10.4182 13.7766 10.5159 14.2679C10.6136 14.7591 10.8548 15.2104 11.209 15.5646C11.5632 15.9188 12.0145 16.16 12.5058 16.2577C12.9971 16.3554 13.5063 16.3052 13.9691 16.1135C14.4318 15.9218 14.8273 15.5971 15.1056 15.1806C15.3838 14.764 15.5323 14.2743 15.5322 13.7734C15.5322 13.1019 15.2654 12.4579 14.7906 11.9831C14.3157 11.5082 13.6717 11.2415 13.0002 11.2415ZM20.9871 17.2951C22.0073 17.3141 22.9877 17.694 23.7545 18.3672C24.5212 19.0404 25.0247 19.9635 25.1755 20.9727C25.2071 21.1695 25.1813 21.3712 25.1014 21.5539C25.0214 21.7365 24.8906 21.8922 24.7246 22.0025C23.5886 22.7779 21.9143 23.0786 20.9871 23.0786C20.4285 23.0786 19.5947 22.9689 18.7735 22.7114C18.8787 22.4197 18.9094 22.1064 18.8629 21.7999C18.7118 20.7686 18.2934 19.7948 17.6492 18.9754C18.0435 18.4626 18.5484 18.0452 19.1263 17.7546C19.7042 17.4639 20.3403 17.3074 20.9871 17.2966V17.2951ZM5.01333 17.2951C5.66014 17.3058 6.29619 17.4624 6.87411 17.753C7.45203 18.0437 7.95692 18.461 8.35118 18.9739C7.70701 19.7933 7.28858 20.7671 7.13751 21.7984C7.09103 22.1049 7.12175 22.4182 7.22688 22.7099C6.40575 22.9674 5.57344 23.077 5.01333 23.077C4.08606 23.077 2.4118 22.7764 1.27583 22.001C1.11005 21.8908 0.979422 21.7353 0.89948 21.553C0.819537 21.3707 0.793647 21.1693 0.824888 20.9727C0.976052 19.9638 1.47965 19.0411 2.24637 18.3681C3.01309 17.6952 3.99336 17.3156 5.01333 17.2966V17.2951ZM20.9871 12.7314C20.5954 12.7314 20.2125 12.8475 19.8868 13.0651C19.5611 13.2828 19.3073 13.5921 19.1574 13.954C19.0075 14.3158 18.9682 14.714 19.0447 15.0982C19.1211 15.4824 19.3097 15.8353 19.5867 16.1123C19.8636 16.3892 20.2165 16.5778 20.6007 16.6543C20.9849 16.7307 21.3831 16.6915 21.745 16.5416C22.1069 16.3917 22.4162 16.1378 22.6338 15.8121C22.8514 15.4865 22.9675 15.1035 22.9675 14.7118C22.9675 14.1866 22.7589 13.6829 22.3875 13.3114C22.0161 12.94 21.5123 12.7314 20.9871 12.7314Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Customer')); ?> :</h5>
                            <p class="text-muted mb-0"><?php echo e($filter['customer']); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if($filter['status']!= __('All')): ?>
            <div class="col mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2257)">
                                <path d="M22.1638 4.98535L17.5396 9.60961C18.1142 10.3784 18.4827 11.2814 18.6101 12.2327C18.7015 12.2065 18.7957 12.1914 18.8907 12.1875H24.9845C25.0395 12.1925 25.094 12.2013 25.1478 12.2138C24.9792 9.54081 23.9299 6.99892 22.1638 4.98535Z" fill="white"/>
                                <path d="M0.812509 13C0.815126 16.0941 1.99485 19.0712 4.11227 21.3273C6.22968 23.5833 9.12615 24.9493 12.2138 25.1479C12.2013 25.094 12.1925 25.0394 12.1875 24.9844V18.8906C12.1915 18.7956 12.2066 18.7014 12.2327 18.61C11.3714 18.4973 10.5475 18.1883 9.82456 17.7068C9.10159 17.2253 8.49884 16.5843 8.06278 15.833C7.62672 15.0818 7.369 14.2405 7.30949 13.3739C7.24998 12.5073 7.39027 11.6386 7.71955 10.8349C8.04882 10.0311 8.55828 9.31363 9.20865 8.73785C9.85902 8.16208 10.6329 7.74335 11.4707 7.51395C12.3085 7.28454 13.1877 7.2506 14.0407 7.41472C14.8937 7.57884 15.6976 7.93665 16.3904 8.46056L21.0147 3.8363C19.2549 2.29187 17.0871 1.28772 14.7711 0.944219C12.455 0.60072 10.0891 0.932451 7.9568 1.89965C5.82453 2.86684 4.01645 4.42845 2.74929 6.39729C1.48213 8.36612 0.809666 10.6586 0.812509 13Z" fill="white"/>
                                <path d="M24.9845 13.8125H18.8907C18.7957 13.8086 18.7015 13.7935 18.6101 13.7673C18.4423 14.9925 17.8782 16.1291 17.0037 17.0035C16.1293 17.8779 14.9927 18.4421 13.7676 18.6098C13.7936 18.7013 13.8087 18.7956 13.8126 18.8906V24.9844C13.8076 25.0394 13.7988 25.094 13.7863 25.1479C16.7367 24.9566 19.5168 23.6981 21.6075 21.6074C23.6981 19.5167 24.9565 16.7367 25.1478 13.7862C25.094 13.7987 25.0394 13.8075 24.9845 13.8125Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2257">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Status')); ?> :</h5>
                            <p class="text-muted mb-0"><?php echo e($filter['status']); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="col mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.6667 5.22996V2.94866C22.3111 2.57293 22.75 1.8819 22.75 1.08332V0.541684C22.75 0.242277 22.5077 0 22.2083 0H3.79168C3.49228 0 3.25 0.242277 3.25 0.541684V1.08337C3.25 1.8819 3.68885 2.57293 4.33332 2.94871V5.22996C4.33332 7.37653 5.24845 9.43104 6.84384 10.8667L9.21416 13L6.84384 15.1333C5.24845 16.569 4.33332 18.6235 4.33332 20.77V23.0513C3.68885 23.4271 3.25 24.1181 3.25 24.9167V25.4584C3.25 25.7577 3.49228 26 3.79168 26H22.2084C22.5078 26 22.7501 25.7577 22.7501 25.4583V24.9166C22.7501 24.1181 22.3112 23.4271 21.6667 23.0513V20.77C21.6667 18.6235 20.7516 16.569 19.1562 15.1333L16.7858 13L19.1562 10.8667C20.7516 9.43104 21.6667 7.37648 21.6667 5.22996ZM17.7068 9.25646L14.442 12.1949C14.2135 12.4002 14.0833 12.6927 14.0833 13C14.0833 13.3073 14.2135 13.5999 14.442 13.8051L17.7068 16.7435C18.8462 17.7692 19.5 19.2371 19.5 20.77V22.75H18.1456L13.4332 16.4669C13.229 16.1939 12.7709 16.1939 12.5667 16.4669L7.85444 22.75H6.5V20.77C6.5 19.2371 7.15381 17.7692 8.29324 16.7435L11.5581 13.805C11.7866 13.5998 11.9167 13.3073 11.9167 12.9999C11.9167 12.6926 11.7866 12.4001 11.5581 12.1949L8.29324 9.25641C7.15381 8.23078 6.5 6.76289 6.5 5.22996V3.25H19.5V5.22996C19.5 6.76289 18.8462 8.23078 17.7068 9.25646Z" fill="white"/>
                                <path d="M16.7337 7.58331H9.26621C9.05197 7.58331 8.85783 7.70976 8.77109 7.90547C8.68436 8.10174 8.72082 8.33026 8.86524 8.48895L12.6368 11.9685C12.74 12.0622 12.8701 12.1087 13.0002 12.1087C13.1303 12.1087 13.2605 12.0621 13.3636 11.9685L17.1346 8.48895C17.279 8.33026 17.3155 8.10174 17.2288 7.90547C17.1421 7.70976 16.9479 7.58331 16.7337 7.58331Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Duration')); ?> :</h5>
                            <p class="text-muted mb-0"><?php echo e($filter['startDateRange'].' to '.$filter['endDateRange']); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-sm-6 col-md-4 mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2295)">
                                <path d="M8.12707 17.0562C8.12707 16.7532 7.861 16.5072 7.53253 16.5072C7.20405 16.5072 6.93799 16.7532 6.93799 17.0562C6.93799 17.3595 7.20405 17.6052 7.53253 17.6052C7.861 17.6052 8.12707 17.3595 8.12707 17.0562Z" fill="white"/>
                                <path d="M7.53253 12.6091C7.20471 12.6091 6.93799 12.8553 6.93799 13.1581C6.93799 13.4608 7.20471 13.7071 7.53253 13.7071C7.86035 13.7071 8.12729 13.4608 8.12729 13.1581C8.12729 12.8553 7.86035 12.6091 7.53253 12.6091Z" fill="white"/>
                                <path d="M8.12707 9.25999C8.12707 8.9567 7.861 8.711 7.53253 8.711C7.20405 8.711 6.93799 8.9567 6.93799 9.25999C6.93799 9.56306 7.20405 9.80898 7.53253 9.80898C7.861 9.80898 8.12707 9.56306 8.12707 9.25999Z" fill="white"/>
                                <path d="M20.4735 0.71701C17.4213 0.71701 14.947 3.1913 14.9473 6.24349C14.9473 9.29568 17.4216 11.77 20.4737 11.77C23.5259 11.77 26 9.29568 26 6.24349C25.9967 3.19284 23.5244 0.720514 20.4735 0.71701ZM20.4479 5.84823C21.3974 5.84845 22.1915 6.56978 22.2821 7.51491C22.3728 8.46026 21.7305 9.31955 20.7983 9.49999V10.0168C20.7983 10.2336 20.6227 10.4092 20.4059 10.4092C20.1891 10.4092 20.0134 10.2336 20.0134 10.0168V9.4816C19.1877 9.28035 18.6063 8.54107 18.6052 7.69119C18.6052 7.4744 18.7808 7.29877 18.9976 7.29877C19.2142 7.29877 19.39 7.4744 19.39 7.69119C19.39 8.27544 19.8637 8.7491 20.4479 8.7491C21.0322 8.7491 21.5058 8.27544 21.5058 7.69119C21.5058 7.10673 21.0322 6.63306 20.4479 6.63306C19.5148 6.63306 18.7291 5.9356 18.6183 5.0093C18.5075 4.08278 19.1066 3.21977 20.0134 2.99969V2.50479C20.0134 2.28822 20.1891 2.11237 20.4059 2.11237C20.6227 2.11237 20.7983 2.28822 20.7983 2.50479V2.9813C21.6641 3.15013 22.2896 3.90825 22.2907 4.79032C22.2907 5.00711 22.115 5.18274 21.8982 5.18274C21.6817 5.18274 21.5058 5.00711 21.5058 4.79032C21.5052 4.2133 21.0422 3.74292 20.465 3.73329C20.4455 3.73635 20.4258 3.7381 20.4059 3.7381C20.3936 3.7381 20.3816 3.73745 20.3695 3.73635C19.8023 3.77862 19.3701 4.26169 19.3913 4.83017C19.4123 5.39844 19.8792 5.84823 20.4481 5.84823H20.4479Z" fill="white"/>
                                <path d="M14.14 25.1417C13.4865 24.4927 13.1189 23.6097 13.118 22.6887V21.1166H0V22.6953C0.00656953 24.1769 1.20879 25.3752 2.69043 25.3771H14.4056C14.3095 25.3077 14.2203 25.2289 14.14 25.1417Z" fill="white"/>
                                <path d="M15.1643 9.62436H10.4114C10.1946 9.62436 10.019 9.44874 10.019 9.23194C10.019 9.01537 10.1946 8.83953 10.4114 8.83953H14.7342C14.3549 8.01746 14.1598 7.12248 14.1624 6.21698C14.1637 5.77967 14.2091 5.34368 14.2977 4.91534H3.73661L3.63281 20.3318H13.5306C13.6305 20.3278 13.7273 20.3655 13.798 20.436C13.8688 20.5065 13.9066 20.6033 13.9029 20.7032V22.6891C13.9101 24.1741 15.1145 25.3745 16.5995 25.3771H16.6082C18.0875 25.3741 19.2846 24.1743 19.2846 22.6953V12.4425C17.5781 12.1192 16.0842 11.0977 15.1643 9.62436ZM7.53269 18.3903C6.77216 18.3903 6.15331 17.7918 6.15331 17.0562C6.15331 16.3209 6.77216 15.7224 7.53269 15.7224C8.29322 15.7224 8.91228 16.3209 8.91228 17.0562C8.91228 17.7918 8.29344 18.3903 7.53269 18.3903ZM7.53269 14.4919C6.77216 14.4919 6.15331 13.8937 6.15331 13.1581C6.15331 12.4225 6.77216 11.8243 7.53269 11.8243C8.29322 11.8243 8.91228 12.4225 8.91228 13.1581C8.91228 13.8934 8.29344 14.4919 7.53269 14.4919ZM7.53269 10.5938C6.77216 10.5938 6.15331 9.99532 6.15331 9.25997C6.15331 8.52441 6.77216 7.92593 7.53269 7.92593C8.29322 7.92593 8.91228 8.52419 8.91228 9.25975C8.91228 9.99532 8.29344 10.5938 7.53269 10.5938ZM16.3906 17.4727H10.4114C10.1946 17.4727 10.019 17.2971 10.019 17.0803C10.019 16.8637 10.1946 16.6879 10.4114 16.6879H16.3906C16.6074 16.6879 16.783 16.8637 16.783 17.0803C16.783 17.2971 16.6074 17.4727 16.3906 17.4727ZM16.783 13.1561C16.783 13.3729 16.6074 13.5485 16.3906 13.5485H10.4114C10.1946 13.5485 10.019 13.3729 10.019 13.1561C10.019 12.9396 10.1946 12.7637 10.4114 12.7637H16.3906C16.6074 12.7637 16.783 12.9396 16.783 13.1561Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2295">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Total Invoice')); ?></h5>
                            <p class="text-muted mb-0"><?php echo e(Auth::user()->priceFormat($totalInvoice)); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2304)">
                                <path d="M7.3125 12.1875C3.72938 12.1875 0.8125 15.1044 0.8125 18.6875C0.8125 22.2706 3.72938 25.1875 7.3125 25.1875C10.8956 25.1875 13.8125 22.2706 13.8125 18.6875C13.8125 15.1044 10.8956 12.1875 7.3125 12.1875ZM6.70312 17.875H7.92188C9.04313 17.875 9.95312 18.785 9.95312 19.9062C9.95312 20.9544 9.14875 21.8156 8.125 21.9131V22.3438C8.125 22.7906 7.75938 23.1562 7.3125 23.1562C6.86562 23.1562 6.5 22.7906 6.5 22.3438V21.9375H5.48438C5.0375 21.9375 4.67188 21.5719 4.67188 21.125C4.67188 20.6781 5.0375 20.3125 5.48438 20.3125H7.92188C8.14937 20.3125 8.32812 20.1337 8.32812 19.9062C8.32812 19.6788 8.14937 19.5 7.92188 19.5H6.70312C5.58187 19.5 4.67188 18.59 4.67188 17.4688C4.67188 16.4206 5.47625 15.5594 6.5 15.4619V15.0312C6.5 14.5844 6.86562 14.2188 7.3125 14.2188C7.75938 14.2188 8.125 14.5844 8.125 15.0312V15.4375H9.14062C9.5875 15.4375 9.95312 15.8031 9.95312 16.25C9.95312 16.6969 9.5875 17.0625 9.14062 17.0625H6.70312C6.47563 17.0625 6.29688 17.2413 6.29688 17.4688C6.29688 17.6962 6.47563 17.875 6.70312 17.875Z" fill="white"/>
                                <path d="M24.375 0.8125C23.9281 0.8125 23.5625 1.17812 23.5625 1.625V1.73063L21.1981 2.07187V8.125C21.1981 8.57188 20.8325 8.9375 20.3856 8.9375C19.9388 8.9375 19.5731 8.57188 19.5731 8.125V2.29937L13.8125 3.12V11.4969L14.625 11.6106V14.2106C14.625 15.3319 15.535 16.2419 16.6562 16.2419H18.6956C19.5081 16.2419 20.2394 15.7625 20.5644 15.0069L21.5963 12.6019L23.5625 12.8862V12.9919C23.5625 13.4388 23.9281 13.8044 24.375 13.8044C24.8219 13.8044 25.1875 13.4388 25.1875 12.9919V1.625C25.1875 1.17812 24.8219 0.8125 24.375 0.8125ZM19.0694 14.3813C19.0044 14.5275 18.8581 14.625 18.6956 14.625H16.6562C16.4288 14.625 16.25 14.4462 16.25 14.2188V11.8462L19.9306 12.3744L19.0694 14.3813Z" fill="white"/>
                                <path d="M10.5625 10.1562H12.1875V4.46875H8.9375V8.53125C8.9375 9.425 9.66875 10.1562 10.5625 10.1562Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2304">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Total Paid')); ?></h5>
                            <p class="text-muted mb-0"><?php echo e(Auth::user()->priceFormat($totalPaidInvoice)); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.6668 6.50001C21.6668 5.30293 20.6972 4.33334 19.5002 4.33334H18.4168V3.25001C18.4168 2.95209 18.1731 2.70834 17.8752 2.70834C17.5772 2.70834 17.3335 2.95209 17.3335 3.25001V4.33334H15.1668V3.25001C15.1668 2.95209 14.9231 2.70834 14.6252 2.70834C14.3272 2.70834 14.0835 2.95209 14.0835 3.25001V4.33334H11.9168V3.25001C11.9168 2.95209 11.6731 2.70834 11.3752 2.70834C11.0772 2.70834 10.8335 2.95209 10.8335 3.25001V4.33334H8.66683V3.25001C8.66683 2.95209 8.42308 2.70834 8.12516 2.70834C7.82725 2.70834 7.5835 2.95209 7.5835 3.25001V4.33334H5.41683V3.25001C5.41683 2.95209 5.17308 2.70834 4.87516 2.70834C4.57725 2.70834 4.3335 2.95209 4.3335 3.25001V4.33334H3.25016C2.05308 4.33334 1.0835 5.30293 1.0835 6.50001V8.12501H21.6668V6.50001Z" fill="white"/>
                                <path d="M10.8335 12.4583H11.9168V13.5417H10.8335V12.4583Z" fill="white"/>
                                <path d="M10.8335 17.875H11.9168V18.9583H10.8335V17.875Z" fill="white"/>
                                <path d="M5.4165 17.875H6.49984V18.9583H5.4165V17.875Z" fill="white"/>
                                <path d="M5.4165 12.4583H6.49984V13.5417H5.4165V12.4583Z" fill="white"/>
                                <path d="M16.6292 13.5417C16.8513 13.3846 17.0896 13.2438 17.3333 13.1138V12.4583H16.25V13.5417H16.6292Z" fill="white"/>
                                <path d="M14.0835 18.4167C14.0835 16.9542 14.6143 15.6163 15.4918 14.5763C15.3022 14.495 15.1668 14.3054 15.1668 14.0833V11.9167C15.1668 11.6188 15.4106 11.375 15.7085 11.375H17.8752C18.1731 11.375 18.4168 11.6188 18.4168 11.9167V12.6913C18.9368 12.545 19.4785 12.4583 20.0418 12.4583C20.6052 12.4583 21.1468 12.5396 21.6668 12.6913V9.20834H1.0835V21.125C1.0835 22.3221 2.05308 23.2917 3.25016 23.2917H16.6293C15.0964 22.2138 14.0835 20.4317 14.0835 18.4167ZM7.5835 19.5C7.5835 19.7979 7.33975 20.0417 7.04183 20.0417H4.87516C4.57725 20.0417 4.3335 19.7979 4.3335 19.5V17.3333C4.3335 17.0354 4.57725 16.7917 4.87516 16.7917H7.04183C7.33975 16.7917 7.5835 17.0354 7.5835 17.3333V19.5ZM7.5835 14.0833C7.5835 14.3813 7.33975 14.625 7.04183 14.625H4.87516C4.57725 14.625 4.3335 14.3813 4.3335 14.0833V11.9167C4.3335 11.6188 4.57725 11.375 4.87516 11.375H7.04183C7.33975 11.375 7.5835 11.6188 7.5835 11.9167V14.0833ZM13.0002 19.5C13.0002 19.7979 12.7564 20.0417 12.4585 20.0417H10.2918C9.99391 20.0417 9.75016 19.7979 9.75016 19.5V17.3333C9.75016 17.0354 9.99391 16.7917 10.2918 16.7917H12.4585C12.7564 16.7917 13.0002 17.0354 13.0002 17.3333V19.5ZM13.0002 14.0833C13.0002 14.3813 12.7564 14.625 12.4585 14.625H10.2918C9.99391 14.625 9.75016 14.3813 9.75016 14.0833V11.9167C9.75016 11.6188 9.99391 11.375 10.2918 11.375H12.4585C12.7564 11.375 13.0002 11.6188 13.0002 11.9167V14.0833Z" fill="white"/>
                                <path d="M20.0415 13.5417C17.3548 13.5417 15.1665 15.73 15.1665 18.4167C15.1665 21.1033 17.3548 23.2917 20.0415 23.2917C22.7282 23.2917 24.9165 21.1033 24.9165 18.4167C24.9165 15.73 22.7282 13.5417 20.0415 13.5417ZM21.1248 17.875C21.7207 17.875 22.2082 18.3625 22.2082 18.9583V19.5C22.2082 20.0958 21.7207 20.5833 21.1248 20.5833H20.5832C20.5832 20.8812 20.3394 21.125 20.0415 21.125C19.7436 21.125 19.4998 20.8812 19.4998 20.5833H18.4165C18.1186 20.5833 17.8748 20.3396 17.8748 20.0417C17.8748 19.7437 18.1186 19.5 18.4165 19.5H21.1248V18.9583H18.9582C18.3623 18.9583 17.8748 18.4708 17.8748 17.875V17.3333C17.8748 16.7375 18.3623 16.25 18.9582 16.25H19.4998C19.4998 15.9521 19.7436 15.7083 20.0415 15.7083C20.3394 15.7083 20.5832 15.9521 20.5832 16.25H21.6665C21.9644 16.25 22.2082 16.4937 22.2082 16.7917C22.2082 17.0896 21.9644 17.3333 21.6665 17.3333H18.9582V17.875H21.1248Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1"><?php echo e(__('Total Due')); ?></h5>
                            <p class="text-muted mb-0"><?php echo e(Auth::user()->priceFormat($totalDueInvoice)); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12" id="invoice-container">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between w-100">
                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="profile-tab3" data-bs-toggle="pill" href="#summary" role="tab" aria-controls="pills-summary" aria-selected="true"><?php echo e(__('Summary')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="contact-tab4" data-bs-toggle="pill" href="#invoices" role="tab" aria-controls="pills-invoice" aria-selected="false"><?php echo e(__('Invoices')); ?></a>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="tab-content" id="myTabContent2">
                                    <div class="tab-pane fade fade" id="invoices" role="tabpanel" aria-labelledby="profile-tab3">
                                        <div class="table-responsive">
                                        <table class="table datatable" id="report-dataTable">
                                            <thead>
                                            <tr>
                                                <th> <?php echo e(__('Invoice')); ?></th>
                                                <th> <?php echo e(__('Date')); ?></th>
                                                <th> <?php echo e(__('Customer')); ?></th>
                                                <th> <?php echo e(__('Category')); ?></th>
                                                <th> <?php echo e(__('Status')); ?></th>
                                                <th> <?php echo e(__('	Paid Amount')); ?></th>
                                                <th> <?php echo e(__('Due Amount')); ?></th>
                                                <th> <?php echo e(__('Payment Date')); ?></th>
                                                <th> <?php echo e(__('Amount')); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="Id">
                                                        <a href="<?php echo e(route('invoice.show',\Crypt::encrypt($invoice->id))); ?>" class="btn btn-outline-primary"><?php echo e(Auth::user()->invoiceNumberFormat($invoice->invoice_id)); ?></a>                                                    </td>
                                                    </td>
                                                    <td><?php echo e(\Auth::user()->dateFormat($invoice->send_date)); ?></td>
                                                    <td><?php echo e(!empty($invoice->customer)? $invoice->customer->name:'-'); ?> </td>
                                                    <td><?php echo e(!empty($invoice->category)?$invoice->category->name:'-'); ?></td>
                                                    <td>
                                                        <?php if($invoice->status == 0): ?>
                                                            <span class="badge status_badge bg-primary p-2 px-3 rounded"><?php echo e(__(\App\Models\Invoice::$statues[$invoice->status])); ?></span>
                                                        <?php elseif($invoice->status == 1): ?>
                                                            <span class="badge status_badge bg-warning p-2 px-3 rounded"><?php echo e(__(\App\Models\Invoice::$statues[$invoice->status])); ?></span>
                                                        <?php elseif($invoice->status == 2): ?>
                                                            <span class="badge status_badge bg-danger p-2 px-3 rounded"><?php echo e(__(\App\Models\Invoice::$statues[$invoice->status])); ?></span>
                                                        <?php elseif($invoice->status == 3): ?>
                                                            <span class="badge status_badge bg-info p-2 px-3 rounded"><?php echo e(__(\App\Models\Invoice::$statues[$invoice->status])); ?></span>
                                                        <?php elseif($invoice->status == 4): ?>
                                                            <span class="badge status_badge bg-success p-2 px-3 rounded"><?php echo e(__(\App\Models\Invoice::$statues[$invoice->status])); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td> <?php echo e(\Auth::user()->priceFormat($invoice->getTotal()-$invoice->getDue())); ?></td>
                                                    <td> <?php echo e(\Auth::user()->priceFormat($invoice->getDue())); ?></td>
                                                    <td><?php echo e(!empty($invoice->lastPayments)?\Auth::user()->dateFormat($invoice->lastPayments->date):''); ?></td>
                                                    <td> <?php echo e(\Auth::user()->priceFormat($invoice->getTotal())); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                    <div class="tab-pane fade fade show active" id="summary" role="tabpanel" aria-labelledby="profile-tab3">
                                        <div class="col-sm-12">
                                            <div class="scrollbar-inner">
                                                <div id="chart-sales" data-color="primary" data-type="bar" data-height="300" ></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleversysco/public_html/erp.cleversys.co.ke/resources/views/report/invoice_report.blade.php ENDPATH**/ ?>