@extends('layouts.admin')
@section('page-title')
    {{__('Manage Leave Report')}}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Leave Report')}}</li>
@endsection
@push('script-page')

    <script type="text/javascript" src="{{ asset('js/jszip.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/pdfmake.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/vfs_fonts.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/dataTables.buttons.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/buttons.html5.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A4'}
            };
            html2pdf().set(opt).from(element).save();

        }

        $(document).ready(function () {
            var filename = $('#filename').val();
            $('#report-dataTable').DataTable({
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'pdf',
                        title: filename
                    },
                    {
                        extend: 'excel',
                        title: filename
                    }, {
                        extend: 'csv',
                        title: filename
                    }
                ]
            });
        });
    </script>
    <script>
        $('input[name="type"]:radio').on('change', function (e) {
            var type = $(this).val();
            if (type == 'monthly') {
                $('.month').addClass('d-block');
                $('.month').removeClass('d-none');
                $('.year').addClass('d-none');
                $('.year').removeClass('d-block');
            } else {
                $('.year').addClass('d-block');
                $('.year').removeClass('d-none');
                $('.month').addClass('d-none');
                $('.month').removeClass('d-block');
            }
        });

        $('input[name="type"]:radio:checked').trigger('change');

    </script>
@endpush
@section('action-btn')
    <div class="float-end">
{{--        <a href="{{ route('leave.export') }}" data-bs-toggle="tooltip" title="{{ __('Export') }}"--}}
{{--           class="btn btn-sm btn-primary">--}}
{{--            <i class="ti ti-file-export"></i>--}}
{{--        </a>--}}

        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="{{__('Download')}}" data-original-title="{{__('Download')}}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class=" mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        {{ Form::open(array('route' => array('report.leave'),'method'=>'get','id'=>'report_leave')) }}
                        <div class="row align-items-center justify-content-end">
                            <div class="col-xl-10">
                                <div class="row">
                                    <div class="col-3 mt-2">
                                        <label class="form-label">{{__('Type')}}</label> <br>
                                        <div class="form-check form-check-inline form-group">
                                            <input type="radio" id="monthly" value="monthly" name="type" class="form-check-input" {{isset($_GET['type']) && $_GET['type']=='monthly' ?'checked':'checked'}}>
                                            <label class="form-check-label" for="monthly">{{__('Monthly')}}</label>
                                        </div>
                                        <div class="form-check form-check-inline form-group">
                                            <input type="radio" id="daily" value="daily" name="type" class="form-check-input" {{isset($_GET['type']) && $_GET['type']=='daily' ?'checked':''}}>
                                            <label class="form-check-label" for="daily">{{__('Daily')}}</label>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12 month">
                                        <div class="btn-box">
                                            {{Form::label('month',__('Month'),['class'=>'form-label'])}}
                                            {{Form::month('month',isset($_GET['month'])?$_GET['month']:date('Y-m'),array('class'=>'month-btn form-control'))}}
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12 year d-none">
                                        <div class="btn-box">
                                            {{ Form::label('year', __('Year'),['class'=>'form-label']) }}
                                            <select class="form-control select" id="year" name="year" tabindex="-1" aria-hidden="true">
                                                @for($filterYear['starting_year']; $filterYear['starting_year'] <= $filterYear['ending_year']; $filterYear['starting_year']++)
                                                    <option {{(isset($_GET['year']) && $_GET['year'] == $filterYear['starting_year'] ?'selected':'')}} {{(!isset($_GET['year']) && date('Y') == $filterYear['starting_year'] ?'selected':'')}} value="{{$filterYear['starting_year']}}">{{$filterYear['starting_year']}}</option>
                                                @endfor
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('branch', __('Branch'),['class'=>'form-label']) }}
                                            {{ Form::select('branch', $branch,isset($_GET['branch'])?$_GET['branch']:'', array('class' => 'form-control select')) }}
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('department', __('Department'),['class'=>'form-label'])}}
                                            {{ Form::select('department', $department,isset($_GET['department'])?$_GET['department']:'', array('class' => 'form-control select')) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto mt-4">
                                <div class="row">
                                    <div class="col-auto">
                                        <a href="#" class="btn btn-sm btn-primary me-1  " onclick="document.getElementById('report_leave').submit(); return false;" data-bs-toggle="tooltip" title="{{__('Apply')}}" data-original-title="{{__('apply')}}">
                                            <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                        </a>
                                        <a href="{{route('report.leave')}}" class="btn btn-sm btn-danger " data-bs-toggle="tooltip"  title="{{ __('Reset') }}" data-original-title="{{__('Reset')}}">
                                            <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off "></i></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
    <div id="printableArea" class="">
        <div class="row mb-4 align-items-center">
            <div class="col-xl-3 mb-4 mb-xl-0">
                <div class="row gy-3">
                    <div class="col-xl-12 col-sm-6 col-12">
                        <div class="card report-card mb-0">
                            <div class="card-body d-flex align-items-center gap-3">
                                <div class="report-icon">
                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M3.09766 0.761719V20.668C3.09766 21.089 3.43835 21.4297 3.85938 21.4297H17.5703C17.9913 21.4297 18.332 21.089 18.332 20.668V0.761719C18.332 0.340691 17.9913 0 17.5703 0H3.85938C3.43835 0 3.09766 0.340691 3.09766 0.761719ZM15.2852 17.5703H12.2383C11.8173 17.5703 11.4766 17.2296 11.4766 16.8086C11.4766 16.3876 11.8173 16.0469 12.2383 16.0469H15.2852C15.7062 16.0469 16.0469 16.3876 16.0469 16.8086C16.0469 17.2296 15.7062 17.5703 15.2852 17.5703ZM6.14453 3.85938H10.7148C11.1359 3.85938 11.4766 4.20007 11.4766 4.62109C11.4766 5.04212 11.1359 5.38281 10.7148 5.38281H6.14453C5.7235 5.38281 5.38281 5.04212 5.38281 4.62109C5.38281 4.20007 5.7235 3.85938 6.14453 3.85938ZM6.14453 6.90625H15.2852C15.7062 6.90625 16.0469 7.24694 16.0469 7.66797C16.0469 8.089 15.7062 8.42969 15.2852 8.42969H6.14453C5.7235 8.42969 5.38281 8.089 5.38281 7.66797C5.38281 7.24694 5.7235 6.90625 6.14453 6.90625ZM6.14453 9.95312H15.2852C15.7062 9.95312 16.0469 10.2938 16.0469 10.7148C16.0469 11.1359 15.7062 11.4766 15.2852 11.4766H6.14453C5.7235 11.4766 5.38281 11.1359 5.38281 10.7148C5.38281 10.2938 5.7235 9.95312 6.14453 9.95312ZM6.14453 13H15.2852C15.7062 13 16.0469 13.3407 16.0469 13.7617C16.0469 14.1827 15.7062 14.5234 15.2852 14.5234H6.14453C5.7235 14.5234 5.38281 14.1827 5.38281 13.7617C5.38281 13.3407 5.7235 13 6.14453 13Z"
                                            fill="white" />
                                        <path
                                            d="M8.42969 26H22.1406C22.5617 26 22.9023 25.6593 22.9023 25.2383V5.38281C22.9023 4.96179 22.5617 4.62109 22.1406 4.62109H19.8555V20.668C19.8555 21.9281 18.8304 22.9531 17.5703 22.9531H7.66797V25.2383C7.66797 25.6593 8.00866 26 8.42969 26Z"
                                            fill="white" />
                                    </svg>
                                </div>
                                <div class="report-info">
                                    <input type="hidden"
                                        value="{{ $filterYear['branch'] . ' ' . __('Branch') . ' ' . $filterYear['dateYearRange'] . ' ' . $filterYear['type'] . ' ' . __('Leave Report of') . ' ' . $filterYear['department'] . ' ' . 'Department' }}"
                                        id="filename">
                                    <h5 class="mb-1">{{ __('Report') }}</h5>
                                    <p class="text-muted mb-0">{{ $filterYear['type'] . ' ' . __('Leave Summary') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if ($filterYear['branch'] != 'All')
                        <div class="col-xl-12 col-sm-6 col-12">
                            <div class="card report-card mb-0">
                                <div class="card-body d-flex align-items-center gap-3">
                                    <div class="report-icon">
                                        <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M12.9998 0.8125C8.61229 0.8125 5.04541 4.38344 5.04541 8.76687C5.04541 13.1909 7.88916 17.4322 10.1195 20.0769C8.12072 20.4262 6.2276 21.2103 6.2276 22.5103C6.2276 24.2491 9.71729 25.1875 12.9998 25.1875C16.2823 25.1875 19.772 24.2491 19.772 22.5103C19.772 21.2103 17.8788 20.4262 15.8801 20.0769C18.1104 17.4322 20.9542 13.1909 20.9542 8.76687C20.9542 4.38344 17.3873 0.8125 12.9998 0.8125ZM12.9998 21.9538C11.6673 20.6781 5.85791 14.7794 5.85791 8.76687C5.85791 4.83031 9.05916 1.625 12.9998 1.625C16.9404 1.625 20.1417 4.83031 20.1417 8.76687C20.1417 14.7753 14.3323 20.6781 12.9998 21.9538Z" fill="white"/>
                                            <path d="M13.8168 3.25C13.8127 3.25 13.8046 3.24593 13.8005 3.24593C12.6549 3.07937 11.5621 3.26218 10.5668 3.7375C8.6168 4.66781 7.35742 6.66656 7.35742 8.83187C7.35742 9.08781 7.37773 9.34781 7.4143 9.59562V9.59968C7.52398 10.4122 7.80836 11.18 8.23492 11.8544C8.66148 12.5287 9.2343 13.1137 9.92086 13.5566C10.839 14.1537 11.8993 14.4706 13.0002 14.4706C13.374 14.4706 13.7437 14.43 14.1093 14.3569C14.1905 14.3406 14.2677 14.3203 14.349 14.3C14.6821 14.2187 15.0071 14.1131 15.3199 13.9709C16.043 13.6459 16.6971 13.1666 17.2334 12.5612C17.7818 11.9397 18.1962 11.1881 18.4237 10.3878C18.5699 9.88 18.643 9.35593 18.643 8.83187C18.643 6.045 16.5671 3.64406 13.8168 3.25ZM16.8637 11.7203C16.5549 11.5212 16.1974 11.3872 15.8399 11.3628C15.3687 11.3262 15.0071 11.4806 14.743 11.5944C14.5602 11.6756 14.4465 11.7244 14.3937 11.6959C14.3165 11.6594 14.2109 11.4806 14.158 11.0947C14.1093 10.7575 13.9184 10.4609 13.638 10.2862C13.3902 10.1359 13.1018 10.0872 12.8134 10.14C12.3218 10.2416 11.6027 10.4853 10.9649 11.0703C10.8187 11.2044 10.2255 11.7934 9.9168 12.545C9.19773 11.9519 8.67773 11.1637 8.40148 10.2781C8.76711 10.4041 9.14898 10.4772 9.53492 10.4772C9.85586 10.4772 10.1768 10.4325 10.4855 10.3391C10.9121 10.2131 11.2493 10.0222 11.493 9.76625C11.818 9.43312 11.9846 8.97812 11.9318 8.55562C11.9115 8.40125 11.8668 8.27531 11.7815 8.14531C11.7002 8.03562 11.6027 7.95843 11.5052 7.88937C11.3915 7.82031 11.2696 7.75937 11.1477 7.7025C10.973 7.61718 10.8187 7.54406 10.7374 7.4425C10.583 7.24343 10.6602 6.89 10.7821 6.61781C10.8349 6.50406 10.8918 6.39437 10.9487 6.28468C11.103 5.99218 11.2615 5.6875 11.3224 5.32187C11.363 5.06593 11.3468 4.68812 11.2534 4.33062C11.8059 4.11531 12.3909 4.00156 13.0002 4.00156H13.0652C12.9962 4.13562 12.9352 4.26968 12.8905 4.42C12.7402 4.91562 12.7971 5.41531 13.049 5.78906C13.2684 6.10187 13.5893 6.28062 13.8696 6.43906C14.1337 6.58531 14.3612 6.71125 14.4262 6.89C14.4871 7.0525 14.4343 7.26781 14.3693 7.51968C14.3327 7.66187 14.3002 7.80406 14.2799 7.94625C14.2109 8.40125 14.3002 8.85625 14.5237 9.22187C14.7755 9.63218 15.198 9.9125 15.653 9.97343C15.9455 10.0141 16.2299 9.96937 16.4818 9.92468C16.7662 9.87593 17.0099 9.83531 17.1765 9.93281C17.2659 9.98156 17.3552 10.0953 17.4487 10.2172C17.4812 10.2619 17.5137 10.3025 17.5543 10.3512C17.5584 10.3553 17.5665 10.3634 17.5705 10.3716C17.408 10.855 17.1684 11.3141 16.8637 11.7203Z" fill="white"/>
                                            </svg>
                                            
                                    </div>
                                    <div class="report-info">
                                        <h5 class="mb-1">{{ __('Branch') }}</h5>
                                        <p class="text-muted mb-0">{{ $filterYear['branch'] }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if ($filterYear['department'] != 'All')
                    <div class="col-xl-12 col-sm-6 col-12">
                        <div class="card report-card mb-0">
                            <div class="card-body d-flex align-items-center gap-3">
                                <div class="report-icon">
                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_4436_1963)">
                                        <path d="M4.85177 18.8417C2.16578 18.8417 0 21.0075 0 23.6935C0 24.0438 0.0424662 24.373 0.100857 24.7074C1.44385 25.4081 3.07349 25.8221 4.84646 25.8221C6.61942 25.8221 8.25437 25.4081 9.59206 24.7074C9.65576 24.3783 9.69292 24.0492 9.69292 23.6935C9.72477 21.0287 7.53245 18.8417 4.85177 18.8417Z" fill="white"/>
                                        <path d="M4.85156 17.7217C6.26463 17.7217 7.41015 16.5762 7.41015 15.1631C7.41015 13.75 6.26463 12.6045 4.85156 12.6045C3.43849 12.6045 2.29297 13.75 2.29297 15.1631C2.29297 16.5762 3.43849 17.7217 4.85156 17.7217Z" fill="white"/>
                                        <path d="M21.1589 18.8417C18.4729 18.8417 16.3071 21.0075 16.3071 23.6935C16.3071 24.0438 16.3496 24.373 16.408 24.7074C17.751 25.4081 19.3806 25.8221 21.1536 25.8221C22.9266 25.8221 24.5615 25.4081 25.8992 24.7074C25.9629 24.3783 26 24.0492 26 23.6935C26.0107 21.0287 23.8449 18.8417 21.1589 18.8417Z" fill="white"/>
                                        <path d="M21.1587 17.7217C22.5718 17.7217 23.7173 16.5762 23.7173 15.1631C23.7173 13.75 22.5718 12.6045 21.1587 12.6045C19.7456 12.6045 18.6001 13.75 18.6001 15.1631C18.6001 16.5762 19.7456 17.7217 21.1587 17.7217Z" fill="white"/>
                                        <path d="M13.0055 13.4114C14.7785 13.4114 16.4134 12.9973 17.7511 12.2966C17.8148 11.9675 17.852 11.6384 17.852 11.2827C17.852 8.59675 15.6862 6.43098 13.0002 6.43098C10.3142 6.43098 8.14844 8.59675 8.14844 11.2827C8.14844 11.6331 8.1909 11.9622 8.24929 12.2966C9.5976 12.9973 11.2325 13.4114 13.0055 13.4114Z" fill="white"/>
                                        <path d="M13.0054 5.29501C14.4184 5.29501 15.564 4.14949 15.564 2.73642C15.564 1.32335 14.4184 0.177826 13.0054 0.177826C11.5923 0.177826 10.4468 1.32335 10.4468 2.73642C10.4468 4.14949 11.5923 5.29501 13.0054 5.29501Z" fill="white"/>
                                        <path d="M13.7061 17.5412V14.5845C13.7061 14.2925 13.4673 14.043 13.17 14.0484C12.8887 14.059 12.671 14.2819 12.671 14.5633V17.5359L10.2982 19.8875C10.0965 20.0892 10.0912 20.413 10.2876 20.62C10.4946 20.8323 10.845 20.827 11.052 20.6147L13.1647 18.502L15.3092 20.6253C15.5163 20.827 15.8454 20.827 16.0524 20.6253C16.2594 20.4183 16.2594 20.0839 16.0524 19.8822L13.7061 17.5412Z" fill="white"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_4436_1963">
                                        <rect width="26" height="26" fill="white"/>
                                        </clipPath>
                                        </defs>
                                        </svg>
                                        
                                </div>
                                <div class="report-info">
                                    <h5 class="mb-1">{{ __('Department') }}</h5>
                                    <p class="text-muted mb-0">{{ $filterYear['department'] }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="col-xl-12 col-sm-6 col-12">
                        <div class="card report-card mb-0">
                            <div class="card-body d-flex align-items-center gap-3">
                                <div class="report-icon">
                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21.6667 5.22996V2.94866C22.3111 2.57293 22.75 1.8819 22.75 1.08332V0.541684C22.75 0.242277 22.5077 0 22.2083 0H3.79168C3.49228 0 3.25 0.242277 3.25 0.541684V1.08337C3.25 1.8819 3.68885 2.57293 4.33332 2.94871V5.22996C4.33332 7.37653 5.24845 9.43104 6.84384 10.8667L9.21416 13L6.84384 15.1333C5.24845 16.569 4.33332 18.6235 4.33332 20.77V23.0513C3.68885 23.4271 3.25 24.1181 3.25 24.9167V25.4584C3.25 25.7577 3.49228 26 3.79168 26H22.2084C22.5078 26 22.7501 25.7577 22.7501 25.4583V24.9166C22.7501 24.1181 22.3112 23.4271 21.6667 23.0513V20.77C21.6667 18.6235 20.7516 16.569 19.1562 15.1333L16.7858 13L19.1562 10.8667C20.7516 9.43104 21.6667 7.37648 21.6667 5.22996ZM17.7068 9.25646L14.442 12.1949C14.2135 12.4002 14.0833 12.6927 14.0833 13C14.0833 13.3073 14.2135 13.5999 14.442 13.8051L17.7068 16.7435C18.8462 17.7692 19.5 19.2371 19.5 20.77V22.75H18.1456L13.4332 16.4669C13.229 16.1939 12.7709 16.1939 12.5667 16.4669L7.85444 22.75H6.5V20.77C6.5 19.2371 7.15381 17.7692 8.29324 16.7435L11.5581 13.805C11.7866 13.5998 11.9167 13.3073 11.9167 12.9999C11.9167 12.6926 11.7866 12.4001 11.5581 12.1949L8.29324 9.25641C7.15381 8.23078 6.5 6.76289 6.5 5.22996V3.25H19.5V5.22996C19.5 6.76289 18.8462 8.23078 17.7068 9.25646Z" fill="white"/>
                                        <path d="M16.7337 7.58331H9.26621C9.05197 7.58331 8.85783 7.70976 8.77109 7.90547C8.68436 8.10174 8.72082 8.33026 8.86524 8.48895L12.6368 11.9685C12.74 12.0622 12.8701 12.1087 13.0002 12.1087C13.1303 12.1087 13.2605 12.0621 13.3636 11.9685L17.1346 8.48895C17.279 8.33026 17.3155 8.10174 17.2288 7.90547C17.1421 7.70976 16.9479 7.58331 16.7337 7.58331Z" fill="white"/>
                                        </svg>
                                        
                                </div>
                                <div class="report-info">
                                    <h5 class="mb-1">{{ __('Duration') }}</h5>
                                    <p class="text-muted mb-0">{{ $filterYear['dateYearRange'] }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-9">
                <div class="row gy-4">
                    <div class="col-md-4 col-sm-6 col-12 leave-card">
                        <div class="leave-card-inner d-flex align-items-center gap-3">
                            <svg class="top-svg" width="81" height="41" viewBox="0 0 81 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M47.5836 35.1535C73.3453 26.3399 79.5986 6.90959 80.6191 0L0.000183105 7.63526e-06L0.000186172 38C6.12314 40.7638 22.5889 43.7047 47.5836 35.1535Z" fill="#FF3A6E"/>
                            </svg>
                            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z" fill="#FF3A6E"/>
                            </svg>
                            <div class="leave-info">
                                <h5 class="mb-2">{{ __('Approved Leaves') }}</h5>
                                <span class="h3">{{ $filter['totalApproved'] }}</span>
                            </div>
                            <div class="leave-icon">
                                <div class="leave-icon-inner">
                                    <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5.24967 22.422C5.20318 22.4684 5.1663 22.5236 5.14114 22.5843C5.11598 22.645 5.10303 22.71 5.10303 22.7757C5.10303 22.8414 5.11598 22.9065 5.14114 22.9672C5.1663 23.0279 5.20318 23.083 5.24967 23.1295L5.95517 23.838L6.66217 23.1305L5.95567 22.421C5.86035 22.3305 5.73389 22.2801 5.60247 22.2803C5.47105 22.2805 5.34473 22.3312 5.24967 22.422Z" fill="white"/>
                                        <path d="M8.07469 19.594L7.72119 19.9475L8.42819 20.6545L8.78219 20.301C8.82861 20.2545 8.86543 20.1994 8.89054 20.1387C8.91565 20.078 8.92857 20.013 8.92854 19.9473C8.92852 19.8816 8.91556 19.8166 8.89041 19.7559C8.86525 19.6953 8.8284 19.6402 8.78194 19.5937C8.73549 19.5473 8.68034 19.5105 8.61966 19.4854C8.55897 19.4603 8.49394 19.4474 8.42827 19.4474C8.36259 19.4474 8.29756 19.4604 8.2369 19.4855C8.17623 19.5107 8.12111 19.5475 8.07469 19.594Z" fill="white"/>
                                        <path d="M24.4994 15C24.4984 14.5127 24.4598 14.0263 24.3839 13.545L13.5444 24.3845C14.8991 24.5979 16.284 24.5149 17.6034 24.1412C18.9229 23.7674 20.1456 23.1119 21.187 22.2197C22.2285 21.3275 23.064 20.22 23.6359 18.9735C24.2078 17.7271 24.5024 16.3714 24.4994 15Z" fill="white"/>
                                        <path d="M10.9033 16.765L10.5498 17.1185L11.2568 17.8255L11.6103 17.472C11.657 17.4259 11.694 17.3709 11.7191 17.3103C11.7443 17.2497 11.7571 17.1846 11.7568 17.119C11.7568 16.9864 11.7041 16.8593 11.6103 16.7655C11.5151 16.6747 11.3885 16.6239 11.2569 16.6238C11.1253 16.6237 10.9987 16.6743 10.9033 16.765Z" fill="white"/>
                                        <path d="M10.7993 27.128C10.9474 27.1216 11.094 27.0965 11.2358 27.0535C11.6818 26.9085 12.1575 26.8804 12.6174 26.9718C13.0774 27.0632 13.5062 27.271 13.8628 27.5755C14.1776 27.8459 14.5785 27.9951 14.9935 27.9962C15.4084 27.9973 15.8101 27.8502 16.1263 27.5815C16.4852 27.2779 16.9152 27.0703 17.3761 26.9781C17.837 26.8858 18.3138 26.9119 18.7618 27.054C18.9382 27.111 19.1224 27.14 19.3078 27.14C19.6289 27.1413 19.9441 27.0531 20.2178 26.8853C20.4916 26.7175 20.7132 26.4767 20.8578 26.19C21.0711 25.7706 21.3881 25.4128 21.7788 25.1506C22.1696 24.8885 22.6209 24.7308 23.0898 24.6925C23.5029 24.662 23.8913 24.4845 24.1848 24.1923C24.4783 23.9001 24.6575 23.5124 24.6898 23.0995C24.7268 22.6288 24.8844 22.1756 25.1473 21.7835C25.4085 21.3897 25.768 21.071 26.1903 20.859C26.4771 20.7145 26.718 20.4929 26.8858 20.2191C27.0536 19.9453 27.1417 19.6301 27.1403 19.309C27.1402 19.1223 27.111 18.9367 27.0538 18.759C26.9088 18.313 26.8806 17.8373 26.972 17.3774C27.0634 16.9174 27.2713 16.4886 27.5758 16.132C27.8464 15.8173 27.9958 15.4164 27.9969 15.0013C27.998 14.5863 27.8508 14.1846 27.5818 13.8685C27.2755 13.5112 27.0661 13.0811 26.9737 12.6197C26.8814 12.1582 26.9091 11.6807 27.0543 11.233C27.0986 11.0909 27.1247 10.9437 27.1318 10.795L25.2388 12.6885C25.4118 13.4468 25.4992 14.2222 25.4993 15C25.4961 17.7838 24.3889 20.4527 22.4204 22.4211C20.452 24.3895 17.7831 25.4968 14.9993 25.5C14.2225 25.4993 13.4481 25.4116 12.6908 25.2385L10.7993 27.128Z" fill="white"/>
                                        <path d="M17.267 11.1085C17.1732 11.0148 17.046 10.9621 16.9135 10.9621C16.7809 10.9621 16.6537 11.0148 16.56 11.1085C16.4662 11.2023 16.4136 11.3294 16.4136 11.462C16.4136 11.5946 16.4662 11.7217 16.56 11.8155L17.974 13.2295C18.0204 13.276 18.0755 13.3129 18.1362 13.338C18.1969 13.3632 18.262 13.3761 18.3277 13.3761C18.3934 13.3761 18.4585 13.3632 18.5192 13.338C18.5799 13.3129 18.635 13.276 18.6815 13.2295C18.775 13.1357 18.8276 13.0087 18.8276 12.8762C18.8276 12.7438 18.775 12.6167 18.6815 12.523L17.267 11.1085Z" fill="white"/>
                                        <path d="M13.7319 13.9365L13.3779 14.2905L14.0854 15L14.4389 14.6465C14.4854 14.6001 14.5222 14.545 14.5474 14.4843C14.5725 14.4236 14.5855 14.3586 14.5855 14.2929C14.5856 14.2273 14.5726 14.1622 14.5475 14.1015C14.5224 14.0409 14.4856 13.9857 14.4392 13.9393C14.3928 13.8928 14.3376 13.856 14.277 13.8308C14.2163 13.8056 14.1513 13.7927 14.0856 13.7927C14.0199 13.7926 13.9549 13.8056 13.8942 13.8307C13.8335 13.8558 13.7784 13.8926 13.7319 13.939V13.9365Z" fill="white"/>
                                        <path d="M24.2147 1.44997C23.9244 1.16219 23.5322 1.00073 23.1234 1.00073C22.7147 1.00073 22.3225 1.16219 22.0322 1.44997L1.4497 22.0325C1.16107 22.3223 0.999023 22.7147 0.999023 23.1237C0.999023 23.5328 1.16107 23.9251 1.4497 24.215L5.7847 28.55C6.0746 28.8385 6.46695 29.0004 6.87595 29.0004C7.28494 29.0004 7.6773 28.8385 7.9672 28.55L28.5497 7.96747C28.8383 7.67764 29.0004 7.28526 29.0004 6.87622C29.0004 6.46719 28.8383 6.07481 28.5497 5.78497L24.2147 1.44997ZM8.7762 24.55C8.68243 24.6437 8.55528 24.6964 8.4227 24.6964C8.29012 24.6964 8.16296 24.6437 8.0692 24.55L7.3647 23.8395L6.6572 24.547L7.3642 25.257C7.4118 25.3032 7.44972 25.3585 7.47574 25.4196C7.50176 25.4807 7.51535 25.5463 7.51573 25.6127C7.51612 25.6791 7.50328 25.7449 7.47796 25.8062C7.45265 25.8676 7.41537 25.9233 7.36829 25.9701C7.32122 26.0169 7.2653 26.0539 7.20379 26.0788C7.14228 26.1038 7.07642 26.1163 7.01004 26.1155C6.94366 26.1148 6.8781 26.1008 6.81718 26.0744C6.75625 26.0481 6.70119 26.0098 6.6552 25.962L4.5387 23.8355C4.25764 23.5542 4.09977 23.1728 4.09977 22.7752C4.09977 22.3776 4.25764 21.9962 4.5387 21.715C4.82442 21.4423 5.20422 21.2901 5.5992 21.2901C5.99417 21.2901 6.37397 21.4423 6.6597 21.715L8.7772 23.8425C8.82362 23.889 8.86042 23.9442 8.8855 24.0049C8.91057 24.0656 8.92343 24.1307 8.92334 24.1964C8.92325 24.2621 8.91021 24.3272 8.88496 24.3878C8.85971 24.4485 8.82275 24.5036 8.7762 24.55ZM10.1967 23.1295C10.1503 23.176 10.0951 23.2128 10.0344 23.238C9.97372 23.2632 9.90866 23.2761 9.84295 23.2761C9.77724 23.2761 9.71218 23.2632 9.65148 23.238C9.59078 23.2128 9.53563 23.176 9.4892 23.1295L8.0747 21.715L6.6607 20.3C6.56696 20.2062 6.5143 20.0791 6.5143 19.9465C6.5143 19.8139 6.56696 19.6867 6.6607 19.593L7.3677 18.8855C7.507 18.7461 7.67238 18.6356 7.85439 18.5602C8.03641 18.4848 8.2315 18.4459 8.42852 18.4459C8.62554 18.4459 8.82064 18.4847 9.00268 18.5601C9.18471 18.6354 9.35011 18.7459 9.48945 18.8852C9.62878 19.0245 9.73931 19.1899 9.81473 19.3719C9.89015 19.5539 9.92898 19.749 9.929 19.946C9.92902 20.1431 9.89024 20.3382 9.81487 20.5202C9.73949 20.7022 9.629 20.8676 9.4897 21.007L9.1362 21.3605L10.1972 22.421C10.2437 22.4674 10.2806 22.5227 10.3058 22.5834C10.331 22.6442 10.3439 22.7093 10.3438 22.7751C10.3438 22.8408 10.3308 22.906 10.3055 22.9667C10.2803 23.0274 10.2433 23.0831 10.1967 23.1295ZM13.0247 20.3C12.9309 20.3937 12.8038 20.4464 12.6712 20.4464C12.5386 20.4464 12.4115 20.3937 12.3177 20.3L10.9037 18.885L9.4892 17.471C9.39546 17.3772 9.3428 17.2501 9.3428 17.1175C9.3428 16.9849 9.39546 16.8577 9.4892 16.764L10.1967 16.057C10.3351 15.9137 10.5006 15.7994 10.6836 15.7208C10.8666 15.6422 11.0634 15.6008 11.2626 15.5991C11.4618 15.5974 11.6593 15.6353 11.8436 15.7107C12.028 15.7862 12.1955 15.8975 12.3363 16.0384C12.4771 16.1792 12.5885 16.3467 12.6639 16.531C12.7394 16.7154 12.7773 16.9129 12.7756 17.1121C12.7738 17.3112 12.7325 17.5081 12.6538 17.6911C12.5752 17.8741 12.461 18.0396 12.3177 18.178L11.9642 18.532L13.0247 19.593C13.1184 19.6867 13.1711 19.8139 13.1711 19.9465C13.1711 20.0791 13.1184 20.2062 13.0247 20.3ZM17.2672 16.057C17.1734 16.1507 17.0463 16.2034 16.9137 16.2034C16.7811 16.2034 16.654 16.1507 16.5602 16.057L15.8532 15.35C15.7594 15.2562 15.6323 15.2036 15.4997 15.2036C15.3671 15.2036 15.24 15.2562 15.1462 15.35L14.7927 15.7035L15.8532 16.764C15.901 16.8101 15.939 16.8653 15.9652 16.9263C15.9915 16.9873 16.0052 17.0529 16.0058 17.1193C16.0064 17.1857 15.9938 17.2515 15.9686 17.3129C15.9435 17.3744 15.9063 17.4302 15.8594 17.4772C15.8124 17.5241 15.7566 17.5612 15.6952 17.5864C15.6337 17.6115 15.5679 17.6242 15.5015 17.6236C15.4351 17.623 15.3695 17.6092 15.3085 17.583C15.2475 17.5568 15.1923 17.5187 15.1462 17.471L13.7322 16.057L12.3177 14.643C12.224 14.5492 12.1713 14.4221 12.1713 14.2895C12.1713 14.1569 12.224 14.0297 12.3177 13.936L13.0252 13.2285C13.2295 13.0224 13.4893 12.8804 13.773 12.8196C14.0567 12.7589 14.352 12.7821 14.6227 12.8864C14.8935 12.9907 15.1279 13.1716 15.2975 13.407C15.4671 13.6424 15.5645 13.9221 15.5777 14.212C15.9474 14.2285 16.2977 14.3821 16.5602 14.643L17.2672 15.35C17.3138 15.3964 17.3507 15.4516 17.3759 15.5123C17.4011 15.5731 17.4141 15.6382 17.4141 15.704C17.4141 15.7697 17.4011 15.8349 17.3759 15.8956C17.3507 15.9564 17.3138 16.0115 17.2672 16.058V16.057ZM19.3887 13.9355C19.2494 14.0748 19.084 14.1853 18.902 14.2607C18.72 14.3361 18.525 14.3749 18.3279 14.3749C18.1309 14.3749 17.9359 14.3361 17.7539 14.2607C17.5719 14.1853 17.4065 14.0748 17.2672 13.9355L15.8532 12.5215C15.572 12.2402 15.414 11.8587 15.414 11.461C15.414 11.0632 15.572 10.6818 15.8532 10.4005C16.139 10.1277 16.5189 9.97557 16.9139 9.97557C17.309 9.97557 17.6889 10.1277 17.9747 10.4005L19.3887 11.8145C19.6699 12.0958 19.8279 12.4772 19.8279 12.875C19.8279 13.2727 19.6699 13.6542 19.3887 13.9355ZM22.2172 11.1075C22.1383 11.1863 22.0353 11.2366 21.9246 11.2501C21.8139 11.2637 21.7018 11.2399 21.6062 11.1825L18.0712 9.06097C17.9575 8.99275 17.8755 8.88214 17.8434 8.75349C17.8112 8.62484 17.8315 8.48868 17.8997 8.37497C17.9679 8.26126 18.0785 8.17931 18.2072 8.14715C18.3358 8.11498 18.472 8.13524 18.5857 8.20347L20.4057 9.29597L19.3137 7.47547C19.2455 7.36176 19.2252 7.2256 19.2574 7.09695C19.2895 6.9683 19.3715 6.8577 19.4852 6.78947C19.5989 6.72125 19.7351 6.70098 19.8637 6.73315C19.9924 6.76531 20.103 6.84726 20.1712 6.96097L22.2922 10.5C22.349 10.5953 22.3725 10.7069 22.3589 10.8171C22.3453 10.9272 22.2955 11.0298 22.2172 11.1085V11.1075ZM25.7527 7.57197L24.6922 8.63247C24.5047 8.81994 24.2504 8.92526 23.9852 8.92526C23.72 8.92526 23.4657 8.81994 23.2782 8.63247L21.1562 6.51097C21.0633 6.41811 20.9896 6.30785 20.9393 6.1865C20.889 6.06515 20.8632 5.93508 20.8632 5.80372C20.8632 5.67237 20.889 5.5423 20.9393 5.42094C20.9896 5.29959 21.0633 5.18934 21.1562 5.09647L22.2172 4.03597C22.2637 3.98952 22.3189 3.95267 22.3796 3.92754C22.4403 3.90242 22.5054 3.88949 22.5711 3.88952C22.6368 3.88954 22.7019 3.90251 22.7626 3.92768C22.8233 3.95285 22.8785 3.98973 22.9249 4.03622C22.9714 4.08271 23.0082 4.13789 23.0334 4.19862C23.0585 4.25935 23.0714 4.32443 23.0714 4.39015C23.0714 4.45587 23.0584 4.52094 23.0332 4.58165C23.0081 4.64236 22.9712 4.69752 22.9247 4.74397L21.8637 5.80497L22.5707 6.51247L22.9247 6.15847C23.019 6.06739 23.1453 6.017 23.2764 6.01814C23.4075 6.01927 23.5329 6.07186 23.6256 6.16456C23.7183 6.25727 23.7709 6.38267 23.772 6.51377C23.7732 6.64487 23.7228 6.77117 23.6317 6.86547L23.2777 7.21947L23.9852 7.92647L25.0457 6.86547C25.1395 6.77172 25.2667 6.71907 25.3994 6.71912C25.532 6.71917 25.6592 6.7719 25.753 6.86572C25.8467 6.95954 25.8993 7.08676 25.8993 7.2194C25.8993 7.35203 25.8465 7.47922 25.7527 7.57297V7.57197Z" fill="white"/>
                                        <path d="M5.49953 15C5.50056 15.4872 5.53917 15.9737 5.61503 16.455L16.4545 5.61548C15.0999 5.40202 13.715 5.48502 12.3955 5.85877C11.0761 6.23251 9.85341 6.8881 8.81192 7.78028C7.77043 8.67246 6.93492 9.78 6.36305 11.0265C5.79118 12.2729 5.49656 13.6286 5.49953 15Z" fill="white"/>
                                        <path d="M19.1995 2.87153C19.0514 2.87837 18.9048 2.90356 18.763 2.94653C18.3168 3.09187 17.8408 3.1202 17.3806 3.0288C16.9203 2.93739 16.4912 2.72933 16.1345 2.42453C15.8198 2.1539 15.4189 2.00459 15.0038 2.00349C14.5888 2.00239 14.1871 2.14958 13.871 2.41853C13.5123 2.72238 13.0823 2.93017 12.6213 3.02244C12.1603 3.1147 11.6835 3.08841 11.2355 2.94603C11.0591 2.88901 10.8749 2.85999 10.6895 2.86003C10.3684 2.85872 10.0532 2.94691 9.77945 3.11472C9.50566 3.28252 9.28405 3.5233 9.13948 3.81003C8.92656 4.22989 8.60962 4.58821 8.21889 4.8508C7.82816 5.11339 7.37667 5.27149 6.90748 5.31003C6.49443 5.34055 6.10597 5.51799 5.81246 5.81022C5.51895 6.10244 5.33981 6.49012 5.30748 6.90303C5.27007 7.37322 5.11235 7.82589 4.84948 8.21753C4.58829 8.61129 4.22875 8.92999 3.80648 9.14203C3.51967 9.28651 3.27884 9.5081 3.11102 9.78191C2.9432 10.0557 2.85505 10.3709 2.85648 10.692C2.85661 10.8787 2.88579 11.0643 2.94298 11.242C3.08767 11.6872 3.11594 12.162 3.02508 12.6211C2.93423 13.0803 2.72729 13.5085 2.42398 13.865C2.15336 14.1797 2.00404 14.5807 2.00294 14.9957C2.00184 15.4107 2.14903 15.8124 2.41798 16.1285C2.84471 16.6259 3.07936 17.2596 3.07948 17.915C3.07948 18.2036 3.03426 18.4904 2.94548 18.765C2.90115 18.9071 2.87511 19.0543 2.86798 19.203L4.76098 17.3095C4.58776 16.5519 4.50005 15.7772 4.49948 15C4.50265 12.2162 5.60992 9.54736 7.57836 7.57891C9.54681 5.61047 12.2157 4.5032 14.9995 4.50003C15.7763 4.50067 16.5507 4.58839 17.308 4.76153L19.1995 2.87153Z" fill="white"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12 leave-card">
                        <div class="leave-card-inner d-flex align-items-center gap-3">
                            <svg class="top-svg" width="81" height="41" viewBox="0 0 81 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M47.5836 35.1535C73.3453 26.3399 79.5986 6.90959 80.6191 0L0.000183105 7.63526e-06L0.000186172 38C6.12314 40.7638 22.5889 43.7047 47.5836 35.1535Z" fill="#FF3A6E"/>
                            </svg>
                            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z" fill="#FF3A6E"/>
                            </svg>
                            <div class="leave-info">
                                <h5 class="mb-2">{{ __('Rejected Leave') }}</h5>
                                <span class="h3">{{ $filter['totalReject'] }}</span>
                            </div>
                            <div class="leave-icon">
                                <div class="leave-icon-inner">
                                    <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_34_698)">
                                        <path d="M23.7119 15.7063C23.3682 19.9688 19.9619 23.375 15.7057 23.7125L11.2119 28.2063C19.7932 30.825 28.8869 23.975 28.7494 15C28.7494 13.7125 28.5619 12.4375 28.2057 11.2125L23.7119 15.7063Z" fill="white"/>
                                        <path d="M6.28709 14.2937C6.63084 10.0312 10.0371 6.62499 14.2933 6.28749L18.7871 1.79374C10.2058 -0.825011 1.11209 6.02499 1.24959 15C1.24959 16.2875 1.43709 17.5625 1.79334 18.7875L6.28709 14.2937Z" fill="white"/>
                                        <path d="M22.5298 5.73962L22.9717 5.29768L24.7395 7.06545L24.2976 7.50739L22.5298 5.73962Z" fill="white"/>
                                        <path d="M5.71816 22.6437C5.58691 22.6062 5.36816 22.8625 5.27441 22.9562L5.71816 23.4L5.93691 23.1812C6.14941 22.975 5.96816 22.6312 5.71816 22.6437Z" fill="white"/>
                                        <path d="M24.4494 0.550003C23.7494 -0.174997 22.4994 -0.181247 21.7994 0.550003C21.7994 0.550003 4.24941 18.1 0.549414 21.8C-0.181836 22.5313 -0.181836 23.7188 0.549414 24.45L5.54941 29.45C6.24941 30.175 7.50566 30.175 8.19941 29.45L13.9682 23.6813C17.7557 19.8938 25.7494 11.9 29.4494 8.2C30.1807 7.46875 30.1807 6.28125 29.4494 5.55L24.4494 0.550003ZM8.24941 24.8938L6.96191 24.6375L7.49316 25.1688C7.89316 25.5375 7.58691 26.2563 7.04941 26.2375C6.88691 26.2375 6.73066 26.175 6.60566 26.0563L3.95566 23.4063C3.38691 22.7938 4.25566 22.2688 4.61816 21.8625C5.73066 20.7438 7.71191 21.9 7.21816 23.425L8.49941 23.6813C9.29316 23.8313 9.04941 25.05 8.24941 24.8938ZM11.0244 22.5125L10.1432 23.3938C9.91191 23.6375 9.49316 23.6375 9.26191 23.3938L6.61191 20.7438C6.49316 20.625 6.43066 20.4688 6.43066 20.3C6.37441 19.9188 7.19941 19.3313 7.49941 18.975C8.08066 18.4 8.95566 19.2813 8.38066 19.8563L7.93691 20.3L8.38066 20.7438L8.82441 20.3C9.40566 19.725 10.2869 20.6063 9.70566 21.1813L9.26191 21.625L9.70566 22.0688L10.1494 21.625C10.7182 21.0563 11.5994 21.9313 11.0244 22.5125ZM13.0119 20.525C12.3057 21.2438 11.1807 21.0688 10.5807 20.3063C10.0057 19.725 10.8869 18.85 11.4619 19.425L11.6807 19.6438C11.9619 19.9313 12.4119 19.4875 12.1244 19.2L10.1369 17.2125C9.89316 16.9688 9.89316 16.575 10.1369 16.3313C10.3807 16.0875 10.7744 16.0875 11.0182 16.3313L13.0057 18.3188C13.6182 18.8938 13.6182 19.9438 13.0119 20.525ZM15.8807 17.65L14.9994 18.5375C14.7557 18.7813 14.3619 18.7813 14.1182 18.5375C13.4557 17.875 12.1244 16.55 11.4682 15.8875C11.2244 15.6438 11.2244 15.25 11.4682 15.0063L12.3494 14.125C12.9307 13.55 13.8057 14.425 13.2307 15.0063L12.7869 15.45L13.2307 15.8938L13.6744 15.45C14.2557 14.875 15.1369 15.7563 14.5557 16.3313L14.1119 16.775L14.5557 17.2188L14.9994 16.7688C15.5807 16.1938 16.4619 17.0688 15.8807 17.65ZM18.0932 15.4438L17.6494 15.8875C17.1619 16.375 16.3682 16.375 15.8807 15.8875L14.1119 14.1188C13.6244 13.6313 13.6244 12.8375 14.1119 12.35L14.5557 11.9063C14.7994 11.6625 15.1932 11.6625 15.4369 11.9063C15.6807 12.15 15.6807 12.5438 15.4369 12.7875L14.9994 13.2313L16.7682 15L17.2119 14.5563C17.7869 13.9813 18.6682 14.8625 18.0932 15.4438ZM20.3057 13.2313C20.0619 13.475 19.6682 13.475 19.4244 13.2313L17.2119 11.0188L16.7682 11.4625C16.5244 11.7063 16.1307 11.7063 15.8869 11.4625C15.6432 11.2188 15.6432 10.825 15.8869 10.5813L17.6557 8.8125C17.8994 8.56875 18.2932 8.56875 18.5369 8.8125C18.7807 9.05625 18.7807 9.45 18.5369 9.69375L18.0932 10.1375L20.3057 12.35C20.5494 12.5938 20.5494 12.9875 20.3057 13.2313ZM23.3994 10.1375L22.5182 11.0188C22.2744 11.2625 21.8807 11.2625 21.6369 11.0188L18.9869 8.36875C18.7432 8.125 18.7432 7.73125 18.9869 7.4875L19.8682 6.60625C20.4494 6.03125 21.3244 6.90625 20.7494 7.4875L20.3057 7.93125L20.7494 8.375L21.1932 7.93125C21.7744 7.35625 22.6557 8.2375 22.0744 8.8125L21.6307 9.25625L22.0744 9.7L22.5182 9.25625C23.0932 8.68125 23.9744 9.55625 23.3994 10.1375ZM25.6244 7.94375L24.7432 8.825C24.5119 9.06875 24.0932 9.06875 23.8619 8.825L21.2119 6.175C20.9682 5.93125 20.9682 5.5375 21.2119 5.29375L22.0932 4.4125C22.5807 3.925 23.3744 3.925 23.8619 4.4125L25.6244 6.18125C26.1057 6.64375 26.1057 7.48125 25.6244 7.94375Z" fill="white"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_34_698">
                                        <rect width="30" height="30" fill="white" transform="translate(-0.000488281)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12 leave-card">
                        <div class="leave-card-inner d-flex align-items-center gap-3">
                            <svg class="top-svg" width="81" height="41" viewBox="0 0 81 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M47.5836 35.1535C73.3453 26.3399 79.5986 6.90959 80.6191 0L0.000183105 7.63526e-06L0.000186172 38C6.12314 40.7638 22.5889 43.7047 47.5836 35.1535Z" fill="#FF3A6E"/>
                            </svg>
                            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z" fill="#FF3A6E"/>
                            </svg>
                            <div class="leave-info">
                                <h5 class="mb-2">{{ __('Pending Leaves') }}</h5>
                                <span class="h3">{{ $filter['totalPending'] }}</span>
                            </div>
                            <div class="leave-icon">
                                <div class="leave-icon-inner">
                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.9995 0.8125C10.5891 0.8125 8.23273 1.52728 6.22851 2.86646C4.22428 4.20564 2.66218 6.10907 1.73974 8.33605C0.817292 10.563 0.575939 13.0135 1.0462 15.3777C1.51645 17.7418 2.6772 19.9134 4.38165 21.6179C6.08611 23.3223 8.25771 24.4831 10.6219 24.9533C12.986 25.4236 15.4365 25.1822 17.6635 24.2598C19.8904 23.3373 21.7939 21.7752 23.1331 19.771C24.4722 17.7668 25.187 15.4105 25.187 13C25.1837 9.76869 23.8986 6.67067 21.6137 4.38579C19.3288 2.10091 16.2308 0.815809 12.9995 0.8125ZM17.412 17.4125C17.2362 17.5881 16.998 17.6867 16.7495 17.6867C16.5011 17.6867 16.2628 17.5881 16.087 17.4125L12.337 13.6625C12.1612 13.4869 12.0622 13.2486 12.062 13V5.5C12.062 5.25136 12.1608 5.0129 12.3366 4.83709C12.5124 4.66127 12.7509 4.5625 12.9995 4.5625C13.2482 4.5625 13.4866 4.66127 13.6624 4.83709C13.8382 5.0129 13.937 5.25136 13.937 5.5V12.6125L17.412 16.0875C17.5876 16.2633 17.6862 16.5016 17.6862 16.75C17.6862 16.9984 17.5876 17.2367 17.412 17.4125Z" fill="white"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-body table-border-style">
                        <div class="table-responsive py-4">
                            <table class="table mb-0" id="report-dataTable">
                                <thead>
                                <tr>
                                    <th>{{__('Employee ID')}}</th>
                                    <th>{{__('Employee')}}</th>
                                    <th>{{__('Approved Leaves')}}</th>
                                    <th>{{__('Rejected Leaves')}}</th>
                                    <th>{{__('Pending Leaves')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($leaves as $leave)
                                    <tr>
                                        <td><a href="#" class="btn btn-sm btn-outline-primary">{{ \Auth::user()->employeeIdFormat($leave['employee_id']) }}</a></td>
                                        <td>{{$leave['employee']}}</td>
                                        <td>
                                            <div class="m-view-btn badge bg-info p-2 px-3 rounded">{{$leave['approved']}}
                                                <a href="#" class="text-white text-decoration-none" data-url="{{ route('report.employee.leave',[$leave['id'],'Approved',isset($_GET['type']) ?$_GET['type']:'no',isset($_GET['month'])?$_GET['month']:date('Y-m'),isset($_GET['year'])?$_GET['year']:date('Y')]) }}" data-ajax-popup="true" data-title="{{__('Approved Leave Detail')}}" data-bs-toggle="tooltip" title="{{__('View')}}" data-original-title="{{__('View')}}">{{__('View')}}</a>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="m-view-btn badge bg-danger p-2 px-3 rounded">{{$leave['reject']}}
                                                <a href="#" class="text-white text-decoration-none" data-url="{{ route('report.employee.leave',[$leave['id'],'Reject',isset($_GET['type']) ?$_GET['type']:'no',isset($_GET['month'])?$_GET['month']:date('Y-m'),isset($_GET['year'])?$_GET['year']:date('Y')]) }}" class="table-action table-action-delete" data-ajax-popup="true" data-title="{{__('Rejected Leave Detail')}}" data-bs-toggle="tooltip" title="{{__('View')}}" data-original-title="{{__('View')}}">{{__('View')}}</a>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="m-view-btn badge bg-warning p-2 px-3 rounded">{{$leave['pending']}}
                                                <a href="#" class="text-white text-decoration-none" data-url="{{ route('report.employee.leave',[$leave['id'],'Pending',isset($_GET['type']) ?$_GET['type']:'no',isset($_GET['month'])?$_GET['month']:date('Y-m'),isset($_GET['year'])?$_GET['year']:date('Y')]) }}" class="table-action table-action-delete" data-ajax-popup="true" data-title="{{__('Pending Leave Detail')}}" data-bs-toggle="tooltip" title="{{__('View')}}" data-original-title="{{__('View')}}">{{__('View')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

