@extends('layouts.admin')
@section('page-title')
    {{__('Manage Monthly Attendance')}}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Monthly Attendance')}}</li>
@endsection
@push('script-page')
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A2'}
            };
            html2pdf().set(opt).from(element).save();
        }
    </script>

    <script>

        $(document).ready(function () {
            var b_id = $('#branch_id').val();
            // getDepartment(b_id);
        });
        $(document).on('change', 'select[name=branch_id]', function () {

            var branch_id = $(this).val();
            getDepartment(branch_id);
        });

        function getDepartment(bid) {

            $.ajax({
                url: '{{route('report.attendance.getdepartment')}}',
                type: 'POST',
                data: {
                    "branch_id": bid,
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data) {
                    //console.log(data);
                    $('#department_id').empty();
                    $("#department_div").html('');
                    $('#department_div').append('<label for="department" class="form-label">{{__('Department')}}</label><select class="form-control" id="department_id" name="department_id[]"  ></select>');
                    $('#department_id').append('<option value="">{{__('Select Department')}}</option>');
                    $('#department_id').append('<option value="0"> {{__('All Department')}} </option>');
                    $.each(data, function (key, value) {
                        //console.log(key, value);
                        $('#department_id').append('<option value="' + key + '">' + value + '</option>');
                    });
                    // var multipleCancelButton = new Choices('#department_id', {
                    //     removeItemButton: true,
                    // });


                }

            });
        }

        $(document).on('change', '#department_id', function () {
            var department_id = $(this).val();
            getEmployee(department_id);
        });

        function getEmployee(did) {
            $.ajax({
                url: '{{route('report.attendance.getemployee')}}',
                type: 'POST',
                data: {
                    "department_id": did, "_token": "{{ csrf_token() }}",
                },
                success: function (data) {
                    console.log(data);
                    $('#employee_id').empty();
                    $("#employee_div").html('');
                    // $('#employee_div').append('<select class="form-control" id="employee_id" name="employee_id[]"  multiple></select>');
                    $('#employee_div').append('<label for="employee" class="form-label">{{__('Employee')}}</label><select class="form-control" id="employee_id" name="employee_id[]"  multiple></select>');
                    $('#employee_id').append('<option value="">{{__('Select Employee')}}</option>');
                    $('#employee_id').append('<option value="0"> {{__('All Employee')}} </option>');

                    $.each(data, function (key, value) {
                        $('#employee_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                    var multipleCancelButton = new Choices('#employee_id', {
                        removeItemButton: true,
                    });
                }
            });
        }
    </script>
@endpush



@section('action-btn')
    <div class="float-end">
        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()" data-bs-toggle="tooltip" title="{{ __('Download') }}"
           data-original-title="{{ __('Download') }}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>

{{--        <a href="{{route('report.attendance',[isset($_GET['month'])?$_GET['month']:date('Y-m'),isset($_GET['branch'])?$_GET['branch']:0,isset($_GET['department'])?$_GET['department']:0])}}" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="{{__('Download')}}" data-original-title="{{__('Download')}}">--}}
{{--            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>--}}
{{--        </a>--}}

    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class=" mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        {{ Form::open(array('route' => array('report.monthly.attendance'),'method'=>'get','id'=>'report_monthly_attendance')) }}
                        <div class="row align-items-center justify-content-end">
                            <div class="col-xl-10">
                                <div class="row">
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{Form::label('month',__('Month'),['class'=>'form-label'])}}
                                            {{Form::month('month',isset($_GET['month'])?$_GET['month']:date('Y-m'),array('class'=>'month-btn form-control'))}}
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('branch', __('Branch'),['class'=>'form-label']) }}
{{--                                            {{ Form::select('branch', $branch,isset($_GET['branch'])?$_GET['branch']:'', array('class' => 'form-control select')) }}--}}

                                            <select class="form-control select" name="branch_id" id="branch_id"  placeholder="Select Branch" required>
                                                <option value="">{{__('Select Branch')}}</option>
                                                <option value="0">{{__('All Branch')}}</option>
                                                @foreach($branch as $branch)
                                                    <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box" id="department_div">
                                            {{ Form::label('department', __('Department'),['class'=>'form-label']) }}
{{--                                            {{ Form::select('department', $department,isset($_GET['department'])?$_GET['department']:'', array('class' => 'form-control select')) }}--}}
                                            <select class="form-control select" name="department_id[]" id="department_id" required="required" placeholder="Select Department" >
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box" id="employee_div">
                                            {{ Form::label('employee', __('Employee'),['class'=>'form-label']) }}
                                            <select class="form-control select" name="employee_id[]" id="employee_id" placeholder="Select Employee" >
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <div class="row">
                                    <div class="col-auto mt-4">
                                        <a href="#" class="btn btn-sm btn-primary me-1" onclick="document.getElementById('report_monthly_attendance').submit(); return false;" data-bs-toggle="tooltip" title="{{__('Apply')}}" data-original-title="{{__('apply')}}">
                                            <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                        </a>
                                        <a href="{{route('report.monthly.attendance')}}" class="btn btn-sm btn-danger " data-bs-toggle="tooltip"  title="{{ __('Reset') }}" data-original-title="{{__('Reset')}}">
                                            <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off "></i></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>

    <div id="printableArea">
        <div class="row">
            <div class="col mb-4">
                <div class="card report-card mb-0 h-100 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3.09766 0.761719V20.668C3.09766 21.089 3.43835 21.4297 3.85938 21.4297H17.5703C17.9913 21.4297 18.332 21.089 18.332 20.668V0.761719C18.332 0.340691 17.9913 0 17.5703 0H3.85938C3.43835 0 3.09766 0.340691 3.09766 0.761719ZM15.2852 17.5703H12.2383C11.8173 17.5703 11.4766 17.2296 11.4766 16.8086C11.4766 16.3876 11.8173 16.0469 12.2383 16.0469H15.2852C15.7062 16.0469 16.0469 16.3876 16.0469 16.8086C16.0469 17.2296 15.7062 17.5703 15.2852 17.5703ZM6.14453 3.85938H10.7148C11.1359 3.85938 11.4766 4.20007 11.4766 4.62109C11.4766 5.04212 11.1359 5.38281 10.7148 5.38281H6.14453C5.7235 5.38281 5.38281 5.04212 5.38281 4.62109C5.38281 4.20007 5.7235 3.85938 6.14453 3.85938ZM6.14453 6.90625H15.2852C15.7062 6.90625 16.0469 7.24694 16.0469 7.66797C16.0469 8.089 15.7062 8.42969 15.2852 8.42969H6.14453C5.7235 8.42969 5.38281 8.089 5.38281 7.66797C5.38281 7.24694 5.7235 6.90625 6.14453 6.90625ZM6.14453 9.95312H15.2852C15.7062 9.95312 16.0469 10.2938 16.0469 10.7148C16.0469 11.1359 15.7062 11.4766 15.2852 11.4766H6.14453C5.7235 11.4766 5.38281 11.1359 5.38281 10.7148C5.38281 10.2938 5.7235 9.95312 6.14453 9.95312ZM6.14453 13H15.2852C15.7062 13 16.0469 13.3407 16.0469 13.7617C16.0469 14.1827 15.7062 14.5234 15.2852 14.5234H6.14453C5.7235 14.5234 5.38281 14.1827 5.38281 13.7617C5.38281 13.3407 5.7235 13 6.14453 13Z"
                                    fill="white" />
                                <path
                                    d="M8.42969 26H22.1406C22.5617 26 22.9023 25.6593 22.9023 25.2383V5.38281C22.9023 4.96179 22.5617 4.62109 22.1406 4.62109H19.8555V20.668C19.8555 21.9281 18.8304 22.9531 17.5703 22.9531H7.66797V25.2383C7.66797 25.6593 8.00866 26 8.42969 26Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="report-info flex-1">
                            <input type="hidden" value="{{  $data['branch'] .' '.__('Branch') .' '.$data['curMonth'].' '.__('Attendance Report of').' '. $data['department'].' '.'Department'}}" id="filename">
                            <h5 class="mb-1">{{ __('Report') }}</h5>
                            <p class="text-muted mb-0">{{ __('Attendance Summary') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @if($data['branch']!='All')
                <div class="col mb-4">
                    <div class="card report-card mb-0 h-100 py-2">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.9998 0.8125C8.61229 0.8125 5.04541 4.38344 5.04541 8.76687C5.04541 13.1909 7.88916 17.4322 10.1195 20.0769C8.12072 20.4262 6.2276 21.2103 6.2276 22.5103C6.2276 24.2491 9.71729 25.1875 12.9998 25.1875C16.2823 25.1875 19.772 24.2491 19.772 22.5103C19.772 21.2103 17.8788 20.4262 15.8801 20.0769C18.1104 17.4322 20.9542 13.1909 20.9542 8.76687C20.9542 4.38344 17.3873 0.8125 12.9998 0.8125ZM12.9998 21.9538C11.6673 20.6781 5.85791 14.7794 5.85791 8.76687C5.85791 4.83031 9.05916 1.625 12.9998 1.625C16.9404 1.625 20.1417 4.83031 20.1417 8.76687C20.1417 14.7753 14.3323 20.6781 12.9998 21.9538Z" fill="white"/>
                                    <path d="M13.8168 3.25C13.8127 3.25 13.8046 3.24593 13.8005 3.24593C12.6549 3.07937 11.5621 3.26218 10.5668 3.7375C8.6168 4.66781 7.35742 6.66656 7.35742 8.83187C7.35742 9.08781 7.37773 9.34781 7.4143 9.59562V9.59968C7.52398 10.4122 7.80836 11.18 8.23492 11.8544C8.66148 12.5287 9.2343 13.1137 9.92086 13.5566C10.839 14.1537 11.8993 14.4706 13.0002 14.4706C13.374 14.4706 13.7437 14.43 14.1093 14.3569C14.1905 14.3406 14.2677 14.3203 14.349 14.3C14.6821 14.2187 15.0071 14.1131 15.3199 13.9709C16.043 13.6459 16.6971 13.1666 17.2334 12.5612C17.7818 11.9397 18.1962 11.1881 18.4237 10.3878C18.5699 9.88 18.643 9.35593 18.643 8.83187C18.643 6.045 16.5671 3.64406 13.8168 3.25ZM16.8637 11.7203C16.5549 11.5212 16.1974 11.3872 15.8399 11.3628C15.3687 11.3262 15.0071 11.4806 14.743 11.5944C14.5602 11.6756 14.4465 11.7244 14.3937 11.6959C14.3165 11.6594 14.2109 11.4806 14.158 11.0947C14.1093 10.7575 13.9184 10.4609 13.638 10.2862C13.3902 10.1359 13.1018 10.0872 12.8134 10.14C12.3218 10.2416 11.6027 10.4853 10.9649 11.0703C10.8187 11.2044 10.2255 11.7934 9.9168 12.545C9.19773 11.9519 8.67773 11.1637 8.40148 10.2781C8.76711 10.4041 9.14898 10.4772 9.53492 10.4772C9.85586 10.4772 10.1768 10.4325 10.4855 10.3391C10.9121 10.2131 11.2493 10.0222 11.493 9.76625C11.818 9.43312 11.9846 8.97812 11.9318 8.55562C11.9115 8.40125 11.8668 8.27531 11.7815 8.14531C11.7002 8.03562 11.6027 7.95843 11.5052 7.88937C11.3915 7.82031 11.2696 7.75937 11.1477 7.7025C10.973 7.61718 10.8187 7.54406 10.7374 7.4425C10.583 7.24343 10.6602 6.89 10.7821 6.61781C10.8349 6.50406 10.8918 6.39437 10.9487 6.28468C11.103 5.99218 11.2615 5.6875 11.3224 5.32187C11.363 5.06593 11.3468 4.68812 11.2534 4.33062C11.8059 4.11531 12.3909 4.00156 13.0002 4.00156H13.0652C12.9962 4.13562 12.9352 4.26968 12.8905 4.42C12.7402 4.91562 12.7971 5.41531 13.049 5.78906C13.2684 6.10187 13.5893 6.28062 13.8696 6.43906C14.1337 6.58531 14.3612 6.71125 14.4262 6.89C14.4871 7.0525 14.4343 7.26781 14.3693 7.51968C14.3327 7.66187 14.3002 7.80406 14.2799 7.94625C14.2109 8.40125 14.3002 8.85625 14.5237 9.22187C14.7755 9.63218 15.198 9.9125 15.653 9.97343C15.9455 10.0141 16.2299 9.96937 16.4818 9.92468C16.7662 9.87593 17.0099 9.83531 17.1765 9.93281C17.2659 9.98156 17.3552 10.0953 17.4487 10.2172C17.4812 10.2619 17.5137 10.3025 17.5543 10.3512C17.5584 10.3553 17.5665 10.3634 17.5705 10.3716C17.408 10.855 17.1684 11.3141 16.8637 11.7203Z" fill="white"/>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Branch') }}</h5>
                                <p class="text-muted mb-0">{{ $data['branch'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            @if($data['department']!='All')
                <div class="col mb-4">
                    <div class="card report-card mb-0 h-100 py-2">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_4436_1963)">
                                    <path d="M4.85177 18.8417C2.16578 18.8417 0 21.0075 0 23.6935C0 24.0438 0.0424662 24.373 0.100857 24.7074C1.44385 25.4081 3.07349 25.8221 4.84646 25.8221C6.61942 25.8221 8.25437 25.4081 9.59206 24.7074C9.65576 24.3783 9.69292 24.0492 9.69292 23.6935C9.72477 21.0287 7.53245 18.8417 4.85177 18.8417Z" fill="white"/>
                                    <path d="M4.85156 17.7217C6.26463 17.7217 7.41015 16.5762 7.41015 15.1631C7.41015 13.75 6.26463 12.6045 4.85156 12.6045C3.43849 12.6045 2.29297 13.75 2.29297 15.1631C2.29297 16.5762 3.43849 17.7217 4.85156 17.7217Z" fill="white"/>
                                    <path d="M21.1589 18.8417C18.4729 18.8417 16.3071 21.0075 16.3071 23.6935C16.3071 24.0438 16.3496 24.373 16.408 24.7074C17.751 25.4081 19.3806 25.8221 21.1536 25.8221C22.9266 25.8221 24.5615 25.4081 25.8992 24.7074C25.9629 24.3783 26 24.0492 26 23.6935C26.0107 21.0287 23.8449 18.8417 21.1589 18.8417Z" fill="white"/>
                                    <path d="M21.1587 17.7217C22.5718 17.7217 23.7173 16.5762 23.7173 15.1631C23.7173 13.75 22.5718 12.6045 21.1587 12.6045C19.7456 12.6045 18.6001 13.75 18.6001 15.1631C18.6001 16.5762 19.7456 17.7217 21.1587 17.7217Z" fill="white"/>
                                    <path d="M13.0055 13.4114C14.7785 13.4114 16.4134 12.9973 17.7511 12.2966C17.8148 11.9675 17.852 11.6384 17.852 11.2827C17.852 8.59675 15.6862 6.43098 13.0002 6.43098C10.3142 6.43098 8.14844 8.59675 8.14844 11.2827C8.14844 11.6331 8.1909 11.9622 8.24929 12.2966C9.5976 12.9973 11.2325 13.4114 13.0055 13.4114Z" fill="white"/>
                                    <path d="M13.0054 5.29501C14.4184 5.29501 15.564 4.14949 15.564 2.73642C15.564 1.32335 14.4184 0.177826 13.0054 0.177826C11.5923 0.177826 10.4468 1.32335 10.4468 2.73642C10.4468 4.14949 11.5923 5.29501 13.0054 5.29501Z" fill="white"/>
                                    <path d="M13.7061 17.5412V14.5845C13.7061 14.2925 13.4673 14.043 13.17 14.0484C12.8887 14.059 12.671 14.2819 12.671 14.5633V17.5359L10.2982 19.8875C10.0965 20.0892 10.0912 20.413 10.2876 20.62C10.4946 20.8323 10.845 20.827 11.052 20.6147L13.1647 18.502L15.3092 20.6253C15.5163 20.827 15.8454 20.827 16.0524 20.6253C16.2594 20.4183 16.2594 20.0839 16.0524 19.8822L13.7061 17.5412Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_4436_1963">
                                    <rect width="26" height="26" fill="white"/>
                                    </clipPath>
                                    </defs>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Department') }}</h5>
                                <p class="text-muted mb-0">{{ $data['department'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            <div class="col mb-4">
                <div class="card report-card mb-0 h-100 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.6667 5.22996V2.94866C22.3111 2.57293 22.75 1.8819 22.75 1.08332V0.541684C22.75 0.242277 22.5077 0 22.2083 0H3.79168C3.49228 0 3.25 0.242277 3.25 0.541684V1.08337C3.25 1.8819 3.68885 2.57293 4.33332 2.94871V5.22996C4.33332 7.37653 5.24845 9.43104 6.84384 10.8667L9.21416 13L6.84384 15.1333C5.24845 16.569 4.33332 18.6235 4.33332 20.77V23.0513C3.68885 23.4271 3.25 24.1181 3.25 24.9167V25.4584C3.25 25.7577 3.49228 26 3.79168 26H22.2084C22.5078 26 22.7501 25.7577 22.7501 25.4583V24.9166C22.7501 24.1181 22.3112 23.4271 21.6667 23.0513V20.77C21.6667 18.6235 20.7516 16.569 19.1562 15.1333L16.7858 13L19.1562 10.8667C20.7516 9.43104 21.6667 7.37648 21.6667 5.22996ZM17.7068 9.25646L14.442 12.1949C14.2135 12.4002 14.0833 12.6927 14.0833 13C14.0833 13.3073 14.2135 13.5999 14.442 13.8051L17.7068 16.7435C18.8462 17.7692 19.5 19.2371 19.5 20.77V22.75H18.1456L13.4332 16.4669C13.229 16.1939 12.7709 16.1939 12.5667 16.4669L7.85444 22.75H6.5V20.77C6.5 19.2371 7.15381 17.7692 8.29324 16.7435L11.5581 13.805C11.7866 13.5998 11.9167 13.3073 11.9167 12.9999C11.9167 12.6926 11.7866 12.4001 11.5581 12.1949L8.29324 9.25641C7.15381 8.23078 6.5 6.76289 6.5 5.22996V3.25H19.5V5.22996C19.5 6.76289 18.8462 8.23078 17.7068 9.25646Z" fill="white"/>
                                <path d="M16.7337 7.58331H9.26621C9.05197 7.58331 8.85783 7.70976 8.77109 7.90547C8.68436 8.10174 8.72082 8.33026 8.86524 8.48895L12.6368 11.9685C12.74 12.0622 12.8701 12.1087 13.0002 12.1087C13.1303 12.1087 13.2605 12.0621 13.3636 11.9685L17.1346 8.48895C17.279 8.33026 17.3155 8.10174 17.2288 7.90547C17.1421 7.70976 16.9479 7.58331 16.7337 7.58331Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Duration') }}</h5>
                            <p class="text-muted mb-0">{{ $data['curMonth'] }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-4 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.436 7.82758H12.5466V8.9377H11.436V7.82758Z" fill="white"/>
                                <path d="M11.436 15.2506H12.5466V16.3607H11.436V15.2506Z" fill="white"/>
                                <path d="M11.436 11.5389H12.5466V12.649H11.436V11.5389Z" fill="white"/>
                                <path d="M7.75439 7.82758H8.86491V8.9377H7.75439V7.82758Z" fill="white"/>
                                <path d="M4.07275 15.2506H5.18327V16.3607H4.07275V15.2506Z" fill="white"/>
                                <path d="M7.75439 15.2506H8.86491V16.3607H7.75439V15.2506Z" fill="white"/>
                                <path d="M4.07275 11.5389H5.18327V12.649H4.07275V11.5389Z" fill="white"/>
                                <path d="M7.75439 11.5389H8.86491V12.649H7.75439V11.5389Z" fill="white"/>
                                <path d="M4.07275 7.82758H5.18327V8.9377H4.07275V7.82758Z" fill="white"/>
                                <path d="M19.5603 13.1335V14.4139H20.1708C20.3748 14.4139 20.5409 14.2479 20.5409 14.0439V10.299C20.5409 10.095 20.3748 9.92889 20.1708 9.92889H16.4257C16.2217 9.92889 16.0557 10.095 16.0557 10.299V14.0439C16.0557 14.2479 16.2217 14.4139 16.4257 14.4139H17.0426V13.1847C17.0426 12.8173 17.1966 12.4622 17.4653 12.2105C17.7186 11.9727 18.0397 11.8537 18.3803 11.8753C18.6027 11.8863 18.8208 11.9611 19.01 12.0895C19.0735 12.1325 19.1337 12.1813 19.1896 12.2358C19.4318 12.4892 19.5603 12.8047 19.5603 13.1335Z" fill="white"/>
                                <path d="M17.0425 16.0819V15.1541H16.4256C15.8134 15.1541 15.3154 14.6561 15.3154 14.0439V10.299C15.3154 9.68677 15.8134 9.18877 16.4256 9.18877H20.1707C20.7829 9.18877 21.2809 9.68677 21.2809 10.299V14.0439C21.2809 14.6561 20.7829 15.1541 20.1707 15.1541H19.5602V16.7489C19.6282 16.718 19.7002 16.6963 19.7737 16.679C19.8053 16.6711 19.8376 16.6661 19.8701 16.6606C19.9039 16.6555 19.9378 16.652 19.972 16.6496C20.0077 16.6465 20.0418 16.6381 20.0782 16.6381C20.2777 16.6381 20.4669 16.6894 20.639 16.7768C20.6532 16.7837 20.6666 16.7918 20.6805 16.7993C20.7218 16.8223 20.763 16.845 20.8017 16.8728C20.8591 16.913 20.9138 16.9572 20.9636 17.0078C21.1914 16.7789 21.5062 16.6372 21.8534 16.6372C21.8801 16.6372 21.9056 16.6432 21.932 16.6449C21.9841 16.648 22.0362 16.6506 22.0867 16.6599C22.119 16.6659 22.1494 16.6769 22.1809 16.6854C22.2253 16.6972 22.2697 16.7086 22.3122 16.7252C22.3427 16.7371 22.3712 16.7527 22.4005 16.767C22.4416 16.7869 22.4822 16.8072 22.5208 16.8317C22.5482 16.849 22.5738 16.8688 22.5999 16.8883C22.6225 16.9052 22.6471 16.919 22.6687 16.9375V2.63856C22.6687 2.02636 22.1707 1.52837 21.5585 1.52837H2.96273C2.35054 1.52837 1.85254 2.02636 1.85254 2.63856V17.1932C1.85254 17.8054 2.35054 18.3034 2.96273 18.3034H15.2663V17.9695C15.2663 16.9654 16.053 16.1414 17.0425 16.0819ZM15.6871 3.08831H20.9108C21.1152 3.08831 21.2809 3.25401 21.2809 3.45837C21.2809 3.66274 21.1152 3.82844 20.9108 3.82844H15.6871C15.4828 3.82844 15.3171 3.66274 15.3171 3.45837C15.3171 3.25401 15.4828 3.08831 15.6871 3.08831ZM15.6871 5.08789H20.9108C21.1152 5.08789 21.2809 5.25358 21.2809 5.45795C21.2809 5.66232 21.1152 5.82801 20.9108 5.82801H15.6871C15.4828 5.82801 15.3171 5.66232 15.3171 5.45795C15.3171 5.25358 15.4828 5.08789 15.6871 5.08789ZM15.6871 7.08746H20.9108C21.1152 7.08746 21.2809 7.25316 21.2809 7.45753C21.2809 7.66189 21.1152 7.82759 20.9108 7.82759H15.6871C15.4828 7.82759 15.3171 7.66189 15.3171 7.45753C15.3171 7.25316 15.4828 7.08746 15.6871 7.08746ZM5.92325 16.3606C5.92325 16.7688 5.59131 17.1007 5.18312 17.1007H4.07292C3.66473 17.1007 3.3328 16.7688 3.3328 16.3606V15.2504C3.3328 14.8422 3.66473 14.5103 4.07292 14.5103H5.18312C5.59131 14.5103 5.92325 14.8422 5.92325 15.2504V16.3606ZM5.92325 12.6491C5.92325 13.0573 5.59131 13.3892 5.18312 13.3892H4.07292C3.66473 13.3892 3.3328 13.0573 3.3328 12.6491V11.5389C3.3328 11.1307 3.66473 10.7988 4.07292 10.7988H5.18312C5.59131 10.7988 5.92325 11.1307 5.92325 11.5389V12.6491ZM5.92325 8.93778C5.92325 9.34597 5.59131 9.67791 5.18312 9.67791H4.07292C3.66473 9.67791 3.3328 9.34597 3.3328 8.93778V7.82759C3.3328 7.4194 3.66473 7.08746 4.07292 7.08746H5.18312C5.59131 7.08746 5.92325 7.4194 5.92325 7.82759V8.93778ZM9.60473 16.3606C9.60473 16.7688 9.2728 17.1007 8.86461 17.1007H7.75441C7.34622 17.1007 7.01429 16.7688 7.01429 16.3606V15.2504C7.01429 14.8422 7.34622 14.5103 7.75441 14.5103H8.86461C9.2728 14.5103 9.60473 14.8422 9.60473 15.2504V16.3606ZM9.60473 12.6491C9.60473 13.0573 9.2728 13.3892 8.86461 13.3892H7.75441C7.34622 13.3892 7.01429 13.0573 7.01429 12.6491V11.5389C7.01429 11.1307 7.34622 10.7988 7.75441 10.7988H8.86461C9.2728 10.7988 9.60473 11.1307 9.60473 11.5389V12.6491ZM9.60473 8.93778C9.60473 9.34597 9.2728 9.67791 8.86461 9.67791H7.75441C7.34622 9.67791 7.01429 9.34597 7.01429 8.93778V7.82759C7.01429 7.4194 7.34622 7.08746 7.75441 7.08746H8.86461C9.2728 7.08746 9.60473 7.4194 9.60473 7.82759V8.93778ZM13.286 16.3606C13.286 16.7688 12.9541 17.1007 12.5459 17.1007H11.4357C11.0275 17.1007 10.6956 16.7688 10.6956 16.3606V15.2504C10.6956 14.8422 11.0275 14.5103 11.4357 14.5103H12.5459C12.9541 14.5103 13.286 14.8422 13.286 15.2504V16.3606ZM13.286 12.6491C13.286 13.0573 12.9541 13.3892 12.5459 13.3892H11.4357C11.0275 13.3892 10.6956 13.0573 10.6956 12.6491V11.5389C10.6956 11.1307 11.0275 10.7988 11.4357 10.7988H12.5459C12.9541 10.7988 13.286 11.1307 13.286 11.5389V12.6491ZM13.286 8.93778C13.286 9.34597 12.9541 9.67791 12.5459 9.67791H11.4357C11.0275 9.67791 10.6956 9.34597 10.6956 8.93778V7.82759C10.6956 7.4194 11.0275 7.08746 11.4357 7.08746H12.5459C12.9541 7.08746 13.286 7.4194 13.286 7.82759V8.93778ZM13.286 4.85623C13.286 5.46843 12.788 5.96643 12.1758 5.96643H4.44299C3.83079 5.96643 3.3328 5.46843 3.3328 4.85623V3.84163C3.3328 3.22943 3.83079 2.73144 4.44299 2.73144H12.1758C12.788 2.73144 13.286 3.22943 13.286 3.84163V4.85623Z" fill="white"/>
                                <path d="M23.2895 17.5078C23.2879 17.5092 23.2869 17.5109 23.2853 17.5123C23.2842 17.5133 23.2839 17.5148 23.2828 17.5158C23.1763 17.6092 23.1127 17.7528 23.1127 17.9001C23.1127 17.902 23.1117 17.9036 23.1117 17.9055V19.0575C23.1117 19.2618 22.946 19.4275 22.7416 19.4275C22.5372 19.4275 22.3715 19.2618 22.3715 19.0575V17.8992C22.3715 17.7597 22.3179 17.6293 22.2209 17.5319C22.1729 17.4829 22.1173 17.4456 22.0569 17.4198C22.0557 17.4193 22.0549 17.4182 22.0538 17.4177C21.9917 17.3917 21.9244 17.3783 21.8546 17.3783C21.5689 17.3783 21.3363 17.6124 21.3363 17.9001C21.3363 17.9049 21.3338 17.9088 21.3336 17.9135V19.0566C21.3336 19.2609 21.1679 19.4266 20.9635 19.4266C20.7592 19.4266 20.5935 19.2609 20.5935 19.0566V17.8985C20.5935 17.8972 20.5942 17.8961 20.5942 17.8948C20.593 17.7593 20.5391 17.6305 20.4409 17.5319C20.3427 17.4318 20.2151 17.3783 20.0781 17.3783C19.7925 17.3783 19.5601 17.6124 19.5601 17.9001C19.5601 17.9039 19.558 17.9071 19.5579 17.9108V19.0566C19.5579 19.2609 19.3922 19.4266 19.1879 19.4266C18.9835 19.4266 18.8178 19.2609 18.8178 19.0566L18.8189 13.1328C18.8189 12.9951 18.7632 12.8612 18.6624 12.7559C18.6438 12.7379 18.6174 12.7178 18.5876 12.6981C18.5261 12.6577 18.4435 12.6203 18.3388 12.6149C18.336 12.6148 18.3334 12.6154 18.3307 12.6153C18.2679 12.6127 18.2069 12.6219 18.1492 12.6423C18.1445 12.644 18.1399 12.6458 18.1353 12.6476C18.0803 12.6691 18.0293 12.7017 17.9827 12.7433C17.9794 12.7462 17.9757 12.7482 17.9725 12.7512C17.8525 12.8636 17.7838 13.0219 17.7838 13.1854L17.7826 19.9864C17.7826 20.1908 17.6169 20.3565 17.4125 20.3565C17.2082 20.3565 17.0425 20.1908 17.0425 19.9864V16.827C16.4623 16.8855 16.0074 17.3749 16.0074 17.9704V18.6735C16.0074 18.6754 16.0064 18.677 16.0063 18.6789V20.4009C16.0063 21.4869 16.4294 22.51 17.1975 23.2816C17.968 24.0486 18.9911 24.4716 20.0771 24.4716C22.3217 24.4716 24.1478 22.6455 24.1478 20.4009V17.8992C24.1478 17.7617 24.0932 17.6301 23.994 17.5286C23.8057 17.3405 23.4781 17.3327 23.2895 17.5078Z" fill="white"/>
                                <path d="M12.1757 3.47157H4.44282C4.23881 3.47157 4.07275 3.63762 4.07275 3.84163V4.85623C4.07275 5.06024 4.23881 5.2263 4.44282 5.2263H12.1757C12.3797 5.2263 12.5457 5.06024 12.5457 4.85623V3.84163C12.5457 3.63762 12.3797 3.47157 12.1757 3.47157Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info w-100 flex-1">
                            <h5 class="mb-1">{{ __('Attendance') }}</h5>
                            <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                <p class="text-muted mb-0">{{__('Total present')}}: 24</p>
                                <p class="text-muted mb-0">{{__('Total leave')}} : 20</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-4 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2088)">
                                <path d="M5.87602 14.768C2.91202 14.768 0.52002 17.16 0.52002 20.124C0.52002 23.088 2.91202 25.48 5.87602 25.48C8.84002 25.48 11.232 23.088 11.232 20.124C11.232 17.16 8.84002 14.768 5.87602 14.768ZM6.08402 19.76C6.34402 19.864 7.48802 20.176 7.48802 21.268C7.48802 21.632 7.33202 22.412 6.24002 22.516V23.14H5.72002V22.516C5.30402 22.464 4.94002 22.308 4.68002 22.048C4.42002 21.788 4.31602 21.424 4.31602 21.008H5.25202C5.25202 21.684 5.72002 21.788 5.92802 21.788C6.13602 21.788 6.55202 21.684 6.55202 21.216C6.55202 20.748 6.13602 20.592 5.92802 20.54C5.72002 20.436 4.52402 20.176 4.52402 19.032C4.52402 18.668 4.68002 17.888 5.77202 17.732V17.056H6.29202V17.732C6.65602 17.784 7.48802 17.992 7.48802 19.188H6.55202C6.60402 18.564 6.13602 18.408 5.98002 18.408C5.51202 18.408 5.40802 18.772 5.40802 18.98C5.40802 19.448 5.82402 19.656 6.08402 19.76Z" fill="white"/>
                                <path d="M21.8399 4.16C16.9519 -0.676003 9.0479 -0.676003 4.15991 4.16C0.935906 7.384 -0.156094 11.96 0.883906 16.068C2.07991 14.612 3.84791 13.676 5.87591 13.676C9.41191 13.676 12.2719 16.536 12.2719 20.072C12.2719 22.1 11.3359 23.868 9.87991 25.064C13.9879 26.104 18.5639 25.012 21.7879 21.788C26.6759 16.952 26.6759 9.048 21.8399 4.16ZM3.32791 13.364H2.02791V12.636H3.32791V13.364ZM4.47191 8.476L3.32791 7.8L3.69191 7.176L4.83591 7.852L4.47191 8.476ZM7.85191 4.836L7.22791 3.692L7.85191 3.328L8.52791 4.472L7.85191 4.836ZM22.3079 7.176L22.6719 7.8L21.5799 8.476L21.2159 7.852L22.3079 7.176ZM18.1479 3.328L18.8239 3.692L18.1479 4.836L17.5239 4.472L18.1479 3.328ZM12.6359 2.028H13.3639V3.328H12.6359V2.028ZM11.9599 5.72C11.9599 5.148 12.4279 4.68 12.9999 4.68C13.5719 4.68 14.0399 5.148 14.0399 5.72V10.088C13.7279 9.984 13.3639 9.932 12.9999 9.932C12.6359 9.932 12.2719 9.984 11.9599 10.088V5.72ZM13.3639 23.92H12.6359V22.62H13.3639V23.92ZM12.9999 15.028C11.8559 15.028 10.9719 14.092 10.9719 13C10.9719 11.856 11.9079 10.972 12.9999 10.972C14.1439 10.972 15.0279 11.908 15.0279 13C15.0279 14.144 14.1439 15.028 12.9999 15.028ZM18.1479 22.672L17.5239 21.58L18.1479 21.216L18.8239 22.36L18.1479 22.672ZM15.9119 14.04C16.0159 13.728 16.0679 13.364 16.0679 13C16.0679 12.636 16.0159 12.272 15.9119 11.96H20.7479C21.0079 11.96 21.2679 12.064 21.4759 12.272C21.6839 12.428 21.7879 12.688 21.7879 13C21.7879 13.572 21.3199 14.04 20.7479 14.04H15.9119ZM22.3079 18.772L21.1639 18.096L21.5279 17.472L22.6199 18.148L22.3079 18.772ZM22.6719 13.364V12.636H23.9719V13.364H22.6719Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2088">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Overtime') }}</h5>
                            <p class="text-muted mb-0">{{__('Total overtime in hours')}} : {{number_format(25.55,2)}}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-4 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2121)">
                                <path d="M25.4455 15.0303H24.5587C24.5587 14.6039 24.5587 14.3238 24.5587 13.9067C24.5587 13.6239 24.3294 13.3946 24.0465 13.3946H23.7437C23.7797 12.9519 23.4941 12.5344 23.0494 12.4201C22.696 12.3293 20.4671 11.7564 20.1234 11.6681L21.0659 9.19953C21.3388 8.48473 20.981 7.68361 20.2656 7.41046L18.1079 6.57561C17.6944 6.4156 17.2501 6.37472 16.814 6.45475C15.1019 6.76884 12.2879 7.28513 11.9628 7.34454C11.7479 7.38385 11.5537 7.4976 11.4143 7.66584L9.49887 9.97755V3.01483C9.49887 2.74275 9.31936 2.50336 9.05819 2.42714L4.9378 1.22464H15.621V5.74544L16.8454 5.58548V0.612421C16.8454 0.27432 16.5713 0.000202459 16.2332 0.000202459C16.1464 0.000202459 0.651915 -0.00116863 0.604587 0.00274152C0.2804 0.0294525 0.0424896 0.301945 0.0424896 0.612421C0.0424896 0.762632 0.0395951 22.9963 0.0477709 23.0615C0.0788998 23.3089 0.25572 23.5061 0.48322 23.5726L8.71522 25.975C9.1074 26.0896 9.49892 25.7942 9.49892 25.3873V12.708C9.64081 12.6525 9.77147 12.5626 9.87552 12.4369L12.63 9.11239C12.9654 9.0511 15.3224 8.61996 15.7012 8.5507L13.6312 13.9722C13.6312 13.9722 13.705 13.7857 12.3255 18.5079L10.7201 21.5595V24.4507C11.1926 24.5659 11.6987 24.3503 11.9342 23.9025L14.2924 19.4199C14.3261 19.3559 14.3532 19.2887 14.3735 19.2194L15.678 14.7538C15.7729 14.79 15.7262 14.7722 15.972 14.866C16.3005 15.3819 17.9174 17.9214 18.2445 18.4352L16.6109 23.0362C16.4109 23.5997 16.7054 24.2187 17.269 24.4188C17.8294 24.6178 18.4511 24.3253 18.6515 23.7607L20.4619 18.6618C20.5708 18.3551 20.5383 18.0058 20.3549 17.718L18.7662 15.2227C18.9977 14.6164 19.2234 14.0253 19.456 13.416C20.3381 13.6428 20.9189 13.7921 20.9189 13.7921L20.9055 15.0304H20.0188C19.9035 15.0304 19.7976 15.069 19.7121 15.1331L21.0686 17.2636C21.3899 17.7683 21.4594 18.381 21.2593 18.9448L21.0339 19.5795H25.4456C25.7284 19.5795 25.9576 19.3502 25.9576 19.0674V15.5425C25.9576 15.2596 25.7283 15.0303 25.4455 15.0303ZM7.75398 16.0961C7.75398 16.4342 7.47986 16.7084 7.14176 16.7084C6.80366 16.7084 6.52954 16.4342 6.52954 16.0961V12.562C6.52954 12.2239 6.80366 11.9497 7.14176 11.9497C7.47986 11.9497 7.75398 12.2239 7.75398 12.562V16.0961ZM23.5345 15.0303H23.5345H21.9298V14.4189H23.5345V15.0303Z" fill="white"/>
                                <path d="M16.0368 16.5429L15.621 17.9662V22.3728H13.6949L13.0508 23.5973H15.712C15.6826 23.3153 15.7161 23.0282 15.8138 22.7531L16.8456 19.8473V17.813L16.0368 16.5429Z" fill="white"/>
                                <path d="M21.1713 2.57126C20.1128 2.16709 18.927 2.69755 18.5229 3.75609C18.1151 4.82376 18.66 6.00453 19.7077 6.40453C20.7566 6.80509 21.949 6.28611 22.3561 5.2197C22.7603 4.16117 22.2298 2.97543 21.1713 2.57126Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2121">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Early leave') }}</h5>
                            <p class="text-muted mb-0">{{__('Total early leave in hours')}} : {{number_format(10.50,2)}}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-4 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.8026 21.0359C10.7728 21.0297 10.7436 21.0486 10.7373 21.0784C10.7102 21.2063 10.7265 21.3153 10.7858 21.4022C10.8774 21.5364 11.0378 21.5645 11.0446 21.5656C11.0477 21.5661 11.0507 21.5663 11.0537 21.5663C11.0801 21.5663 11.1032 21.5473 11.1079 21.5205C11.1129 21.4906 11.0928 21.4621 11.0629 21.4569C11.0617 21.4567 10.9407 21.4346 10.8763 21.3392C10.835 21.2782 10.8246 21.1982 10.8451 21.1012C10.8515 21.0715 10.8324 21.0423 10.8026 21.0359Z" fill="white"/>
                                <path d="M10.5605 21.0122C10.531 21.0049 10.501 21.0227 10.4936 21.0522C10.4459 21.2411 10.4631 21.4038 10.5445 21.5357C10.6683 21.7366 10.8955 21.789 10.9051 21.7911C10.9091 21.792 10.9131 21.7924 10.917 21.7924C10.9423 21.7924 10.9649 21.775 10.9707 21.7494C10.9774 21.7197 10.9587 21.6903 10.9291 21.6835C10.9272 21.6831 10.7365 21.6381 10.6377 21.4769C10.573 21.3714 10.5605 21.2375 10.6005 21.0791C10.6079 21.0496 10.59 21.0197 10.5605 21.0122Z" fill="white"/>
                                <path d="M14.4889 5.46551C14.3346 5.51632 14.2632 5.66273 14.2603 5.6689C14.2472 5.69629 14.2588 5.72896 14.2861 5.74219C14.2938 5.74588 14.3019 5.7477 14.31 5.7477C14.3304 5.7477 14.3501 5.73624 14.3596 5.71668C14.3602 5.71557 14.4149 5.60548 14.5243 5.56999C14.5943 5.54729 14.6741 5.5593 14.7617 5.60592C14.7886 5.62019 14.8219 5.60999 14.8362 5.58316C14.8505 5.55627 14.8403 5.52293 14.8134 5.5086C14.6981 5.44716 14.5889 5.43261 14.4889 5.46551Z" fill="white"/>
                                <path d="M14.1038 5.54673C14.1122 5.55131 14.1213 5.55351 14.1302 5.55351C14.1497 5.55351 14.1685 5.54321 14.1786 5.52497C14.1795 5.52326 14.2756 5.35249 14.4578 5.30224C14.5769 5.26923 14.7091 5.2943 14.8504 5.37663C14.8767 5.392 14.9104 5.38307 14.9257 5.35679C14.941 5.3305 14.9322 5.29678 14.9059 5.28146C14.7376 5.18337 14.5766 5.15472 14.4272 5.19643C14.1999 5.2598 14.0866 5.46358 14.0819 5.47218C14.0674 5.49874 14.0772 5.53208 14.1038 5.54673Z" fill="white"/>
                                <path d="M25.7973 22.6669L25.9998 22.3571L25.3517 21.9335V20.9653V9.80664V4.06646L25.9998 3.64293L25.7973 3.33308L22.1052 5.7461L21.8146 5.93599L21.8346 5.96652H14.6357V11.2878C14.7344 11.279 14.8433 11.2731 14.9605 11.2731C15.2196 11.2731 15.4729 11.3012 15.7134 11.3566C16.5151 11.5412 17.575 12.1139 18.071 13.7934C18.1743 14.1431 17.9738 14.5116 17.6241 14.6149C17.563 14.633 17.5 14.6421 17.4367 14.6421H17.4366C17.1458 14.6421 16.8851 14.4472 16.8027 14.168C16.673 13.729 16.487 13.3801 16.247 13.124C16.5124 13.7512 16.6433 14.3588 16.717 15.2088L16.7177 15.2172L16.7178 15.2256C16.7238 15.7996 16.5136 16.2103 16.0932 16.4466L16.0733 16.4633L15.8005 18.0319L17.6023 18.5431C18.0846 18.6799 18.3658 19.1836 18.2289 19.6659C18.1185 20.0552 17.759 20.3271 17.3546 20.3271C17.2708 20.3271 17.1871 20.3154 17.106 20.2924L14.6358 19.5917V20.6072H22.1296V12.3745H19.4358V12.2289H22.1296V6.17228L22.35 6.02824L24.9817 4.30837V9.80669V19.4132V20.9654V22.1208V22.134L25.7973 22.6669ZM21.7978 12.6657V12.8114H18.8906V12.6657H21.7978ZM21.1921 11.9376H18.285V11.7919H21.1921V11.9376Z" fill="white"/>
                                <path d="M4.62151 14.0743H4.61732C4.45338 14.0723 4.3359 14.0284 4.23837 13.9871C4.14227 13.9447 4.06143 13.8989 3.99018 13.8584L3.96136 13.8419C3.82712 13.7654 3.68859 13.6861 3.53667 13.6265C3.4717 13.6009 3.41467 13.564 3.36579 13.5196C3.34138 13.5184 3.31685 13.5167 3.29255 13.5167C3.27751 13.5168 3.26307 13.5175 3.24842 13.5179C3.29586 13.553 3.32705 13.609 3.32705 13.6726C3.32705 13.7791 3.2407 13.8654 3.13418 13.8654C3.02761 13.8654 2.94132 13.7791 2.94132 13.6726C2.94132 13.625 2.95917 13.582 2.98772 13.5484C2.72911 13.6023 2.52429 13.7182 2.31103 13.8392C2.26265 13.8667 2.21438 13.894 2.16583 13.9205L2.12395 13.9415C2.01286 13.9977 1.87439 14.0674 1.6532 14.0739H1.65138H1.64515C1.64471 14.0739 1.64427 14.0739 1.64383 14.0739V15.2144L1.17368 20.9781C1.14309 21.3532 1.42242 21.6819 1.79735 21.7125C2.17234 21.743 2.5012 21.4639 2.53178 21.0888L2.94115 16.0698H3.32699L3.73637 21.0888C3.76695 21.464 4.09581 21.743 4.4708 21.7125C4.84578 21.6819 5.12505 21.3532 5.09447 20.9781L4.62443 15.2148V14.0742C4.62371 14.0742 4.62294 14.0743 4.62223 14.0743H4.62151V14.0743ZM3.32699 14.5129C3.32699 14.6195 3.24065 14.7058 3.13413 14.7058C3.02756 14.7058 2.94126 14.6195 2.94126 14.5129C2.94126 14.4064 3.02756 14.3201 3.13413 14.3201C3.24065 14.3201 3.32699 14.4064 3.32699 14.5129ZM3.13413 15.5462C3.02756 15.5462 2.94126 15.4598 2.94126 15.3533C2.94126 15.2467 3.02756 15.1604 3.13413 15.1604C3.24065 15.1604 3.32699 15.2467 3.32699 15.3533C3.32699 15.4598 3.24065 15.5462 3.13413 15.5462Z" fill="white"/>
                                <path d="M3.96353 11.9249C3.96353 12.1039 3.91151 12.2863 3.83359 12.4593C3.92364 12.4957 4.00089 12.5543 4.06002 12.6276C4.20125 12.6899 4.32507 12.7562 4.43831 12.82C4.4565 12.8304 4.47391 12.8404 4.49083 12.8501L4.60203 12.9197C4.59371 12.9576 4.58197 12.9913 4.56852 13.0179C4.56648 13.0219 4.56456 13.0257 4.56252 13.0294C4.51408 13.003 4.45082 12.9669 4.3788 12.9257C4.3135 12.8889 4.23949 12.8482 4.15744 12.8072C4.18356 12.8874 4.19255 12.9745 4.17916 13.0634C4.13909 13.3294 3.91124 13.531 3.64453 13.5411C3.78907 13.6039 3.92044 13.6791 4.04977 13.753C4.12444 13.7953 4.19872 13.8373 4.28545 13.8755C4.37219 13.9122 4.47468 13.9514 4.6185 13.9531H4.62208C4.70733 13.9531 4.80674 13.9334 4.89557 13.8882C5.11296 13.7784 5.26537 13.5989 5.35911 13.4083C5.45339 13.216 5.4961 13.0079 5.49654 12.7975C5.49566 12.4877 5.40269 12.1631 5.17858 11.8956C4.97079 11.6434 4.63311 11.469 4.24704 11.4523C4.23106 11.4505 4.21486 11.4493 4.19839 11.4493H4.19536H3.8979C3.94017 11.5867 3.96353 11.7455 3.96353 11.9249Z" fill="white"/>
                                <path d="M3.13397 11.4481H2.92452L2.81982 11.8614L2.83591 11.8867C2.92215 11.9585 3.02768 11.9945 3.13392 11.9946C3.24016 11.9945 3.34585 11.9585 3.43215 11.8865L3.44807 11.8614L3.34337 11.4481H3.13397Z" fill="white"/>
                                <path d="M3.1344 12.1599H3.13407H3.13396C3.05874 12.16 2.98358 12.146 2.91205 12.1192L2.87012 12.4283C3.00848 12.4054 3.14751 12.3926 3.28803 12.3926C3.32319 12.3926 3.35829 12.3933 3.39333 12.3946L3.35597 12.1192C3.28461 12.1459 3.20951 12.1599 3.1344 12.1599Z" fill="white"/>
                                <path d="M1.37223 13.8881C1.46101 13.9333 1.56025 13.953 1.64495 13.953C1.64643 13.953 1.64798 13.953 1.64952 13.9529C1.86707 13.9465 1.98951 13.8722 2.1076 13.8142C2.44886 13.6284 2.77001 13.3979 3.29246 13.3955C3.37512 13.3955 3.46295 13.4017 3.55768 13.4158C3.79843 13.452 4.02292 13.2862 4.05913 13.0454C4.09528 12.8045 3.92947 12.5802 3.68866 12.544C3.55101 12.5233 3.41887 12.5138 3.29251 12.5138C2.75602 12.5128 2.33397 12.6874 2.03966 12.8432C1.89964 12.917 1.78513 12.9865 1.7054 13.0294C1.70336 13.0258 1.70132 13.0219 1.69928 13.0179C1.68589 12.9913 1.67426 12.9575 1.66594 12.9195L1.7772 12.8498C1.83616 12.8162 1.90636 12.7763 1.98318 12.7359C2.14529 12.6501 2.30609 12.5809 2.46683 12.5275C2.37128 12.3347 2.30449 12.1276 2.30449 11.9249C2.30449 11.7455 2.32786 11.5867 2.37012 11.4492H2.06958C2.05316 11.4492 2.03701 11.4504 2.02109 11.4522C1.63503 11.4691 1.29729 11.6435 1.0896 11.8956C0.865438 12.163 0.772311 12.4879 0.771484 12.7975C0.771925 13.0036 0.813309 13.2078 0.903735 13.3969C0.905554 13.4007 0.907041 13.4045 0.908915 13.4083C1.00237 13.599 1.15512 13.7787 1.37223 13.8881Z" fill="white"/>
                                <path d="M2.59723 11.0487C2.85815 11.1609 3.15858 11.1848 3.45124 11.0947C3.51736 11.0743 3.58046 11.0486 3.64041 11.0188C4.17393 10.753 4.45243 10.1331 4.2713 9.54484C4.06978 8.89042 3.37596 8.52326 2.72149 8.72478C2.06712 8.92629 1.69991 9.62017 1.90142 10.2746C2.01284 10.6364 2.27481 10.9101 2.59723 11.0487ZM3.33871 9.95625C3.33871 9.95625 3.51152 9.88467 3.62355 9.95559C3.73568 10.0264 3.8713 10.1549 4.13563 10.065C4.29902 10.0095 3.90706 10.2897 3.69976 10.203C3.4924 10.1163 3.34136 10.1629 3.34136 10.1629C3.34136 10.1629 3.24972 10.0203 3.33871 9.95625ZM2.53132 10.559C2.8004 10.4846 2.84029 10.3021 2.89314 10.1805C2.94587 10.0589 3.12898 10.0208 3.12898 10.0208C3.23853 10.0238 3.24305 10.1931 3.24305 10.1931C3.24305 10.1931 3.09195 10.2397 2.96929 10.4279C2.84668 10.6162 2.36496 10.6051 2.53132 10.559Z" fill="white"/>
                                <path d="M8.48607 6.90925C9.28614 6.90925 9.9346 6.26072 9.9346 5.46071C9.9346 4.66076 9.28608 4.01224 8.48607 4.01224C7.68612 4.01224 7.0376 4.66076 7.0376 5.46071C7.0376 6.26072 7.68607 6.90925 8.48607 6.90925ZM7.8149 4.37334L7.90957 4.53733L7.9747 4.49975L7.87987 4.33559C8.04992 4.24379 8.24317 4.18973 8.44849 4.18378V4.53744H8.52371V4.18378C8.72903 4.18973 8.92228 4.24379 9.09228 4.33554L8.9975 4.4998L9.06258 4.53738L9.15736 4.37334C9.32631 4.47782 9.46897 4.62054 9.57351 4.78949L9.40951 4.88421L9.4471 4.94934L9.61131 4.85451C9.70311 5.02451 9.75711 5.21776 9.76306 5.42308H9.40946L9.4094 5.49829H9.76312C9.75717 5.70361 9.70311 5.89687 9.61136 6.06692L9.44721 5.97219L9.40962 6.03727L9.57362 6.132C9.46914 6.30095 9.32642 6.44367 9.15747 6.54815L9.06274 6.38415L8.99766 6.42174L9.09244 6.58589C8.92245 6.6777 8.72919 6.7317 8.52388 6.73765V6.38404H8.44866V6.73765C8.24334 6.7317 8.05009 6.67764 7.88003 6.58584L7.97476 6.42174L7.90968 6.38415L7.81501 6.54809C7.64606 6.44361 7.50334 6.30089 7.39886 6.13194L7.5628 6.03727L7.52522 5.97219L7.36112 6.06692C7.26931 5.89692 7.21525 5.70367 7.2093 5.49835H7.56291L7.56285 5.42313H7.2093C7.21525 5.21781 7.26931 5.02456 7.36106 4.85456L7.52516 4.94929L7.56274 4.88416L7.39881 4.78954C7.50323 4.62059 7.64595 4.47787 7.8149 4.37334Z" fill="white"/>
                                <path d="M7.87013 6.16412L7.93549 6.2162L8.48642 5.52414L8.65967 5.59026L8.7005 5.48314L8.56137 5.43002L8.6627 5.30273L8.59729 5.25071L8.47943 5.39878L7.80798 5.14254L7.76709 5.24966L8.40448 5.49289L7.87013 6.16412Z" fill="white"/>
                                <path d="M11.7011 15.1109L11.8166 15.1846L11.6635 15.4246L10.6414 14.7728L10.7944 14.5328L11.0128 14.672C10.9929 14.5744 10.9995 14.4771 11.0281 14.3877L10.7187 14.1904L10.4323 14.6395L9.9483 14.3309L8.75342 16.2049L11.1618 17.7405L12.3566 15.8665L11.8727 15.558L12.159 15.1088L12.0328 15.0283L11.7059 15.11C11.7043 15.1104 11.7027 15.1105 11.7011 15.1109Z" fill="white"/>
                                <path d="M17.1665 20.0804C17.2293 20.0982 17.2926 20.1067 17.3549 20.1067C17.6551 20.1067 17.9311 19.9088 18.0172 19.6057C18.121 19.2397 17.9084 18.8589 17.5425 18.7551L15.5496 18.1897L15.8118 16.6821L14.1755 18.0502L14.086 18.5649C14.0255 18.9123 14.2373 19.2493 14.5766 19.3456L17.1665 20.0804Z" fill="white"/>
                                <path d="M13.427 18.3886L15.9683 16.2638C16.2685 16.1017 16.5036 15.8071 16.4976 15.2278C16.3984 14.0844 16.1968 13.4049 15.6923 12.4983C16.3213 12.7257 16.7659 13.2647 17.0142 14.1056C17.0709 14.2974 17.2465 14.4216 17.4369 14.4216C17.4782 14.4216 17.5203 14.4158 17.5619 14.4035C17.7954 14.3345 17.9288 14.0893 17.8599 13.8558C17.394 12.2783 16.4086 11.7428 15.6641 11.5714C14.8705 11.3886 14.1873 11.5839 14.1585 11.5922C14.1529 11.5938 14.1478 11.596 14.1423 11.5978C14.087 11.6127 14.0343 11.6319 13.9852 11.6554C13.7625 11.7622 13.6354 11.9925 13.5989 12.2595C13.5464 12.4729 13.5178 12.8175 13.5094 13.2009L14.1032 12.265C14.208 12.0999 14.3873 12.0014 14.583 12.0014C14.6905 12.0014 14.7954 12.032 14.8866 12.0898C15.1508 12.2574 15.2294 12.6088 15.0618 12.8731L14.2154 14.2071C14.3848 14.6637 14.5314 15.1518 14.5831 15.6262L12.394 17.4564C12.2963 17.538 12.2232 17.6451 12.1828 17.7658L11.2093 20.668C11.0883 21.0287 11.2826 21.4191 11.6432 21.5401C11.7159 21.5644 11.7898 21.576 11.8625 21.576C12.1503 21.576 12.4188 21.3941 12.5154 21.1061L13.427 18.3886Z" fill="white"/>
                                <path d="M13.5659 14.6453C13.5782 14.7586 13.5923 14.8632 13.608 14.9554C13.7529 15.1469 13.9056 15.3288 14.0648 15.5008C14.0851 15.2691 14.1171 15.0431 14.16 14.8234C14.1182 14.6985 14.08 14.5725 14.0454 14.4456C13.9741 14.5151 13.8859 14.5654 13.7873 14.59L13.5659 14.6453Z" fill="white"/>
                                <path d="M13.7566 14.467C13.8663 14.4396 13.9613 14.3711 14.0219 14.2756L14.9547 12.8053C15.0852 12.5997 15.0243 12.3273 14.8187 12.1969C14.6132 12.0664 14.3407 12.1274 14.2103 12.333L13.3718 13.6544L11.4615 14.1316C11.2253 14.1906 11.0817 14.43 11.1407 14.6661C11.1907 14.8665 11.3705 15.0002 11.5681 15.0002C11.6035 15.0002 11.6394 14.9959 11.6753 14.987L13.7566 14.467Z" fill="white"/>
                                <path d="M14.0963 10.7224C14.1394 10.0391 13.6204 9.45009 12.937 9.40695C12.2537 9.36381 11.6647 9.88283 11.6216 10.5662C11.5784 11.2496 12.0974 11.8386 12.7808 11.8817C13.4642 11.9248 14.0532 11.4058 14.0963 10.7224Z" fill="white"/>
                                <path d="M22.2393 12.3745H22.3501H23.2791V12.2289H22.3501H22.2393V12.3745Z" fill="white"/>
                                <path d="M4.27791 7.90658C4.2838 7.90857 4.2897 7.90983 4.29559 7.9116L3.94882 8.5491L4.01919 8.59225L4.33202 8.08154L4.58748 7.66451L4.46625 7.59778L4.34293 7.82448C4.13006 7.72881 4.02079 7.48531 4.09727 7.25988C4.17541 7.0297 4.4187 6.9028 4.65014 6.96545C4.64815 6.97074 4.64573 6.97581 4.64391 6.98121C4.60594 7.09302 4.60517 7.20846 4.63471 7.31421C4.63206 7.25701 4.63939 7.19838 4.6589 7.1409C4.7426 6.89415 5.01041 6.76206 5.25717 6.84571C5.50382 6.92947 5.63596 7.19733 5.55225 7.44398C5.51252 7.56097 5.43113 7.65178 5.33046 7.70644C5.3914 7.68936 5.44888 7.66175 5.50078 7.62566C5.56333 7.73548 5.58085 7.87027 5.53704 7.99938C5.45582 8.23886 5.19578 8.36714 4.9563 8.28587C4.87309 8.25765 4.80371 8.20751 4.75147 8.14447L4.94214 7.96505L4.8468 7.8647L4.51811 8.20745L4.09375 8.65L4.15348 8.70719L4.65041 8.23958C4.71841 8.33485 4.81534 8.41079 4.93464 8.45129C5.23711 8.55389 5.56559 8.39194 5.66825 8.08942C5.732 7.90157 5.69354 7.70374 5.58284 7.55617C5.63976 7.49776 5.68527 7.42657 5.71321 7.34419C5.81339 7.04888 5.6553 6.72823 5.36005 6.62805C5.09852 6.53927 4.81754 6.65334 4.68695 6.88555C4.66915 6.87728 4.6508 6.86979 4.63179 6.86334C4.34365 6.76559 4.03093 6.91983 3.93306 7.20797C3.83553 7.496 3.98982 7.80883 4.27791 7.90658Z" fill="white"/>
                                <path d="M0.547132 8.67127C0.651666 8.36885 0.408489 8.04291 0.398075 8.02919L0.319661 8.08859C0.321865 8.09151 0.541677 8.38583 0.454171 8.63914C0.402097 8.78985 0.249293 8.89946 0 8.96492L0.0249623 9.06008C0.307979 8.98575 0.483652 8.85493 0.547132 8.67127Z" fill="white"/>
                                <path d="M0.921011 8.56888C0.99193 8.60856 1.07123 8.62839 1.15862 8.62839C1.28277 8.62839 1.42312 8.58839 1.57835 8.50849L1.53328 8.42104C1.30007 8.54105 1.11035 8.56194 0.969337 8.48325C0.731341 8.35034 0.699491 7.97243 0.69916 7.96863L0.601074 7.97607C0.602452 7.99365 0.636892 8.40985 0.921011 8.56888Z" fill="white"/>
                                <path d="M1.06576 9.06224C0.946236 9.36575 1.21459 9.72674 1.22611 9.74195L1.30464 9.68271C1.30216 9.67941 1.05788 9.35016 1.1574 9.098C1.21388 8.95484 1.37357 8.85923 1.6319 8.81377L1.61487 8.7169C1.32034 8.76875 1.13557 8.88491 1.06576 9.06224Z" fill="white"/>
                                <path d="M0.664521 9.25763C0.902683 9.38575 0.924945 9.79705 0.92511 9.80124L1.02342 9.79666C1.02253 9.77754 0.998564 9.32591 0.711415 9.17117C0.541528 9.07953 0.320669 9.11315 0.0551758 9.27091L0.105431 9.3555C0.339019 9.21663 0.527035 9.18368 0.664521 9.25763Z" fill="white"/>
                                <path d="M9.95014 9.20138C9.88159 9.59884 10.3398 9.32277 11.0211 9.42262C10.8214 8.97038 10.0229 8.77905 9.95014 9.20138Z" fill="white"/>
                                <path d="M11.5734 9.28689C11.7244 8.92546 11.3989 8.3623 11.1165 8.55075C10.8507 8.72808 11.2592 8.84082 11.5734 9.28689Z" fill="white"/>
                                <path d="M10.3335 10.1266C10.3379 10.406 10.6143 10.1593 11.091 10.1399C10.8971 9.85756 10.3289 9.82979 10.3335 10.1266Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Employee late') }}</h5>
                            <p class="text-muted mb-0">{{__('Total late in hours')}} : {{number_format(7.30,2)}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-body table-border-style">
                        <div class="table-responsive py-4 attendance-table-responsive">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th class="active">{{__('Name')}}</th>
                                    @foreach($dates as $date)
                                        <th>{{$date}}</th>
                                    @endforeach
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($employeesAttendance as $attendance)

                                    <tr>
                                        <td>{{$attendance['name']}}</td>
                                        @foreach($attendance['status'] as $status)
                                            <td>
                                                @if($status=='P')
{{--                                                    <i class="custom-badge badge-success ap">{{__('P')}}</i>--}}
                                                    <i class="badge bg-success p-2 ">{{__('P')}}</i>
                                                @elseif($status=='A')
                                                    <i class="badge bg-danger p-2 ">{{__('A')}}</i>
                                                @endif
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
