@extends('layouts.admin')
@section('page-title')
    {{ __('Transaction Summary') }}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Report') }}</li>
    <li class="breadcrumb-item">{{ __('Transaction Summary') }}</li>
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('css/datatable/buttons.dataTables.min.css') }}">
@endpush

@push('script-page')
    {{--    <script src="{{ asset('assets/js/plugins/simple-datatables.js') }}"></script> --}}
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script src="{{ asset('js/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('js/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('js/datatable/vfs_fonts.js') }}"></script>
    {{--    <script src="{{ asset('js/datatable/dataTables.buttons.min.js') }}"></script> --}}
    {{--    <script src="{{ asset('js/datatable/buttons.html5.min.js') }}"></script> --}}
    {{--    <script type="text/javascript" src="{{ asset('js/datatable/buttons.print.min.js') }}"></script> --}}

    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {
                    type: 'jpeg',
                    quality: 1
                },
                html2canvas: {
                    scale: 4,
                    dpi: 72,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(element).save();

        }
    </script>
@endpush

@section('action-btn')
    <div class="float-end d-flex">
        {{--        <a class="btn btn-sm btn-primary" data-bs-toggle="collapse" href="#multiCollapseExample1" role="button" aria-expanded="false" aria-controls="multiCollapseExample1" data-bs-toggle="tooltip" title="{{__('Filter')}}"> --}}
        {{--            <i class="ti ti-filter"></i> --}}
        {{--        </a> --}}

        <a href="{{ route('transaction.export') }}" data-bs-toggle="tooltip" title="{{ __('Export') }}"
            class="btn btn-sm btn-secondary me-2">
            <i class="ti ti-file-export"></i>
        </a>

        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip"
            title="{{ __('Download') }}" data-original-title="{{ __('Download') }}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>

    </div>
@endsection


@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        {{ Form::open(['route' => ['transaction.index'], 'method' => 'get', 'id' => 'transaction_report']) }}
                        <div class="row align-items-center justify-content-end">
                            <div class="col-xl-10">
                                <div class="row">

                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('start_month', __('Start Month'), ['class' => 'form-label']) }}
                                            {{ Form::month('start_month', isset($_GET['start_month']) ? $_GET['start_month'] : date('Y-m', strtotime('-5 month')), ['class' => 'month-btn form-control']) }}
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('end_month', __('End Month'), ['class' => 'form-label']) }}
                                            {{ Form::month('end_month', isset($_GET['end_month']) ? $_GET['end_month'] : date('Y-m'), ['class' => 'month-btn form-control']) }}
                                        </div>
                                    </div>

                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('account', __('Account'), ['class' => 'form-label']) }}
                                            {{ Form::select('account', $account, isset($_GET['account']) ? $_GET['account'] : '', ['class' => 'form-control select']) }}
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                                        <div class="btn-box">
                                            {{ Form::label('category', __('Category'), ['class' => 'form-label']) }}
                                            {{ Form::select('category', $category, isset($_GET['category']) ? $_GET['category'] : '', ['class' => 'form-control select']) }}
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-auto mt-4">
                                <div class="row">
                                    <div class="col-auto">
                                        <a href="#" class="btn btn-sm btn-primary me-1"
                                            onclick="document.getElementById('transaction_report').submit(); return false;"
                                            data-bs-toggle="tooltip" title="{{ __('Apply') }}"
                                            data-original-title="{{ __('apply') }}">
                                            <span class="btn-inner--icon"><i class="ti ti-search"></i></span></a>

                                        <a href="{{ route('transaction.index') }}" class="btn btn-sm btn-danger "
                                            data-bs-toggle="tooltip" title="{{ __('Reset') }}"
                                            data-original-title="{{ __('Reset') }}">
                                            <span class="btn-inner--icon"><i
                                                    class="ti ti-refresh text-white-off "></i></span>
                                        </a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>

    <div id="printableArea">
        <div class="row">
            <div class="col mb-4">
                <input type="hidden"
                    value="{{ $filter['category'] . ' ' . __('Category') . ' ' . __('Transaction') . ' ' . 'Report of' . ' ' . $filter['startDateRange'] . ' to ' . $filter['endDateRange'] }}"
                    id="filename">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3.09766 0.761719V20.668C3.09766 21.089 3.43835 21.4297 3.85938 21.4297H17.5703C17.9913 21.4297 18.332 21.089 18.332 20.668V0.761719C18.332 0.340691 17.9913 0 17.5703 0H3.85938C3.43835 0 3.09766 0.340691 3.09766 0.761719ZM15.2852 17.5703H12.2383C11.8173 17.5703 11.4766 17.2296 11.4766 16.8086C11.4766 16.3876 11.8173 16.0469 12.2383 16.0469H15.2852C15.7062 16.0469 16.0469 16.3876 16.0469 16.8086C16.0469 17.2296 15.7062 17.5703 15.2852 17.5703ZM6.14453 3.85938H10.7148C11.1359 3.85938 11.4766 4.20007 11.4766 4.62109C11.4766 5.04212 11.1359 5.38281 10.7148 5.38281H6.14453C5.7235 5.38281 5.38281 5.04212 5.38281 4.62109C5.38281 4.20007 5.7235 3.85938 6.14453 3.85938ZM6.14453 6.90625H15.2852C15.7062 6.90625 16.0469 7.24694 16.0469 7.66797C16.0469 8.089 15.7062 8.42969 15.2852 8.42969H6.14453C5.7235 8.42969 5.38281 8.089 5.38281 7.66797C5.38281 7.24694 5.7235 6.90625 6.14453 6.90625ZM6.14453 9.95312H15.2852C15.7062 9.95312 16.0469 10.2938 16.0469 10.7148C16.0469 11.1359 15.7062 11.4766 15.2852 11.4766H6.14453C5.7235 11.4766 5.38281 11.1359 5.38281 10.7148C5.38281 10.2938 5.7235 9.95312 6.14453 9.95312ZM6.14453 13H15.2852C15.7062 13 16.0469 13.3407 16.0469 13.7617C16.0469 14.1827 15.7062 14.5234 15.2852 14.5234H6.14453C5.7235 14.5234 5.38281 14.1827 5.38281 13.7617C5.38281 13.3407 5.7235 13 6.14453 13Z"
                                    fill="white" />
                                <path
                                    d="M8.42969 26H22.1406C22.5617 26 22.9023 25.6593 22.9023 25.2383V5.38281C22.9023 4.96179 22.5617 4.62109 22.1406 4.62109H19.8555V20.668C19.8555 21.9281 18.8304 22.9531 17.5703 22.9531H7.66797V25.2383C7.66797 25.6593 8.00866 26 8.42969 26Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Report') }} :</h5>
                            <p class="text-muted mb-0">{{ __('Transaction Summary') }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            @if ($filter['account'] != __('All'))
                <div class="col mb-4">
                    <div class="card report-card h-100 mb-0 py-2">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_4436_2343)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M21.4309 11.997C22.9026 13.6279 23.9999 15.0429 24.7225 16.3117C27.3688 20.9582 23.6042 25.6775 18.5625 25.5926C13.5208 25.6775 9.75614 20.9582 12.4025 16.3117C13.1251 15.0429 14.2224 13.6279 15.6941 11.997C15.8698 12.0526 16.0566 12.0827 16.2503 12.0827H20.8746C21.0683 12.0827 21.2552 12.0526 21.4309 11.997ZM2.71507 0.406311C1.44518 0.406311 0.40625 1.4453 0.40625 2.71513V19.5937C0.40625 20.8636 1.44518 21.9025 2.71507 21.9025H11.2173C10.3863 19.9169 10.6377 17.7686 11.6965 15.9096C11.9128 15.5298 12.15 15.1535 12.403 14.7817C12.2567 14.687 12.1595 14.5224 12.1595 14.3358V13.6457C12.1595 13.3534 12.3979 13.115 12.6902 13.115H13.6529C14.0832 12.5861 14.5309 12.0713 14.9789 11.5743C14.8466 11.4488 14.7329 11.304 14.6421 11.1445H12.6902C12.3979 11.1445 12.1595 10.9061 12.1595 10.6137V9.92368C12.1595 9.63133 12.3979 9.39292 12.6902 9.39292H14.6042C14.7691 9.07172 15.0254 8.80462 15.3383 8.62617L14.7867 8.07463C14.451 7.73892 14.2695 7.30601 14.242 6.86513H3.48466C3.19231 6.86513 2.95389 6.62671 2.95389 6.33436V4.25106C2.95389 3.95871 3.19231 3.7203 3.48466 3.7203H15.1617C15.454 3.7203 15.6924 3.95871 15.6924 4.25106V4.91899C16.067 4.83307 16.4654 4.86165 16.8295 5.011C17.0757 4.42174 17.6097 3.99355 18.2401 3.8832V2.71513C18.2401 1.4453 17.2011 0.406311 15.9313 0.406311H2.71507ZM16.2504 11.2702C15.6802 11.2702 15.2138 10.8038 15.2138 10.2337C15.2138 9.66363 15.6802 9.19721 16.2504 9.19721H20.8747C21.4448 9.19721 21.9112 9.66363 21.9112 10.2338C21.9112 10.8038 21.4448 11.2702 20.8747 11.2702H16.2504ZM3.97231 9.39292H5.95608C6.24843 9.39292 6.48685 9.63133 6.48685 9.92368V10.6137C6.48685 10.906 6.24843 11.1445 5.95608 11.1445H3.97231C3.67997 11.1445 3.44155 10.906 3.44155 10.6137V9.92368C3.44155 9.63133 3.67997 9.39292 3.97231 9.39292ZM8.33127 16.837C8.03893 16.837 7.80051 17.0754 7.80051 17.3678V18.0578C7.80051 18.3501 8.03893 18.5885 8.33127 18.5885H10.315C10.6074 18.5885 10.8458 18.3501 10.8458 18.0578V17.3678C10.8458 17.0754 10.6074 16.837 10.315 16.837H8.33127ZM3.97231 16.837H5.95608C6.24843 16.837 6.48685 17.0754 6.48685 17.3678V18.0578C6.48685 18.3501 6.24843 18.5885 5.95608 18.5885H3.97231C3.67997 18.5885 3.44155 18.3501 3.44155 18.0578V17.3678C3.44155 17.0754 3.67997 16.837 3.97231 16.837ZM8.33127 13.1149C8.03893 13.1149 7.80051 13.3533 7.80051 13.6457V14.3357C7.80051 14.6281 8.03893 14.8665 8.33127 14.8665H10.315C10.6074 14.8665 10.8458 14.6281 10.8458 14.3357V13.6457C10.8458 13.3533 10.6074 13.1149 10.315 13.1149H8.33127ZM3.97231 13.1149H5.95608C6.24843 13.1149 6.48685 13.3533 6.48685 13.6457V14.3357C6.48685 14.6281 6.24843 14.8665 5.95608 14.8665H3.97231C3.67997 14.8665 3.44155 14.6281 3.44155 14.3357V13.6457C3.44155 13.3534 3.67997 13.1149 3.97231 13.1149ZM8.33127 9.39292H10.315C10.6074 9.39292 10.8458 9.63133 10.8458 9.92368V10.6137C10.8458 10.906 10.6074 11.1445 10.315 11.1445H8.33127C8.03893 11.1445 7.80051 10.906 7.80051 10.6137V9.92368C7.80051 9.63133 8.03893 9.39292 8.33127 9.39292ZM18.5093 20.7181C18.1978 20.71 17.8954 20.6256 17.6544 20.4651C17.4362 20.3198 17.2695 20.1073 17.1999 19.8281C17.1379 19.576 16.8833 19.422 16.6313 19.484C16.3793 19.546 16.2252 19.8005 16.2872 20.0526C16.4187 20.5799 16.7296 20.9787 17.1355 21.249C17.4127 21.4336 17.7346 21.5556 18.0718 21.6151V21.9808C18.0718 22.2409 18.2827 22.4519 18.5429 22.4519C18.803 22.4519 19.0139 22.241 19.0139 21.9808V21.6241C19.4236 21.5616 19.841 21.4121 20.1688 21.1635C20.5626 20.8646 20.8246 20.4367 20.811 19.8624C20.8094 19.7966 20.8056 19.7388 20.7996 19.6894C20.7233 19.0601 20.3828 18.6505 19.9314 18.3779C19.5349 18.1385 19.0594 18.0193 18.6234 17.9477C18.309 17.8961 17.9778 17.8087 17.7353 17.6504C17.5473 17.5277 17.4125 17.3501 17.3999 17.0904C17.3862 16.8094 17.5089 16.5826 17.7022 16.4255C17.8537 16.3024 18.0468 16.2168 18.2563 16.1747C18.3405 16.1577 18.4272 16.1479 18.5148 16.1456C18.5241 16.1462 18.5334 16.1465 18.5428 16.1465C18.5541 16.1465 18.5654 16.1461 18.5765 16.1452C18.6923 16.1469 18.809 16.1618 18.9229 16.1906C19.2731 16.2794 19.5919 16.5102 19.7598 16.9101C19.8604 17.15 20.1364 17.2628 20.3762 17.1622C20.6161 17.0616 20.7289 16.7855 20.6283 16.5458C20.3327 15.8416 19.7698 15.4348 19.151 15.278C19.1056 15.2664 19.0599 15.2563 19.0139 15.2476V14.8826C19.0139 14.6225 18.803 14.4115 18.5429 14.4115C18.2827 14.4115 18.0718 14.6225 18.0718 14.8826V15.2547C17.7148 15.3267 17.3797 15.4773 17.1097 15.6968C16.6948 16.0341 16.4317 16.5239 16.4614 17.1346C16.4912 17.7482 16.7974 18.1598 17.2237 18.4381C17.5953 18.6807 18.0517 18.8062 18.4725 18.8752C18.8105 18.9308 19.1714 19.0185 19.4456 19.184C19.6649 19.3164 19.8297 19.5099 19.8649 19.7999C19.8695 19.8385 19.8721 19.8666 19.8725 19.8845C19.878 20.1151 19.7677 20.2907 19.602 20.4164C19.3947 20.5737 19.1035 20.6665 18.8123 20.7018C18.7331 20.7114 18.6638 20.7169 18.6051 20.7183L18.5826 20.7187C18.5695 20.7176 18.5562 20.717 18.5428 20.717C18.5316 20.7169 18.5204 20.7173 18.5093 20.7181ZM16.2459 8.38476L15.3613 7.5001C14.947 7.08582 14.947 6.40794 15.3613 5.99372C15.7136 5.64135 16.2714 5.58183 16.6906 5.85092C16.8464 5.95086 17.0252 5.96681 17.1961 5.89607C17.367 5.82528 17.4822 5.68761 17.5216 5.50678C17.626 5.02862 18.0541 4.66772 18.5625 4.66762C19.0616 4.66762 19.497 5.01948 19.6034 5.50678C19.6428 5.68761 19.758 5.82528 19.9289 5.89607C20.0999 5.96691 20.2787 5.95086 20.4343 5.85092C20.8462 5.58656 21.4042 5.63424 21.7637 5.99362V5.99372C22.1779 6.40799 22.1779 7.08587 21.7637 7.5001L20.879 8.38476L20.8746 8.38471H16.2503L16.2459 8.38476Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_4436_2343">
                                    <rect width="26" height="26" fill="white"/>
                                    </clipPath>
                                    </defs>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Account') }} :</h5>
                                <p class="text-muted mb-0">{{ $filter['account'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            @if ($filter['category'] != __('All'))
                <div class="col mb-4">
                    <div class="card report-card h-100 mb-0 py-2">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.9609 2.53288L19.9842 2.55619L20.4437 3.01581L20.4671 3.03912C20.8763 3.44829 21.2178 3.78981 21.474 4.09163C21.7413 4.4064 21.9631 4.73103 22.0898 5.12103C22.2842 5.71937 22.2842 6.3639 22.0898 6.96225C21.9631 7.35224 21.7413 7.67686 21.474 7.99164C21.2178 8.29345 20.8763 8.63498 20.4671 9.04416L20.4437 9.06746L19.9842 9.52708L19.9609 9.55039C19.5518 9.95961 19.2101 10.3011 18.9083 10.5573C18.5935 10.8246 18.269 11.0463 17.879 11.1731C17.2806 11.3675 16.636 11.3675 16.0377 11.1731C15.6477 11.0463 15.3232 10.8246 15.0083 10.5573C14.7065 10.3011 14.3649 9.95953 13.9558 9.55039L13.9325 9.52708L13.4729 9.06746L13.4495 9.04416C13.0403 8.63498 12.6989 8.29345 12.4427 7.99164C12.1754 7.67686 11.9536 7.35224 11.8269 6.96225C11.6325 6.3639 11.6325 5.71937 11.8269 5.12103C11.9536 4.73103 12.1754 4.4064 12.4427 4.09163C12.6989 3.78981 13.0403 3.44829 13.4495 3.03912L13.4729 3.01581L13.9325 2.55619L13.9558 2.53288C14.3649 2.12368 14.7065 1.78215 15.0083 1.52593C15.3232 1.25869 15.6477 1.0369 16.0377 0.910185C16.636 0.71577 17.2806 0.71577 17.879 0.910185C18.269 1.0369 18.5935 1.25869 18.9083 1.52593C19.2101 1.78215 19.5517 2.12368 19.9609 2.53288ZM4.6837 1.43742H4.71667H5.36667H5.39964C5.97831 1.43741 6.46131 1.4374 6.85589 1.46964C7.26744 1.50327 7.65381 1.57597 8.01919 1.76213C8.57975 2.04776 9.03548 2.50351 9.32116 3.06408C9.50728 3.42944 9.57997 3.81583 9.61366 4.22736C9.64583 4.62195 9.64583 5.10493 9.64583 5.68358V5.71659V6.36659V6.39955C9.64583 6.97821 9.64583 7.46124 9.61366 7.85581C9.57997 8.26736 9.50728 8.65373 9.32116 9.01911C9.03548 9.57967 8.57975 10.0355 8.01919 10.321C7.65381 10.5073 7.26744 10.58 6.85589 10.6135C6.46131 10.6458 5.97831 10.6458 5.39963 10.6457H5.36667H4.71667H4.6837C4.10504 10.6458 3.62203 10.6458 3.22744 10.6135C2.8159 10.58 2.42952 10.5073 2.06416 10.321C1.50359 10.0355 1.04784 9.57967 0.762208 9.01911C0.576048 8.65373 0.503346 8.26736 0.469719 7.85581C0.437479 7.46124 0.43749 6.97825 0.4375 6.3996V6.36659V5.71659V5.68362C0.43749 5.10498 0.437479 4.62195 0.469719 4.22736C0.503346 3.81583 0.576048 3.42944 0.762208 3.06408C1.04784 2.50351 1.50359 2.04776 2.06416 1.76213C2.42952 1.57597 2.8159 1.50327 3.22744 1.46964C3.62202 1.4374 4.10503 1.43741 4.6837 1.43742ZM4.71667 13.354H4.6837C4.10503 13.354 3.62202 13.354 3.22744 13.3863C2.8159 13.4199 2.42952 13.4926 2.06416 13.6788C1.50359 13.9644 1.04784 14.4202 0.762208 14.9808C0.576048 15.3461 0.503346 15.7325 0.469719 16.1441C0.437479 16.5386 0.43749 17.0216 0.4375 17.6003V17.6332V18.2832V18.3163C0.43749 18.8949 0.437479 19.3779 0.469719 19.7725C0.503346 20.184 0.576048 20.5705 0.762208 20.9358C1.04784 21.4964 1.50359 21.9521 2.06416 22.2377C2.42952 22.4239 2.8159 22.4966 3.22744 22.5302C3.62201 22.5625 4.10498 22.5625 4.68361 22.5624H4.71667H5.36667H5.39963C5.97826 22.5625 6.46133 22.5625 6.85589 22.5302C7.26744 22.4966 7.65381 22.4239 8.01919 22.2377C8.57975 21.9521 9.03548 21.4964 9.32116 20.9358C9.50728 20.5705 9.57997 20.184 9.61366 19.7725C9.64583 19.3779 9.64583 18.8949 9.64583 18.3163V18.2832V17.6332V17.6003C9.64583 17.0216 9.64583 16.5386 9.61366 16.1441C9.57997 15.7325 9.50728 15.3461 9.32116 14.9808C9.03548 14.4202 8.57975 13.9644 8.01919 13.6788C7.65381 13.4926 7.26744 13.4199 6.85589 13.3863C6.46131 13.354 5.97831 13.354 5.39964 13.354H5.36667H4.71667ZM16.6004 13.354H16.6333H17.2833H17.3163C17.895 13.354 18.3779 13.354 18.7726 13.3863C19.1842 13.4199 19.5705 13.4926 19.9359 13.6788C20.4964 13.9644 20.9522 14.4202 21.2378 14.9808C21.4239 15.3461 21.4966 15.7325 21.5303 16.1441C21.5625 16.5386 21.5625 17.0217 21.5625 17.6003V17.6332V18.2832V18.3163C21.5625 18.8949 21.5625 19.3779 21.5303 19.7725C21.4966 20.184 21.4239 20.5705 21.2378 20.9358C20.9522 21.4964 20.4964 21.9521 19.9359 22.2377C19.5705 22.4239 19.1842 22.4966 18.7726 22.5302C18.378 22.5625 17.895 22.5625 17.3164 22.5624H17.2833H16.6333H16.6004C16.0218 22.5625 15.5386 22.5625 15.1441 22.5302C14.7325 22.4966 14.3462 22.4239 13.9808 22.2377C13.4203 21.9521 12.9645 21.4964 12.6788 20.9358C12.4927 20.5705 12.42 20.184 12.3863 19.7725C12.3542 19.3779 12.3542 18.8949 12.3542 18.3163V18.2832V17.6332V17.6003C12.3542 17.0217 12.3542 16.5386 12.3863 16.1441C12.42 15.7325 12.4927 15.3461 12.6788 14.9808C12.9645 14.4202 13.4203 13.9644 13.9808 13.6788C14.3462 13.4926 14.7325 13.4199 15.1441 13.3863C15.5387 13.354 16.0217 13.354 16.6004 13.354Z" fill="white"/>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Category') }} :</h5>
                                <p class="text-muted mb-0">{{ $filter['category'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            <div class="col mb-4">
                <div class="card report-card h-100 mb-0 py-2">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.6667 5.22996V2.94866C22.3111 2.57293 22.75 1.8819 22.75 1.08332V0.541684C22.75 0.242277 22.5077 0 22.2083 0H3.79168C3.49228 0 3.25 0.242277 3.25 0.541684V1.08337C3.25 1.8819 3.68885 2.57293 4.33332 2.94871V5.22996C4.33332 7.37653 5.24845 9.43104 6.84384 10.8667L9.21416 13L6.84384 15.1333C5.24845 16.569 4.33332 18.6235 4.33332 20.77V23.0513C3.68885 23.4271 3.25 24.1181 3.25 24.9167V25.4584C3.25 25.7577 3.49228 26 3.79168 26H22.2084C22.5078 26 22.7501 25.7577 22.7501 25.4583V24.9166C22.7501 24.1181 22.3112 23.4271 21.6667 23.0513V20.77C21.6667 18.6235 20.7516 16.569 19.1562 15.1333L16.7858 13L19.1562 10.8667C20.7516 9.43104 21.6667 7.37648 21.6667 5.22996ZM17.7068 9.25646L14.442 12.1949C14.2135 12.4002 14.0833 12.6927 14.0833 13C14.0833 13.3073 14.2135 13.5999 14.442 13.8051L17.7068 16.7435C18.8462 17.7692 19.5 19.2371 19.5 20.77V22.75H18.1456L13.4332 16.4669C13.229 16.1939 12.7709 16.1939 12.5667 16.4669L7.85444 22.75H6.5V20.77C6.5 19.2371 7.15381 17.7692 8.29324 16.7435L11.5581 13.805C11.7866 13.5998 11.9167 13.3073 11.9167 12.9999C11.9167 12.6926 11.7866 12.4001 11.5581 12.1949L8.29324 9.25641C7.15381 8.23078 6.5 6.76289 6.5 5.22996V3.25H19.5V5.22996C19.5 6.76289 18.8462 8.23078 17.7068 9.25646Z" fill="white"/>
                                <path d="M16.7337 7.58331H9.26621C9.05197 7.58331 8.85783 7.70976 8.77109 7.90547C8.68436 8.10174 8.72082 8.33026 8.86524 8.48895L12.6368 11.9685C12.74 12.0622 12.8701 12.1087 13.0002 12.1087C13.1303 12.1087 13.2605 12.0621 13.3636 11.9685L17.1346 8.48895C17.279 8.33026 17.3155 8.10174 17.2288 7.90547C17.1421 7.70976 16.9479 7.58331 16.7337 7.58331Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Duration') }} :</h5>
                            <p class="text-muted mb-0">{{ $filter['startDateRange'] . ' to ' . $filter['endDateRange'] }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            @foreach ($accounts as $account)
                <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                    <div class="card report-card h-100 mb-0 py-2">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4.79273 13.8399V17.0051H2.87676V13.8399H4.79273ZM7.41711 13.8399V17.0051H9.33309V13.8399H7.41711ZM11.9585 13.8399V17.0051H13.8745V13.8399H11.9585ZM15.3745 11.8965H1.37719V12.4709C1.37719 12.7628 1.61637 13.002 1.90988 13.002H14.8418C15.1338 13.002 15.3745 12.7628 15.3745 12.4709V11.8965ZM1.37719 18.3757V18.9485H15.3745V18.3757C15.3745 18.0822 15.1343 17.843 14.8418 17.843H1.90937C1.61586 17.843 1.37719 18.0822 1.37719 18.3757ZM16.4425 11.0602H0.30875V9.4118L8.36977 4.13512L16.4425 9.4123V11.0602ZM9.48137 7.68168C9.48137 7.06977 8.98168 6.57059 8.37027 6.57059C7.75887 6.57059 7.25918 7.07027 7.25918 7.68168C7.25918 8.29512 7.75887 8.7943 8.37027 8.7943C8.98168 8.7943 9.48137 8.29512 9.48137 7.68168ZM15.6853 19.7849H1.0659C0.493086 19.7849 0.0253906 20.2526 0.0253906 20.8254V21.8649H16.7248V20.8254C16.7248 20.2526 16.2566 19.7849 15.6853 19.7849ZM21.3784 8.72676C23.0654 8.72676 24.443 10.1029 24.443 11.7914C24.443 13.4799 23.0654 14.8561 21.3784 14.8561C19.6899 14.8561 18.3122 13.4799 18.3122 11.7914C18.3122 10.1029 19.6899 8.72676 21.3784 8.72676ZM21.3784 9.56617C21.1468 9.56617 20.9595 9.75355 20.9595 9.98359V10.2065C20.8355 10.2598 20.7233 10.336 20.6299 10.4295C20.4415 10.6179 20.3232 10.8799 20.3232 11.1663C20.3232 11.4542 20.441 11.7147 20.6299 11.9031C20.7883 12.0616 20.997 12.1692 21.2301 12.1997C21.2591 12.2068 21.2875 12.2098 21.3164 12.2098H21.3667H21.3886C21.4449 12.2098 21.4967 12.2327 21.5338 12.2703C21.5714 12.3079 21.5942 12.3596 21.5942 12.4155C21.5942 12.4714 21.5714 12.5221 21.5338 12.5592C21.4962 12.5968 21.4444 12.6212 21.3886 12.6212H21.2448C21.2103 12.6212 21.1788 12.6125 21.1529 12.5993C21.1225 12.5851 21.0981 12.5618 21.0783 12.5359C20.9417 12.35 20.6796 12.3114 20.4953 12.4495C20.3095 12.5861 20.2709 12.8482 20.4075 13.0325C20.5039 13.1635 20.6304 13.2702 20.7777 13.3448C20.835 13.3737 20.897 13.3981 20.9605 13.4169V13.5967C20.9605 13.8282 21.1473 14.0156 21.3794 14.0156C21.61 14.0156 21.7968 13.8282 21.7968 13.5967V13.3737C21.9207 13.322 22.033 13.2458 22.1264 13.1508C22.3148 12.9624 22.4331 12.7019 22.4331 12.4155C22.4331 12.1276 22.3153 11.8671 22.1264 11.6787C21.968 11.5202 21.7593 11.4126 21.5262 11.3806C21.4987 11.375 21.4698 11.372 21.4398 11.372H21.3896H21.3677C21.3114 11.372 21.2596 11.3491 21.2225 11.3115C21.1849 11.2739 21.1621 11.2221 21.1621 11.1663C21.1621 11.1104 21.1849 11.0596 21.2225 11.0211C21.2601 10.9835 21.3119 10.9606 21.3677 10.9606H21.5114C21.546 10.9606 21.5775 10.9693 21.6034 10.9825C21.6338 10.9967 21.6597 11.0185 21.678 11.0459C21.8161 11.2303 22.0766 11.2689 22.2625 11.1323C22.4468 10.9957 22.4854 10.7336 22.3488 10.5493C22.2523 10.4183 22.1259 10.3101 21.9802 10.237C21.9212 10.2065 21.8593 10.1837 21.7958 10.1649V9.98359C21.7958 9.75305 21.6089 9.56617 21.3784 9.56617ZM18.4173 8.13262L17.9537 7.66898H21.3784C21.6089 7.66898 21.7958 7.4816 21.7958 7.25004C21.7958 7.01949 21.6084 6.83109 21.3784 6.83109H17.9537L18.4173 6.36898C18.5814 6.20496 18.5814 5.93988 18.4173 5.77586C18.2548 5.61336 17.9898 5.61336 17.8257 5.77586L16.6481 6.955C16.4841 7.1175 16.4841 7.38258 16.6481 7.5466L17.8257 8.72422C17.9898 8.88672 18.2548 8.88672 18.4173 8.72422C18.5814 8.56019 18.5814 8.29512 18.4173 8.13262ZM25.9746 17.6373V19.1603C25.9746 19.3761 25.7974 19.5533 25.5816 19.5533H24.8605V18.5082C24.8605 18.2767 24.6736 18.0893 24.443 18.0893C24.2115 18.0893 24.0241 18.2767 24.0241 18.5082V19.5533H24.0485C24.2658 19.5533 24.443 19.7305 24.443 19.9479V21.4708C24.443 21.6882 24.2658 21.8654 24.0485 21.8654H23.3289V20.8188C23.3289 20.5882 23.1415 20.3998 22.91 20.3998C22.6794 20.3998 22.491 20.5882 22.491 20.8188V21.8654H21.7958V20.8188C21.7958 20.5882 21.6084 20.3998 21.3784 20.3998C21.1468 20.3998 20.9595 20.5882 20.9595 20.8188V21.8654H20.2643V20.8188C20.2643 20.5882 20.0769 20.3998 19.8453 20.3998C19.6137 20.3998 19.4264 20.5882 19.4264 20.8188V21.8654H18.7068C18.4895 21.8654 18.3122 21.6882 18.3122 21.4708V19.9479C18.3122 19.7305 18.4895 19.5533 18.7068 19.5533H20.2384C20.0225 19.5533 19.8453 19.3761 19.8453 19.1603V17.6373C19.8453 17.42 20.0225 17.2428 20.2384 17.2428H20.2643V16.1962C20.2643 15.9656 20.0769 15.7787 19.8453 15.7787C19.6137 15.7787 19.4264 15.9661 19.4264 16.1962V17.2428H18.7068C18.4895 17.2428 18.3122 17.0655 18.3122 16.8497V15.3253C18.3122 15.1095 18.4895 14.9322 18.7068 14.9322H24.0485C24.2658 14.9322 24.443 15.1095 24.443 15.3253V16.8497C24.443 17.0655 24.2658 17.2428 24.0485 17.2428H25.5816C25.7974 17.2428 25.9746 17.42 25.9746 17.6373ZM21.7958 18.5082C21.7958 18.2767 21.6084 18.0893 21.3784 18.0893C21.1468 18.0893 20.9595 18.2767 20.9595 18.5082V19.5533H21.7958V18.5082ZM21.7958 16.1962C21.7958 15.9656 21.6084 15.7787 21.3784 15.7787C21.1468 15.7787 20.9595 15.9661 20.9595 16.1962V17.2428H21.7958V16.1962ZM23.3289 18.5082C23.3289 18.2767 23.1415 18.0893 22.91 18.0893C22.6794 18.0893 22.491 18.2767 22.491 18.5082V19.5533H23.3289V18.5082ZM23.3289 16.1962C23.3289 15.9656 23.1415 15.7787 22.91 15.7787C22.6794 15.7787 22.491 15.9661 22.491 16.1962V17.2428H23.3289V16.1962Z" fill="white"/>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                @if ($account->holder_name == 'Cash')
                                    <h5 class="mb-1">{{ $account->holder_name }}</h5>
                                @elseif(empty($account->holder_name))
                                    <h5 class="mb-1">{{ __('Stripe / Paypal') }}</h5>
                                @else
                                    <h5 class="mb-1">{{ $account->holder_name . ' - ' . $account->bank_name }}</h5>
                                @endif
                                <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($account->total) }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Account') }}</th>
                                    <th>{{ __('Type') }}</th>
                                    <th>{{ __('Category') }}</th>
                                    <th>{{ __('Description') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($transactions as $transaction)
                                    <tr>
                                        <td>{{ \Auth::user()->dateFormat($transaction->date) }}</td>
                                        <td>
                                            @if (!empty($transaction->bankAccount) && $transaction->bankAccount->holder_name == 'Cash')
                                                {{ $transaction->bankAccount->holder_name }}
                                            @else
                                                {{ !empty($transaction->bankAccount) ? $transaction->bankAccount->bank_name . ' ' . $transaction->bankAccount->holder_name : '-' }}
                                            @endif
                                        </td>
                                        <td>{{ $transaction->type }}</td>
                                        <td>{{ $transaction->category }}</td>
                                        <td>{{ !empty($transaction->description) ? $transaction->description : '-' }}</td>
                                        <td>{{ \Auth::user()->priceFormat($transaction->amount) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
