<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-page'); ?>
<style>
    .apexcharts-yaxis
    {
        transform: translate(20px, 0px) !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-page'); ?>
    <script>
        (function() {
            var options = {
                chart: {
                    height: 350,
                    type: 'area',
                    toolbar: {
                        show: false,
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                series: [{
                    name: '<?php echo e(__('Purchase')); ?>',
                    data: <?php echo json_encode($purchasesArray['value']); ?>

                    // data:  [70,270,80,245,115,260,135,280,70,215]

                },
                    {
                        name: '<?php echo e(__('POS')); ?>',
                        data: <?php echo json_encode($posesArray['value']); ?>


                        // data:  [100,300,100,260,140,290,150,300,100,250]

                    },
                ],
                xaxis: {
                    categories: <?php echo json_encode($purchasesArray['label']); ?>,
                    title: {
                        text: '<?php echo e(__('Days')); ?>'
                    }
                },
                colors: ['#ff3a6e', '#6fd943'],

                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                // markers: {
                //     size: 4,
                //     colors: ['#ffa21d', '#FF3A6E'],
                //     opacity: 0.9,
                //     strokeWidth: 2,
                //     hover: {
                //         size: 7,
                //     }
                // },
                yaxis: {
                    title: {
                        text: '<?php echo e(__('Amount')); ?>',
                        offsetX: 30,
                        offsetY: -35,
                    },
                }
            };
            var chart = new ApexCharts(document.querySelector("#traffic-chart"), options);
            chart.render();
        })();

    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('POS')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row gy-4">
        <div class="col-xxl-3 col-md-4 col-sm-6 col-12 pos-dash-card">
            <div class="pos-card-inner card mb-0 d-flex flex-column justify-content-between">
                <div class="pos-info-wrp d-flex align-items-center gap-2 mb-3">
                    <div class="pos-icon">
                        <div class="pos-icon-inner">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_44_104)">
                                <path d="M15.6661 4.60266V6.07452C15.6661 7.23766 14.7198 8.18395 13.5567 8.18395H6.02525C4.86211 8.18395 3.91583 7.23766 3.91583 6.07452V4.60271C2.98993 4.86592 2.30957 5.71864 2.30957 6.72779V21.7906C2.30957 23.0089 3.30072 24 4.51898 24H15.063C16.2813 24 17.2724 23.0089 17.2724 21.7906V6.72774C17.2724 5.71859 16.5921 4.86587 15.6661 4.60266ZM6.77841 20.2343C6.39028 20.2343 6.07527 19.9193 6.07527 19.5311C6.07527 19.143 6.39028 18.828 6.77841 18.828C7.16654 18.828 7.48155 19.143 7.48155 19.5311C7.48155 19.9193 7.16654 20.2343 6.77841 20.2343ZM6.77841 17.2217C6.39028 17.2217 6.07527 16.9067 6.07527 16.5186C6.07527 16.1304 6.39028 15.8154 6.77841 15.8154C7.16654 15.8154 7.48155 16.1304 7.48155 16.5186C7.48155 16.9067 7.16654 17.2217 6.77841 17.2217ZM9.791 20.2343C9.40286 20.2343 9.08785 19.9193 9.08785 19.5311C9.08785 19.143 9.40286 18.828 9.791 18.828C10.1791 18.828 10.4941 19.143 10.4941 19.5311C10.4941 19.9193 10.1791 20.2343 9.791 20.2343ZM9.791 17.2217C9.40286 17.2217 9.08785 16.9067 9.08785 16.5186C9.08785 16.1304 9.40286 15.8154 9.791 15.8154C10.1791 15.8154 10.4941 16.1304 10.4941 16.5186C10.4941 16.9067 10.1791 17.2217 9.791 17.2217ZM12.8035 20.2343C12.4154 20.2343 12.1004 19.9193 12.1004 19.5311C12.1004 19.143 12.4154 18.828 12.8035 18.828C13.1917 18.828 13.5067 19.143 13.5067 19.5311C13.5067 19.9193 13.1917 20.2343 12.8035 20.2343ZM12.8035 17.2217C12.4154 17.2217 12.1004 16.9067 12.1004 16.5186C12.1004 16.1304 12.4154 15.8154 12.8035 15.8154C13.1917 15.8154 13.5067 16.1304 13.5067 16.5186C13.5067 16.9067 13.1917 17.2217 12.8035 17.2217ZM14.2598 13.506C14.2598 13.8943 13.945 14.2092 13.5567 14.2092H6.02525C5.63693 14.2092 5.32211 13.8943 5.32211 13.506V10.4934C5.32211 10.1051 5.63693 9.79025 6.02525 9.79025H13.5567C13.945 9.79025 14.2598 10.1051 14.2598 10.4934V13.506Z" fill="white"/>
                                <path d="M6.72754 11.1965H12.8527V12.8029H6.72754V11.1965Z" fill="white"/>
                                <path d="M18.6779 1.4057C17.4421 1.4057 16.3806 2.15014 15.916 3.21479C17.4989 3.5996 18.6779 5.02819 18.6779 6.72778V13.1874L19.481 12.7859L20.6729 13.3818C20.9429 13.5167 21.2755 13.4666 21.4952 13.2395C21.624 13.1064 21.6904 12.9247 21.6904 12.7394V4.41824C21.6904 2.75447 20.3416 1.4057 18.6779 1.4057Z" fill="white"/>
                                <path d="M6.02443 6.77772H13.5559C13.9442 6.77772 14.259 6.4629 14.259 6.07458V4.41826C14.259 2.1053 16.0454 0.201989 18.3108 0.0148128L9.36796 0C7.10497 0.189661 5.32129 2.09171 5.32129 4.40288V6.0592V6.07458C5.32129 6.4629 5.63611 6.77772 6.02443 6.77772Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_44_104">
                                <rect width="24" height="24" fill="white"/>
                                </clipPath>
                                </defs>
                            </svg>                                
                        </div>
                    </div>
                    <div class="pos-info flex-1">
                        <span class="text-muted d-block mb-1"><?php echo e(__('Total')); ?></span>
                        <h3 class="h6 m-0">
                            <a href="<?php echo e(route('pos.report')); ?>" class="dashboard-link"><?php echo e(__('POS Of This Month')); ?></a>
                        </h3>
                    </div>
                </div>
                <div class="pos-price text-center">
                    <h4><?php echo e($pos_data['monthlyPosAmount']); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-md-4 col-sm-6 col-12 pos-dash-card">
            <div class="pos-card-inner card mb-0 d-flex flex-column justify-content-between">
                <div class="pos-info-wrp d-flex align-items-center gap-2 mb-3">
                    <div class="pos-icon">
                        <div class="pos-icon-inner">
                            <svg width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.66797 3.28424H6.06105V4.69049H1.66797V3.28424Z" fill="white"/>
                                <path d="M1.66797 11.3094H6.06105V12.7157H1.66797V11.3094Z" fill="white"/>
                                <path d="M0 7.29688H6.06094V8.70312H0V7.29688Z" fill="white"/>
                                <path d="M16.0158 0.0154419C11.6131 0.0154419 8.03125 3.5973 8.03125 7.99999C8.03125 12.4027 11.6131 15.9845 16.0158 15.9845C20.4185 15.9845 24.0003 12.4027 24.0003 7.99999C24.0003 3.5973 20.4185 0.0154419 16.0158 0.0154419ZM16.0158 7.29686C17.2273 7.29686 18.2129 8.28246 18.2129 9.49394C18.2129 10.4595 17.5865 11.281 16.7189 11.575V12.7177H15.3127V11.575C14.4451 11.281 13.8187 10.4595 13.8187 9.49394H15.225C15.225 9.93002 15.5797 10.2848 16.0158 10.2848C16.4519 10.2848 16.8066 9.93002 16.8066 9.49394C16.8066 9.05786 16.4519 8.70311 16.0158 8.70311C14.8043 8.70311 13.8187 7.71752 13.8187 6.50604C13.8187 5.54046 14.4451 4.71897 15.3127 4.42502V3.28225H16.7189V4.42502C17.5865 4.71897 18.2129 5.54046 18.2129 6.50604H16.8066C16.8066 6.06996 16.4519 5.71521 16.0158 5.71521C15.5797 5.71521 15.225 6.06996 15.225 6.50604C15.225 6.94211 15.5797 7.29686 16.0158 7.29686Z" fill="white"/>
                            </svg>                                                            
                        </div>
                    </div>
                    <div class="pos-info flex-1">
                        <span class="text-muted d-block mb-1"><?php echo e(__('Total')); ?></span>
                        <h3 class="h6 m-0">
                            <h6 class="m-0"><a href="<?php echo e(route('pos.report')); ?>" class="dashboard-link"><?php echo e(__('POS Amount')); ?></a></h6>
                        </h3>
                    </div>
                </div>
                <div class="pos-price text-center">
                    <h4><?php echo e($pos_data['totalPosAmount']); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-md-4 col-sm-6 col-12 pos-dash-card">
            <div class="pos-card-inner card mb-0 d-flex flex-column justify-content-between">
                <div class="pos-info-wrp d-flex align-items-center gap-2 mb-3">
                    <div class="pos-icon">
                        <div class="pos-icon-inner">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M23.2003 11.2H21.4063L17.5259 5.76759C17.4508 5.66241 17.3295 5.59997 17.2003 5.59997H16.3911C16.3463 4.92998 16.0979 4.28198 15.6771 3.75558L15.2279 3.19439C15.4351 3.17958 15.6004 3.0112 15.6004 2.79998V0.399984C15.6004 0.179203 15.4212 0 15.2004 0H7.60034C7.37956 0 7.20036 0.179203 7.20036 0.399984V2.79998C7.20036 3.02077 7.37956 3.19997 7.60034 3.19997V5.59997H6.80033C6.67114 5.59997 6.54992 5.66236 6.47473 5.76759L2.59438 11.2H0.800375C0.579594 11.2 0.400391 11.3792 0.400391 11.6V14C0.400391 14.2207 0.579594 14.4 0.800375 14.4H1.68795L4.01234 23.6971C4.05673 23.8748 4.21677 24 4.40033 24H19.6003C19.784 24 19.9439 23.8748 19.9883 23.6971L22.3127 14.4H23.2003C23.4211 14.4 23.6003 14.2207 23.6003 14V11.6C23.6004 11.3792 23.4212 11.2 23.2003 11.2ZM8.00038 0.800016H14.8004V2.4H14.4004H8.00038V0.800016ZM7.00634 6.39998H7.60034V8.154C7.60034 8.78161 8.13875 9.29241 8.80034 9.29241C9.00036 9.29241 9.18514 9.23442 9.34714 9.13762C9.54716 9.53123 9.93355 9.84605 10.4003 9.84605C10.6231 9.84605 10.8263 9.80086 10.9995 9.71963C11.1748 10.0908 11.4843 10.4 12.0003 10.4C12.3079 10.4 12.6703 10.312 12.9131 9.96881C13.1051 10.12 13.3403 10.2156 13.6003 10.2156C14.2619 10.2156 14.8003 9.70481 14.8003 9.07683V8.00002H15.1731C15.8499 8.00002 16.4003 7.44961 16.4003 6.77283V6.40003H16.9943L20.4231 11.2H3.57758L7.00634 6.39998ZM8.80034 21.6C8.80034 21.8208 8.62114 22 8.40036 22C8.17958 22 8.00038 21.8208 8.00038 21.6V16C8.00038 15.7792 8.17958 15.6 8.40036 15.6C8.62114 15.6 8.80034 15.7792 8.80034 16V21.6ZM11.2003 21.6C11.2003 21.8208 11.0211 22 10.8004 22C10.5796 22 10.4004 21.8208 10.4004 21.6V16C10.4004 15.7792 10.5796 15.6 10.8004 15.6C11.0211 15.6 11.2003 15.7792 11.2003 16V21.6ZM13.6003 21.6C13.6003 21.8208 13.4211 22 13.2004 22C12.9796 22 12.8004 21.8208 12.8004 21.6V16C12.8004 15.7792 12.9796 15.6 13.2004 15.6C13.4211 15.6 13.6003 15.7792 13.6003 16V21.6ZM16.0003 21.6C16.0003 21.8208 15.8211 22 15.6004 22C15.3796 22 15.2004 21.8208 15.2004 21.6V16C15.2004 15.7792 15.3796 15.6 15.6004 15.6C15.8211 15.6 16.0003 15.7792 16.0003 16V21.6ZM22.8004 13.6H22.0003H2.00038H1.20036V12H22.8004V13.6Z" fill="white"/>
                            </svg>                                                             
                        </div>
                    </div>
                    <div class="pos-info flex-1">
                        <span class="text-muted d-block mb-1"><?php echo e(__('Total')); ?></span>
                        <h3 class="h6 m-0">
                            <a href="<?php echo e(route('purchase.index')); ?>" class="dashboard-link"><?php echo e(__('Purchase Of This Month')); ?></a>
                        </h3>
                    </div>
                </div>
                <div class="pos-price text-center">
                    <h4><?php echo e($pos_data['monthlyPurchaseAmount']); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-md-4 col-sm-6 col-12 pos-dash-card">
            <div class="pos-card-inner card mb-0 d-flex flex-column justify-content-between">
                <div class="pos-info-wrp d-flex align-items-center gap-2 mb-3">
                    <div class="pos-icon">
                        <div class="pos-icon-inner">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_44_140)">
                                <path d="M14 18C14.5523 18 15 17.5523 15 17C15 16.4477 14.5523 16 14 16C13.4477 16 13 16.4477 13 17C13 17.5523 13.4477 18 14 18Z" fill="white"/>
                                <path d="M21.75 13H18.1815L14.85 16.0566C15.273 16.2515 15.6395 16.5356 15.9194 16.8856C16.1993 17.2356 16.3846 17.6416 16.4599 18.07C16.5353 18.4984 16.4986 18.9372 16.353 19.3501C16.2073 19.763 15.9568 20.1383 15.622 20.4452C15.2873 20.7521 14.8778 20.9817 14.4274 21.1152C13.9769 21.2487 13.4983 21.2823 13.0309 21.2133C12.5635 21.1442 12.1207 20.9744 11.7388 20.7178C11.357 20.4613 11.0471 20.1253 10.8345 19.7375L9.402 21.052C8.99101 21.4218 8.49263 21.6999 7.9455 21.8646C7.99465 22.025 7.97761 22.1964 7.89765 22.3461C7.81769 22.4957 7.6804 22.6131 7.512 22.6759C7.32741 22.7437 7.121 22.7415 6.93816 22.6698C6.75533 22.5981 6.61103 22.4628 6.537 22.2936C6.49319 22.1992 6.4431 22.1074 6.387 22.0186C5.52469 21.9487 4.71612 21.6049 4.101 21.0465L3 20.0414V21.9375C3 22.4845 3.23705 23.0091 3.65901 23.3959C4.08097 23.7827 4.65326 24 5.25 24H21.75C22.3467 24 22.919 23.7827 23.341 23.3959C23.7629 23.0091 24 22.4845 24 21.9375V15.0625C24 14.5155 23.7629 13.9909 23.341 13.6041C22.919 13.2173 22.3467 13 21.75 13ZM22.1355 20.7578C21.7586 20.8971 21.4162 21.1047 21.1289 21.3681C20.8415 21.6315 20.615 21.9454 20.463 22.2909C20.3847 22.454 20.2403 22.5829 20.0603 22.6503C19.8802 22.7178 19.6787 22.7185 19.4981 22.6523C19.3176 22.5861 19.1721 22.4583 19.0924 22.2957C19.0127 22.1331 19.005 21.9484 19.071 21.7807C19.2986 21.2625 19.6381 20.7917 20.0691 20.3966C20.5 20.0016 21.0136 19.6904 21.579 19.4818C21.7619 19.4213 21.9633 19.4283 22.1407 19.5014C22.3181 19.5744 22.4576 19.7078 22.5298 19.8733C22.602 20.0388 22.6012 20.2236 22.5276 20.3886C22.4541 20.5536 22.3135 20.6859 22.1355 20.7578ZM22.5525 17.136C22.4785 17.3048 22.3344 17.4399 22.1519 17.5115C21.9694 17.5832 21.7634 17.5856 21.579 17.5182C20.4818 17.1128 19.6011 16.3302 19.125 15.3375C19.0525 15.1716 19.0533 14.9864 19.1273 14.8211C19.2012 14.6558 19.3424 14.5233 19.5211 14.4518C19.6997 14.3803 19.9017 14.3754 20.0842 14.438C20.2668 14.5007 20.4155 14.626 20.499 14.7875C20.8178 15.4488 21.4047 15.9705 22.1355 16.2422C22.3201 16.3101 22.4677 16.4424 22.5459 16.61C22.6241 16.7776 22.6264 16.9668 22.5525 17.136Z" fill="white"/>
                                <path d="M11.5 12.5C12.0523 12.5 12.5 12.0523 12.5 11.5C12.5 10.9477 12.0523 10.5 11.5 10.5C10.9477 10.5 10.5 10.9477 10.5 11.5C10.5 12.0523 10.9477 12.5 11.5 12.5Z" fill="white"/>
                                <path d="M20.3485 5.96402L15.036 0.651545C14.8296 0.444988 14.5845 0.281131 14.3147 0.169336C14.0449 0.0575413 13.7557 0 13.4637 0C13.1717 0 12.8825 0.0575413 12.6128 0.169336C12.343 0.281131 12.0979 0.444988 11.8915 0.651545L0.651545 11.8915C0.444988 12.0979 0.281131 12.343 0.169336 12.6128C0.0575413 12.8825 0 13.1717 0 13.4637C0 13.7557 0.0575413 14.0449 0.169336 14.3147C0.281131 14.5845 0.444988 14.8296 0.651545 15.036L5.96402 20.3485C6.17044 20.555 6.41554 20.7189 6.68532 20.8307C6.95509 20.9425 7.24425 21 7.53627 21C7.8283 21 8.11746 20.9425 8.38723 20.8307C8.657 20.7189 8.90211 20.555 9.10853 20.3485L20.3485 9.10853C20.555 8.90211 20.7189 8.657 20.8307 8.38723C20.9425 8.11746 21 7.8283 21 7.53627C21 7.24425 20.9425 6.95509 20.8307 6.68532C20.7189 6.41554 20.555 6.17044 20.3485 5.96402ZM4.25395 15.1145C4.22022 15.2081 4.16801 15.2939 4.10043 15.3668C4.03284 15.4397 3.95127 15.4983 3.86056 15.5391C3.76986 15.5798 3.67188 15.6019 3.57246 15.604C3.47304 15.6061 3.37423 15.5881 3.28189 15.5512C3.18956 15.5143 3.1056 15.4592 3.03502 15.3891C2.96444 15.3191 2.90868 15.2355 2.87106 15.1435C2.83345 15.0514 2.81475 14.9528 2.81607 14.8533C2.8174 14.7539 2.83873 14.6558 2.87878 14.5647C3.15888 13.8575 3.15888 13.07 2.87878 12.3627C2.83873 12.2717 2.8174 12.1735 2.81607 12.0741C2.81475 11.9747 2.83345 11.876 2.87106 11.784C2.90868 11.6919 2.96444 11.6084 3.03502 11.5383C3.1056 11.4683 3.18956 11.4132 3.28189 11.3762C3.37423 11.3393 3.47304 11.3214 3.57246 11.3235C3.67188 11.3255 3.76986 11.3476 3.86056 11.3884C3.95127 11.4291 4.03284 11.4877 4.10043 11.5606C4.16801 11.6336 4.22022 11.7194 4.25395 11.8129C4.68068 12.8721 4.68068 14.0554 4.25395 15.1145ZM9.60051 17.7078C9.56444 17.7982 9.5109 17.8806 9.44297 17.9503C9.37503 18.02 9.29402 18.0757 9.20457 18.1141C9.11512 18.1525 9.01898 18.1729 8.92164 18.1741C8.82431 18.1753 8.72769 18.1573 8.6373 18.1212C7.93029 17.8396 7.14226 17.8396 6.43525 18.1212C6.34424 18.1613 6.24609 18.1826 6.14666 18.1839C6.04723 18.1853 5.94855 18.1665 5.85651 18.1289C5.76446 18.0913 5.68092 18.0356 5.61087 17.965C5.54083 17.8944 5.48571 17.8104 5.44879 17.7181C5.41188 17.6258 5.39393 17.527 5.39602 17.4275C5.3981 17.3281 5.42017 17.2301 5.46092 17.1394C5.50167 17.0487 5.56026 16.9672 5.6332 16.8996C5.70614 16.832 5.79194 16.7798 5.88548 16.746C6.94434 16.3178 8.12821 16.3178 9.18707 16.746C9.3693 16.8189 9.51519 16.9611 9.5927 17.1414C9.67021 17.3217 9.67302 17.5254 9.60051 17.7078ZM10.5 13.4637C9.91383 13.4637 9.34082 13.2899 8.85344 12.9642C8.36606 12.6386 7.98619 12.1757 7.76187 11.6342C7.53756 11.0926 7.47887 10.4967 7.59322 9.92181C7.70758 9.3469 7.98985 8.81881 8.40433 8.40433C8.81881 7.98985 9.3469 7.70758 9.92181 7.59322C10.4967 7.47887 11.0926 7.53756 11.6342 7.76187C12.1757 7.98619 12.6386 8.36606 12.9642 8.85344C13.2899 9.34082 13.4637 9.91383 13.4637 10.5C13.4637 11.286 13.1515 12.0399 12.5957 12.5957C12.0399 13.1515 11.286 13.4637 10.5 13.4637ZM15.1145 4.25395C14.0554 4.68083 12.8721 4.68083 11.8129 4.25395C11.7194 4.22022 11.6336 4.16801 11.5606 4.10043C11.4877 4.03284 11.4291 3.95127 11.3884 3.86056C11.3476 3.76986 11.3255 3.67188 11.3235 3.57246C11.3214 3.47304 11.3393 3.37423 11.3762 3.28189C11.4132 3.18956 11.4683 3.1056 11.5383 3.03502C11.6084 2.96444 11.6919 2.90868 11.784 2.87106C11.876 2.83345 11.9747 2.81475 12.0741 2.81607C12.1735 2.8174 12.2717 2.83873 12.3627 2.87878C13.0697 3.16038 13.8577 3.16038 14.5647 2.87878C14.6558 2.83873 14.7539 2.8174 14.8533 2.81607C14.9528 2.81475 15.0514 2.83345 15.1435 2.87106C15.2355 2.90868 15.3191 2.96444 15.3891 3.03502C15.4592 3.1056 15.5143 3.18956 15.5512 3.28189C15.5881 3.37423 15.6061 3.47304 15.604 3.57246C15.6019 3.67188 15.5798 3.76986 15.5391 3.86056C15.4983 3.95127 15.4397 4.03284 15.3668 4.10043C15.2939 4.16801 15.2081 4.22022 15.1145 4.25395ZM18.1212 8.6373C18.1613 8.72831 18.1826 8.82646 18.1839 8.92589C18.1853 9.02532 18.1665 9.124 18.1289 9.21604C18.0913 9.30809 18.0356 9.39163 17.965 9.46168C17.8944 9.53172 17.8104 9.58684 17.7181 9.62376C17.6258 9.66067 17.527 9.67862 17.4275 9.67653C17.3281 9.67445 17.2301 9.65238 17.1394 9.61163C17.0487 9.57088 16.9672 9.51229 16.8996 9.43935C16.832 9.36641 16.7798 9.28061 16.746 9.18707C16.3193 8.12791 16.3193 6.94464 16.746 5.88548C16.7798 5.79194 16.832 5.70614 16.8996 5.6332C16.9672 5.56026 17.0487 5.50167 17.1394 5.46092C17.2301 5.42017 17.3281 5.3981 17.4275 5.39602C17.527 5.39393 17.6258 5.41188 17.7181 5.44879C17.8104 5.48571 17.8944 5.54083 17.965 5.61087C18.0356 5.68092 18.0913 5.76446 18.1289 5.85651C18.1665 5.94855 18.1853 6.04723 18.1839 6.14666C18.1826 6.24609 18.1613 6.34424 18.1212 6.43525C17.8411 7.14255 17.8411 7.93 18.1212 8.6373Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_44_140">
                                <rect width="24" height="24" fill="white"/>
                                </clipPath>
                                </defs>
                            </svg>                                                               
                        </div>
                    </div>
                    <div class="pos-info flex-1">
                        <span class="text-muted d-block mb-1"><?php echo e(__('Total')); ?></span>
                        <h3 class="h6 m-0">
                            <a href="<?php echo e(route('purchase.index')); ?>" class="dashboard-link"><?php echo e(__(' Purchase Amount')); ?></a>
                        </h3>
                    </div>
                </div>
                <div class="pos-price text-center">
                    <h4><?php echo e($pos_data['totalPurchaseAmount']); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row ">
                        <div class="col-6">
                            <h5><?php echo e(__('Purchase Vs POS Report')); ?></h5>
                        </div>
                        <div class="col-6 text-end">
                            <h6><?php echo e(__('Last 10 Days')); ?></h6>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div id="traffic-chart"></div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleversysco/public_html/erp.cleversys.co.ke/resources/views/dashboard/pos-dashboard.blade.php ENDPATH**/ ?>