<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Manage Job')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Job')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>


    <script>
        function copyToClipboard(element) {

            var copyText = element.id;
            navigator.clipboard.writeText(copyText);
            // document.addEventListener('copy', function (e) {
            //     e.clipboardData.setData('text/plain', copyText);
            //     e.preventDefault();
            // }, true);
            //
            // document.execCommand('copy');
            show_toastr('success', 'Url copied to clipboard', 'success');
        }
    </script>


<?php $__env->stopPush(); ?>


<?php $__env->startSection('action-btn'); ?>
    <div class="float-end">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create job')): ?>
            <a href="<?php echo e(route('job.create')); ?>" class="btn btn-sm btn-primary"  data-bs-toggle="tooltip" title="<?php echo e(__('Create')); ?>" data-title="<?php echo e(__('Create New Job')); ?>">
                <i class="ti ti-plus"></i>
            </a>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mb-4 gy-4">
        <div class="col-xl-4 col-sm-6 col-12 job-info-card">
            <div class="job-card-inner d-flex align-items-center gap-3">
                <div class="job-icon">
                    <div class="job-icon-inner">
                        <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.7617 17.5703C14.1823 17.5703 14.5234 17.2293 14.5234 16.8086V13.7617C14.5234 13.3411 14.1825 13 13.7617 13H12.2383C11.8177 13 11.4766 13.3409 11.4766 13.7617V16.8086C11.4766 17.2292 11.8176 17.5703 12.2383 17.5703H13.7617Z" fill="white"/>
                            <path d="M23.7148 4.62109H18.332C18.332 4.46768 18.332 3.70596 18.332 3.85938C18.332 2.59929 17.307 1.57422 16.0469 1.57422C15.8815 1.57422 9.72689 1.57422 9.95312 1.57422C8.69304 1.57422 7.66797 2.59924 7.66797 3.85938C7.66797 4.01279 7.66797 4.7745 7.66797 4.62109H2.28516C1.02507 4.62109 0 5.64611 0 6.90625C0 8.39805 0.182813 9.7045 0.545797 10.8179C0.908781 11.9313 1.45199 12.8516 2.17283 13.5713C3.38584 14.7827 4.93091 15.2852 6.6658 15.2852H9.95312C9.95312 15.1317 9.95312 13.6083 9.95312 13.7617C9.95312 12.5016 10.9781 11.4766 12.2383 11.4766C12.3917 11.4766 13.9151 11.4766 13.7617 11.4766C15.0218 11.4766 16.0469 12.5016 16.0469 13.7617C16.0469 13.9151 16.0469 15.4386 16.0469 15.2852H17.7394C19.2557 15.2221 21.736 15.6832 23.8264 13.6025C24.5476 12.8847 25.091 11.9627 25.4541 10.8441C25.8172 9.72547 26 8.41034 26 6.90625C26 5.64616 24.975 4.62109 23.7148 4.62109ZM9.19141 3.85938C9.19141 3.43911 9.53281 3.09766 9.95312 3.09766H16.0469C16.4671 3.09766 16.8086 3.43906 16.8086 3.85938C16.8086 4.01279 16.8086 4.7745 16.8086 4.62109H9.19141C9.19141 4.46768 9.19141 3.70596 9.19141 3.85938Z" fill="white"/>
                            <path d="M17.7602 16.8087H16.0469C16.0469 18.0688 15.0219 19.0938 13.7617 19.0938C13.6083 19.0938 12.0849 19.0938 12.2383 19.0938C10.9782 19.0938 9.95312 18.0688 9.95312 16.8087C9.7791 16.8087 6.48436 16.8087 6.67245 16.8087C4.49983 16.8087 2.59152 16.142 1.09642 14.6493C0.67407 14.2276 0.313422 13.7529 0 13.2451V23.6642C0 24.0852 0.340691 24.4259 0.761719 24.4259H25.2383C25.6593 24.4259 26 24.0852 26 23.6642V13.2764C25.6824 13.7919 25.3202 14.2656 24.9013 14.6827C22.4978 17.0737 19.9381 16.7058 17.7602 16.8087Z" fill="white"/>
                        </svg>
                    </div>
                </div>
                <div class="job-content flex-1">
                    <span class="text-muted text-sm d-block mb-1"><?php echo e(__('Total')); ?></span>
                    <h2 class="h5 mb-0"><?php echo e(__('Jobs')); ?></h2>
                </div>
                <h3 class="mb-0"><?php echo e($data['total']); ?></h3>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6 col-12 job-info-card">
            <div class="job-card-inner d-flex align-items-center gap-3">
                <div class="job-icon">
                    <div class="job-icon-inner">
                        <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.7617 17.5703C14.1823 17.5703 14.5234 17.2293 14.5234 16.8086V13.7617C14.5234 13.3411 14.1825 13 13.7617 13H12.2383C11.8177 13 11.4766 13.3409 11.4766 13.7617V16.8086C11.4766 17.2292 11.8176 17.5703 12.2383 17.5703H13.7617Z" fill="white"/>
                            <path d="M23.7148 4.62109H18.332C18.332 4.46768 18.332 3.70596 18.332 3.85938C18.332 2.59929 17.307 1.57422 16.0469 1.57422C15.8815 1.57422 9.72689 1.57422 9.95312 1.57422C8.69304 1.57422 7.66797 2.59924 7.66797 3.85938C7.66797 4.01279 7.66797 4.7745 7.66797 4.62109H2.28516C1.02507 4.62109 0 5.64611 0 6.90625C0 8.39805 0.182813 9.7045 0.545797 10.8179C0.908781 11.9313 1.45199 12.8516 2.17283 13.5713C3.38584 14.7827 4.93091 15.2852 6.6658 15.2852H9.95312C9.95312 15.1317 9.95312 13.6083 9.95312 13.7617C9.95312 12.5016 10.9781 11.4766 12.2383 11.4766C12.3917 11.4766 13.9151 11.4766 13.7617 11.4766C15.0218 11.4766 16.0469 12.5016 16.0469 13.7617C16.0469 13.9151 16.0469 15.4386 16.0469 15.2852H17.7394C19.2557 15.2221 21.736 15.6832 23.8264 13.6025C24.5476 12.8847 25.091 11.9627 25.4541 10.8441C25.8172 9.72547 26 8.41034 26 6.90625C26 5.64616 24.975 4.62109 23.7148 4.62109ZM9.19141 3.85938C9.19141 3.43911 9.53281 3.09766 9.95312 3.09766H16.0469C16.4671 3.09766 16.8086 3.43906 16.8086 3.85938C16.8086 4.01279 16.8086 4.7745 16.8086 4.62109H9.19141C9.19141 4.46768 9.19141 3.70596 9.19141 3.85938Z" fill="white"/>
                            <path d="M17.7602 16.8087H16.0469C16.0469 18.0688 15.0219 19.0938 13.7617 19.0938C13.6083 19.0938 12.0849 19.0938 12.2383 19.0938C10.9782 19.0938 9.95312 18.0688 9.95312 16.8087C9.7791 16.8087 6.48436 16.8087 6.67245 16.8087C4.49983 16.8087 2.59152 16.142 1.09642 14.6493C0.67407 14.2276 0.313422 13.7529 0 13.2451V23.6642C0 24.0852 0.340691 24.4259 0.761719 24.4259H25.2383C25.6593 24.4259 26 24.0852 26 23.6642V13.2764C25.6824 13.7919 25.3202 14.2656 24.9013 14.6827C22.4978 17.0737 19.9381 16.7058 17.7602 16.8087Z" fill="white"/>
                        </svg>
                    </div>
                </div>
                <div class="job-content flex-1">
                    <span class="text-muted text-sm d-block mb-1"><?php echo e(__('Active')); ?></span>
                    <h2 class="h5 mb-0"><?php echo e(__('Jobs')); ?></h2>
                </div>
                <h3 class="mb-0"><?php echo e($data['active']); ?></h3>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6 col-12 job-info-card">
            <div class="job-card-inner d-flex align-items-center gap-3">
                <div class="job-icon">
                    <div class="job-icon-inner">
                        <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.7617 17.5703C14.1823 17.5703 14.5234 17.2293 14.5234 16.8086V13.7617C14.5234 13.3411 14.1825 13 13.7617 13H12.2383C11.8177 13 11.4766 13.3409 11.4766 13.7617V16.8086C11.4766 17.2292 11.8176 17.5703 12.2383 17.5703H13.7617Z" fill="white"/>
                            <path d="M23.7148 4.62109H18.332C18.332 4.46768 18.332 3.70596 18.332 3.85938C18.332 2.59929 17.307 1.57422 16.0469 1.57422C15.8815 1.57422 9.72689 1.57422 9.95312 1.57422C8.69304 1.57422 7.66797 2.59924 7.66797 3.85938C7.66797 4.01279 7.66797 4.7745 7.66797 4.62109H2.28516C1.02507 4.62109 0 5.64611 0 6.90625C0 8.39805 0.182813 9.7045 0.545797 10.8179C0.908781 11.9313 1.45199 12.8516 2.17283 13.5713C3.38584 14.7827 4.93091 15.2852 6.6658 15.2852H9.95312C9.95312 15.1317 9.95312 13.6083 9.95312 13.7617C9.95312 12.5016 10.9781 11.4766 12.2383 11.4766C12.3917 11.4766 13.9151 11.4766 13.7617 11.4766C15.0218 11.4766 16.0469 12.5016 16.0469 13.7617C16.0469 13.9151 16.0469 15.4386 16.0469 15.2852H17.7394C19.2557 15.2221 21.736 15.6832 23.8264 13.6025C24.5476 12.8847 25.091 11.9627 25.4541 10.8441C25.8172 9.72547 26 8.41034 26 6.90625C26 5.64616 24.975 4.62109 23.7148 4.62109ZM9.19141 3.85938C9.19141 3.43911 9.53281 3.09766 9.95312 3.09766H16.0469C16.4671 3.09766 16.8086 3.43906 16.8086 3.85938C16.8086 4.01279 16.8086 4.7745 16.8086 4.62109H9.19141C9.19141 4.46768 9.19141 3.70596 9.19141 3.85938Z" fill="white"/>
                            <path d="M17.7602 16.8087H16.0469C16.0469 18.0688 15.0219 19.0938 13.7617 19.0938C13.6083 19.0938 12.0849 19.0938 12.2383 19.0938C10.9782 19.0938 9.95312 18.0688 9.95312 16.8087C9.7791 16.8087 6.48436 16.8087 6.67245 16.8087C4.49983 16.8087 2.59152 16.142 1.09642 14.6493C0.67407 14.2276 0.313422 13.7529 0 13.2451V23.6642C0 24.0852 0.340691 24.4259 0.761719 24.4259H25.2383C25.6593 24.4259 26 24.0852 26 23.6642V13.2764C25.6824 13.7919 25.3202 14.2656 24.9013 14.6827C22.4978 17.0737 19.9381 16.7058 17.7602 16.8087Z" fill="white"/>
                        </svg>
                    </div>
                </div>
                <div class="job-content flex-1">
                    <span class="text-muted text-sm d-block mb-1"><?php echo e(__('Inactive')); ?></span>
                    <h2 class="h5 mb-0"><?php echo e(__('Jobs')); ?></h2>
                </div>
                <h3 class="mb-0"><?php echo e($data['in_active']); ?></h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
            <div class="card-body table-border-style">
                    <div class="table-responsive">
                    <table class="table datatable">
                            <thead>
                            <tr>
                                <th><?php echo e(__('Branch')); ?></th>
                                <th><?php echo e(__('Title')); ?></th>
                                <th><?php echo e(__('Start Date')); ?></th>
                                <th><?php echo e(__('End Date')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Created At')); ?></th>
                                <?php if( Gate::check('edit job') ||Gate::check('delete job') ||Gate::check('show job')): ?>
                                    <th width="200px"><?php echo e(__('Action')); ?></th>
                                <?php endif; ?>
                            </tr>
                            </thead>
                            <tbody class="font-style">
                            <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(!empty($job->branches)?$job->branches->name:__('All')); ?></td>
                                    <td><?php echo e($job->title); ?></td>
                                    <td><?php echo e(\Auth::user()->dateFormat($job->start_date)); ?></td>
                                    <td><?php echo e(\Auth::user()->dateFormat($job->end_date)); ?></td>
                                    <td>
                                        <?php if($job->status=='active'): ?>
                                            <span class="status_badge badge bg-primary p-2 px-3 rounded"><?php echo e(App\Models\Job::$status[$job->status]); ?></span>
                                        <?php else: ?>
                                            <span class="status_badge badge bg-danger p-2 px-3 rounded"><?php echo e(App\Models\Job::$status[$job->status]); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(\Auth::user()->dateFormat($job->created_at)); ?></td>
                                    <?php if( Gate::check('edit job') ||Gate::check('delete job') || Gate::check('show job')): ?>
                                        <td>

                                        <?php if($job->status!='in_active'): ?>








                                                <div class="action-btn me-2">
                                                    <a href="#" id="<?php echo e(route('job.requirement',[$job->code,!empty($job)?$job->createdBy->lang:'en'])); ?>" class="mx-3 btn btn-sm align-items-center bg-secondary"  onclick="copyToClipboard(this)" data-bs-toggle="tooltip" title="<?php echo e(__('Copy')); ?>" data-original-title="<?php echo e(__('Click to copy')); ?>"><i class="ti ti-link text-white"></i></a>
                                                </div>


                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show job')): ?>
                                            <div class="action-btn me-2">
                                                <a href="<?php echo e(route('job.show',$job->id)); ?>" data-title="<?php echo e(__('Job Detail')); ?>" title="<?php echo e(__('View')); ?>"  class="mx-3 btn btn-sm align-items-center bg-warning" data-bs-toggle="tooltip" data-original-title="<?php echo e(__('View Detail')); ?>">
                                                    <i class="ti ti-eye text-white"></i></a>
                                            </div>
                                                <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit job')): ?>
                                            <div class="action-btn me-2">
                                                <a href="<?php echo e(route('job.edit',$job->id)); ?>" data-title="<?php echo e(__('Edit Job')); ?>" class="mx-3 btn btn-sm align-items-center bg-info" data-bs-toggle="tooltip" title="<?php echo e(__('Edit')); ?>" data-original-title="<?php echo e(__('Edit')); ?>">
                                                    <i class="ti ti-pencil text-white"></i></a>
                                            </div>
                                                <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete job')): ?>
                                            <div class="action-btn ">
                                            <?php echo Form::open(['method' => 'DELETE', 'route' => ['job.destroy', $job->id],'id'=>'delete-form-'.$job->id]); ?>


                                                <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para bg-danger" data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>" data-original-title="<?php echo e(__('Delete')); ?>" data-confirm="<?php echo e(__('Are You Sure?').'|'.__('This action can not be undone. Do you want to continue?')); ?>" data-confirm-yes="document.getElementById('delete-form-<?php echo e($job->id); ?>').submit();">
                                                    <i class="ti ti-trash text-white"></i></a>
                                                <?php echo Form::close(); ?>

                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleversysco/public_html/erp.cleversys.co.ke/resources/views/job/index.blade.php ENDPATH**/ ?>