<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
    <script>

    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('CRM')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mb-4 gy-3">
        <div class="col-xl-4 col-sm-6 col-12 crm-dash-card">
            <div class="crm-card-inner d-flex align-items-center gap-3">
                <div class="crm-icon">
                    <div class="crm-icon-inner">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.07199 11.971L9.36289 10.6801C9.63926 10.4037 9.63926 9.95644 9.36289 9.68008L7.53017 7.84735C7.2538 7.57098 6.80653 7.57098 6.53017 7.84735L5.23926 9.13826L8.07199 11.971Z" fill="white"/>
                            <path d="M14.2684 14.5855C13.9921 14.3091 13.5448 14.3091 13.2684 14.5855L11.9775 15.8764L14.8103 18.7091L16.1012 17.4182C16.3775 17.1419 16.3775 16.6946 16.1012 16.4182L14.2684 14.5855Z" fill="white"/>
                            <path d="M14.5819 6.90553C14.5528 6.88371 14.5237 6.85825 14.5019 6.82553C13.8583 5.87643 12.7928 5.30916 11.6474 5.29462C11.6328 5.29462 11.6219 5.29825 11.6074 5.29825C11.5928 5.29825 11.5819 5.29462 11.5674 5.29462C10.4219 5.30916 9.35645 5.87643 8.71281 6.82553C8.69099 6.85825 8.6619 6.88007 8.63281 6.90553C9.3419 7.76371 10.4074 8.3128 11.6074 8.3128C12.8074 8.3128 13.8728 7.76371 14.5819 6.90553Z" fill="white"/>
                            <path d="M10.3051 4.78914C10.196 4.69096 10.0978 4.57823 10.0106 4.45096C9.79239 4.12732 9.67603 3.75277 9.67603 3.36368C9.67603 2.29823 10.5415 1.43277 11.6069 1.43277C12.6724 1.43277 13.5378 2.29823 13.5378 3.36368C13.5378 3.74914 13.4215 4.12732 13.2033 4.44732C13.1197 4.57096 13.0178 4.68368 12.9088 4.7855C13.7378 5.05459 14.4651 5.57459 14.9924 6.29096C15.2906 5.74186 15.4615 5.11641 15.4615 4.45096C15.4615 2.32005 13.7342 0.592773 11.6033 0.592773C9.47239 0.592773 7.74512 2.32005 7.74512 4.45096C7.74512 5.12005 7.91966 5.74186 8.21421 6.29096C8.74875 5.57823 9.47966 5.05823 10.3051 4.78914Z" fill="white"/>
                            <path d="M11.5817 4.57823H11.6071C11.6071 4.57823 11.6253 4.57823 11.6326 4.57823C12.0253 4.57095 12.3889 4.37459 12.6108 4.05095C12.7489 3.84732 12.8217 3.61095 12.8217 3.36732C12.8217 2.69823 12.2762 2.15277 11.6071 2.15277C10.938 2.15277 10.3926 2.69823 10.3926 3.36732C10.3926 3.61095 10.4653 3.84732 10.6035 4.05095C10.8253 4.37459 11.1889 4.57095 11.5817 4.57823Z" fill="white"/>
                            <path d="M20.1083 13.0582H20.1302H20.152C20.472 13.051 20.7702 12.891 20.952 12.6255C21.0647 12.4582 21.1229 12.2655 21.1229 12.0655C21.1229 11.5164 20.6756 11.0692 20.1265 11.0692C19.5774 11.0692 19.1338 11.5164 19.1338 12.0655C19.1338 12.2655 19.192 12.4582 19.3083 12.6255C19.4902 12.891 19.7883 13.051 20.1083 13.0582Z" fill="white"/>
                            <path d="M20.1305 9.68005C18.2978 9.68005 16.8105 11.1673 16.8105 13.0001C16.8105 13.5564 16.9524 14.0728 17.1924 14.5346C17.636 13.9419 18.236 13.5055 18.916 13.2655C18.8433 13.1928 18.7742 13.1128 18.716 13.0255C18.5233 12.7382 18.4215 12.4037 18.4215 12.0619C18.4215 11.1201 19.1887 10.3491 20.1305 10.3491C21.0724 10.3491 21.8433 11.1164 21.8433 12.0619C21.8433 12.4037 21.7415 12.7382 21.5487 13.0219C21.4905 13.1091 21.4215 13.1891 21.3451 13.2619C22.0287 13.5019 22.6287 13.9382 23.0687 14.531C23.3087 14.0728 23.4505 13.5528 23.4505 12.9964C23.4505 11.1673 21.9633 9.68005 20.1305 9.68005Z" fill="white"/>
                            <path d="M20.1674 13.7746C20.1565 13.7746 20.1456 13.7782 20.1347 13.7782C20.1238 13.7782 20.1129 13.7746 20.102 13.7746C19.1311 13.7855 18.2329 14.2691 17.6874 15.0691C17.6656 15.1019 17.6365 15.1273 17.6074 15.1491C18.2183 15.8655 19.1238 16.3201 20.1347 16.3201C21.1492 16.3201 22.0547 15.8655 22.6656 15.1491C22.6365 15.1273 22.6074 15.1019 22.5856 15.0691C22.0365 14.2655 21.1347 13.7855 20.1674 13.7746Z" fill="white"/>
                            <path d="M17.9855 6.88002C17.9709 6.8982 17.9528 6.90911 17.9346 6.92366C18.4255 7.41457 19.0982 7.71639 19.8473 7.71639C20.5964 7.71639 21.2728 7.41093 21.76 6.92002C21.7418 6.90548 21.7237 6.89457 21.7091 6.87639C21.2582 6.29457 20.5818 5.96002 19.8473 5.96002C19.1128 5.96002 18.4364 6.2982 17.9855 6.88002Z" fill="white"/>
                            <path d="M18.7419 5.45459C18.7055 5.41459 18.6728 5.37095 18.6401 5.32368C18.4728 5.07641 18.3855 4.79641 18.3855 4.50186C18.3855 3.69822 19.0401 3.04368 19.8437 3.04368C20.6473 3.04368 21.3019 3.69822 21.3019 4.50186C21.3019 4.79277 21.2146 5.07641 21.051 5.32368C21.0182 5.37095 20.9855 5.41459 20.9491 5.45459C21.4255 5.64004 21.851 5.94186 22.1891 6.3455C22.411 5.95277 22.5491 5.50186 22.5491 5.01822C22.5491 3.52368 21.3382 2.31641 19.8473 2.31641C18.3528 2.31641 17.1455 3.52732 17.1455 5.01822C17.1455 5.50186 17.2801 5.95277 17.5055 6.3455C17.8437 5.94186 18.2655 5.64004 18.7419 5.45459Z" fill="white"/>
                            <path d="M19.8473 5.24731C20.0946 5.24731 20.3237 5.12731 20.4618 4.92367C20.5455 4.80004 20.5891 4.65458 20.5891 4.50549C20.5891 4.09458 20.2546 3.76367 19.8473 3.76367C19.44 3.76367 19.1055 4.09822 19.1055 4.50549C19.1055 4.65458 19.1491 4.80004 19.2364 4.92367C19.3746 5.12731 19.6037 5.24731 19.8473 5.24731Z" fill="white"/>
                            <path d="M12.1964 13.7455C12.2401 13.7637 12.2873 13.7746 12.3346 13.7746C12.4728 13.7746 12.6073 13.6909 12.6655 13.5564L13.3892 11.8219C13.4364 11.7128 13.4219 11.5855 13.3564 11.4837C13.291 11.3855 13.1782 11.3237 13.0582 11.3237H12.131L12.5892 10.1382C12.6619 9.95277 12.5673 9.74549 12.3855 9.6764C12.2037 9.60368 11.9928 9.69822 11.9237 9.88004L11.2728 11.5491C11.2292 11.6582 11.2437 11.7819 11.3128 11.88C11.3782 11.9782 11.491 12.0364 11.6073 12.0364H12.5201L12.0037 13.2764C11.9273 13.4582 12.0146 13.6691 12.1964 13.7455Z" fill="white"/>
                            <path d="M3.67257 6.04006C3.74893 6.12733 3.8653 6.17461 3.9853 6.16006C4.10166 6.14551 4.20348 6.07642 4.25802 5.97097L4.67984 5.16006L5.53802 6.19279C5.61075 6.27642 5.71257 6.3237 5.81439 6.3237C5.89439 6.3237 5.97439 6.29824 6.04348 6.24006C6.19621 6.11279 6.21802 5.88733 6.09075 5.73461L4.88711 4.28733C4.81075 4.19642 4.69075 4.14551 4.57439 4.16006C4.45439 4.17097 4.34893 4.2437 4.29439 4.34915L3.8653 5.17097L3.02893 4.21824C2.89802 4.06915 2.67257 4.05461 2.52348 4.18551C2.37439 4.31642 2.35984 4.54188 2.49075 4.69097L3.67257 6.04006Z" fill="white"/>
                            <path d="M19.1014 18.9455L18.2069 19.2L18.3232 17.9346C18.3414 17.7382 18.1959 17.5637 17.9996 17.5455C17.8032 17.5273 17.6287 17.6728 17.6105 17.8691L17.4469 19.6546C17.4359 19.7709 17.4832 19.8873 17.5741 19.9637C17.665 20.04 17.7887 20.0655 17.9014 20.0328L18.7778 19.7818L18.6178 21.1164C18.596 21.3128 18.7341 21.4909 18.9305 21.5128C18.945 21.5128 18.9596 21.5164 18.9741 21.5164C19.1523 21.5164 19.3087 21.3818 19.3305 21.2L19.5523 19.3309C19.5669 19.2109 19.5196 19.0946 19.4287 19.0146C19.3414 18.9418 19.2178 18.9128 19.1014 18.9455Z" fill="white"/>
                            <path d="M9.4324 18.4219C8.39603 19.4582 6.7124 19.5746 5.61058 18.611C4.97785 18.0582 4.66512 17.2946 4.66512 16.5273C4.66149 15.8219 4.93058 15.1164 5.4724 14.5746L7.57058 12.4764L4.73785 9.64368L2.53058 11.8509C-0.113058 14.4946 -0.113058 18.7782 2.53058 21.4182L2.53422 21.4219C5.17785 24.0655 9.46149 24.0655 12.1015 21.4219L14.3088 19.2146L11.476 16.3819L9.4324 18.4219Z" fill="white"/>
                        </svg>                            
                    </div>
                </div>
                <div class="crm-content">
                    <h2 class="h5 m-0">
                        <a href="<?php echo e(route('leads.index')); ?>" class="dashboard-link"><?php echo e(__('Total Lead')); ?></a>
                    </h2>
                </div>
                <h3 class="m-0"><?php echo e($crm_data['total_leads']); ?></h3>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6 col-12 crm-dash-card">
            <div class="crm-card-inner d-flex align-items-center gap-3">
                <div class="crm-icon">
                    <div class="crm-icon-inner">
                        <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_33_1046)">
                            <g clip-path="url(#clip1_33_1046)">
                            <path d="M13 4.46451C13.3883 4.46451 13.7031 4.14969 13.7031 3.76138V1.43915C13.7031 1.05084 13.3883 0.736023 13 0.736023C12.6117 0.736023 12.2969 1.05084 12.2969 1.43915V3.76138C12.2969 4.14969 12.6117 4.46451 13 4.46451Z" fill="white"/>
                            <path d="M16.2813 5.65789C16.4612 5.65789 16.6412 5.58921 16.7784 5.45192L18.6534 3.57692C18.928 3.30237 18.928 2.85715 18.6534 2.58256C18.3789 2.30801 17.9337 2.30801 17.6591 2.58256L15.7841 4.45756C15.5095 4.73211 15.5095 5.17732 15.7841 5.45192C15.9214 5.58921 16.1013 5.65789 16.2813 5.65789Z" fill="white"/>
                            <path d="M9.22162 5.45198C9.35891 5.58928 9.53887 5.65795 9.71877 5.65795C9.89868 5.65795 10.0787 5.58928 10.2159 5.45198C10.4905 5.17743 10.4905 4.73221 10.2159 4.45762L8.34093 2.58262C8.06638 2.30807 7.62116 2.30807 7.34657 2.58262C7.07198 2.85717 7.07198 3.30238 7.34657 3.57698L9.22162 5.45198Z" fill="white"/>
                            <path d="M19.3155 10.6737L16.586 7.94426C16.0585 7.41678 15.3432 7.12048 14.5972 7.12048H10.3279C9.26359 7.12048 8.26305 7.53495 7.51052 8.28748L7.2858 8.51216L7.27127 8.52669H1.70312C1.31481 8.52669 1 8.8415 1 9.22981V16.7298C1 17.1181 1.31481 17.4329 1.70312 17.4329H5.20877L6.87784 19.102C7.0097 19.2338 7.18853 19.3079 7.375 19.3079H8.01166C7.77602 18.9432 7.62433 18.5358 7.56494 18.1092C7.03928 17.9382 6.56627 17.6225 6.20195 17.1883C5.14286 15.926 5.30809 14.0375 6.5703 12.9784L9.24273 10.736H14.5787C14.7652 10.736 14.944 10.81 15.0759 10.9419L17.0391 12.9051C17.6696 13.5357 18.715 13.5491 19.3348 12.9079C19.9368 12.2851 19.9303 11.2886 19.3155 10.6737Z" fill="white"/>
                            <path d="M25 10.683C25 10.2946 24.6852 9.97981 24.2969 9.97986H20.5719C21.4709 11.1551 21.3841 12.8477 20.3099 13.922C19.7437 14.4882 18.9903 14.7999 18.1886 14.7999C17.3868 14.7999 16.6334 14.4882 16.0673 13.922L14.2876 12.1422H9.62299L9.07067 12.6057L7.28684 14.1025C6.61751 14.6641 6.53023 15.662 7.09184 16.3313C7.65345 17.0007 8.65132 17.0879 9.32065 16.5263C8.65132 17.0879 8.56404 18.0858 9.12565 18.7551C9.68726 19.4245 10.6851 19.5117 11.3545 18.9501C10.6851 19.5117 10.5979 20.5096 11.1595 21.179C11.7211 21.8483 12.7189 21.9356 13.3883 21.374L14.6335 20.3291L14.4656 20.47C13.7962 21.0316 13.7089 22.0295 14.2706 22.6988C14.8322 23.3682 15.83 23.4554 16.4994 22.8938L21.2756 18.886H24.297C24.6853 18.886 25.0001 18.5712 25.0001 18.1829L25 10.683Z" fill="white"/>
                            </g>
                            </g>
                            <defs>
                            <clipPath id="clip0_33_1046">
                            <rect width="24.4708" height="24.4708" fill="white" transform="translate(0.493164 0.119141)"/>
                            </clipPath>
                            <clipPath id="clip1_33_1046">
                            <rect width="24" height="24" fill="white" transform="translate(1 6.10352e-05)"/>
                            </clipPath>
                            </defs>
                        </svg>                                                      
                    </div>
                </div>
                <div class="crm-content">
                    <h2 class="h5 m-0">
                        <a href="<?php echo e(route('deals.index')); ?>" class="dashboard-link"><?php echo e(__('Total Deal')); ?></a>
                    </h2>
                </div>
                <h3 class="m-0"><?php echo e($crm_data['total_deals']); ?></h3>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6 col-12 crm-dash-card">
            <div class="crm-card-inner d-flex align-items-center gap-3">
                <div class="crm-icon">
                    <div class="crm-icon-inner">
                        <svg width="18" height="25" viewBox="0 0 18 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M17.8529 5.1819L12.8541 0.183104C12.7636 0.0923076 12.6385 0.0360107 12.5 0.0360107H2.00002C0.897469 0.0360107 0 0.932964 0 2.03603V22.036C0 23.1391 0.897469 24.036 2.00002 24.036H16C17.1025 24.036 18 23.1391 18 22.036V5.536C18 5.39753 17.9437 5.27242 17.8529 5.1819ZM3.50002 5.03603H9.50002C9.77639 5.03603 10 5.25967 10 5.53604C10 5.81242 9.77639 6.03606 9.50002 6.03606H3.50002C3.22364 6.03606 3 5.81242 3 5.53604C3 5.25967 3.22364 5.03603 3.50002 5.03603ZM10.8506 18.8925C8.67384 21.036 8.16698 21.036 8.00002 21.036C7.37892 21.036 7.15627 20.3231 6.92578 19.5594C6.57713 20.267 6.17578 21.036 5.49998 21.036C5.15231 21.036 4.7363 20.807 4.3447 20.4584C4.15819 20.6439 3.97261 20.8065 3.79978 20.9359C3.70992 21.0033 3.60445 21.036 3.49997 21.036C3.34861 21.036 3.19819 20.9672 3.09956 20.8358C2.93452 20.6151 2.97942 20.3016 3.20016 20.1361C3.35836 20.0169 3.51952 19.8734 3.67772 19.7152C3.28027 19.1669 3 18.5419 3 18.036C3 16.8949 3.91017 16.036 4.5 16.036C5.08008 16.036 6 16.4432 6 17.536C6 18.1727 5.55759 18.9964 5.00681 19.7079C5.21091 19.8983 5.39648 20.0247 5.50486 20.036C5.6152 19.9584 5.91891 19.3402 6.06539 19.0433C6.36422 18.4368 6.56147 18.036 6.99998 18.036C7.5127 18.036 7.67184 18.5677 7.875 19.241C7.93458 19.4407 8.0332 19.7698 8.12011 19.9666C8.48728 19.7185 9.41405 18.9031 10.1494 18.1795C10.3467 17.9866 10.6631 17.9876 10.8564 18.1854C11.0498 18.3822 11.0479 18.6986 10.8506 18.8925ZM14.5 15.036H7.5C7.22363 15.036 6.99998 14.8124 6.99998 14.536C6.99998 14.2596 7.22363 14.036 7.5 14.036H14.5C14.7764 14.036 15 14.2596 15 14.536C15 14.8124 14.7764 15.036 14.5 15.036ZM14.5 12.036H3.50002C3.22364 12.036 3 11.8124 3 11.536C3 11.2596 3.22364 11.036 3.50002 11.036H14.5C14.7764 11.036 15 11.2596 15 11.536C15 11.8124 14.7764 12.036 14.5 12.036ZM14.5 9.03601H3.50002C3.22364 9.03601 3 8.81237 3 8.53599C3 8.25962 3.22364 8.03598 3.50002 8.03598H14.5C14.7764 8.03598 15 8.25962 15 8.53599C15 8.81237 14.7764 9.03601 14.5 9.03601ZM14 5.03603C13.4482 5.03603 13 4.58729 13 4.03604V1.74306L16.293 5.03603H14Z" fill="white"/>
                            <path d="M4.50002 17.036C4.44728 17.0692 4 17.4262 4 18.036C4 18.2918 4.14452 18.6132 4.34767 18.9227C4.7305 18.3929 5.00003 17.8549 5.00003 17.536C5.00003 17.0599 4.58303 17.036 4.50002 17.036Z" fill="white"/>
                        </svg>                                                    
                    </div>
                </div>
                <div class="crm-content">
                    <h2 class="h5 m-0">
                        <a href="<?php echo e(route('contract.index')); ?>" class="dashboard-link"><?php echo e(__('Total Contract')); ?></a>
                    </h2>
                </div>
                <h3 class="m-0"><?php echo e($crm_data['total_contracts']); ?></h3>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="card h-100 mb-0">
                <div class="card-header">
                    <h5><?php echo e(__('Lead Status')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row ">
                        <?php $__currentLoopData = $crm_data['lead_status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6 col-sm-6 mb-4">
                                <div class="align-items-start">
                                    <div class="ms-2">
                                        <p class="text-sm mb-2"><?php echo e($val['lead_stage']); ?></p>
                                        <h3 class="mb-2 text-primary"><?php echo e($val['lead_percentage']); ?>%</h3>
                                        <div class="progress mb-0">
                                            <div class="progress-bar bg-primary" style="width:<?php echo e($val['lead_percentage']); ?>%;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="card h-100 mb-0">
                <div class="card-header">
                    <h5><?php echo e(__('Deal Status')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row ">
                        <?php $__currentLoopData = $crm_data['deal_status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6 col-sm-6 mb-4">
                                <div class="align-items-start">
                                    <div class="ms-2">
                                        <p class="text-sm mb-2"><?php echo e($val['deal_stage']); ?></p>
                                        <h3 class="mb-2 text-primary"><?php echo e($val['deal_percentage']); ?>%</h3>
                                        <div class="progress mb-0">
                                            <div class="progress-bar bg-primary" style="width:<?php echo e($val['deal_percentage']); ?>%;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mt-1 mb-0"><?php echo e(__('Latest Contract')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th></th>
                                <th><?php echo e(__('Subject')); ?></th>
                                <?php if(\Auth::user()->type!='client'): ?>
                                <th><?php echo e(__('Client')); ?></th>
                                <?php endif; ?>
                                <th><?php echo e(__('Project')); ?></th>
                                <th><?php echo e(__('Contract Type')); ?></th>
                                <th><?php echo e(__('Contract Value')); ?></th>
                                <th><?php echo e(__('Start Date')); ?></th>
                                <th><?php echo e(__('End Date')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $crm_data['latestContract']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('contract.show',$contract->id)); ?>" class="btn btn-outline-primary"><?php echo e(\Auth::user()->contractNumberFormat($contract->id)); ?></a>
                                    </td>
                                    <td><?php echo e($contract->subject); ?></td>
                                    <?php if(\Auth::user()->type!='client'): ?>
                                        <td><?php echo e(!empty($contract->clients)?$contract->clients->name:'-'); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e(!empty($contract->projects)?$contract->projects->project_name:'-'); ?></td>
                                    <td><?php echo e(!empty($contract->types)?$contract->types->name:''); ?></td>
                                    <td><?php echo e(\Auth::user()->priceFormat($contract->value)); ?></td>
                                    <td><?php echo e(\Auth::user()->dateFormat($contract->start_date )); ?></td>
                                    <td><?php echo e(\Auth::user()->dateFormat($contract->end_date )); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8">
                                        <div class="text-center">
                                            <h6><?php echo e(__('There is no latest contract')); ?></h6>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gwbtkasu/public_html/erp.cleversys.co.ke/resources/views/dashboard/crm-dashboard.blade.php ENDPATH**/ ?>